/*
 * Decompiled with CFR 0.152.
 */
package act.cli.meta;

import act.Act;
import act.Destroyable;
import act.app.AppClassLoader;
import act.asm.Type;
import act.cli.meta.CommandParamMetaInfo;
import act.cli.meta.CommanderClassMetaInfo;
import act.cli.meta.FieldOptionAnnoInfo;
import act.cli.meta.OptionAnnoInfoBase;
import act.cli.meta.ParamOptionAnnoInfo;
import act.cli.view.CliView;
import act.sys.meta.InvokeType;
import act.sys.meta.ReturnTypeInfo;
import act.util.DestroyableBase;
import act.util.PropertySpec;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@ApplicationScoped
public class CommandMethodMetaInfo
extends DestroyableBase {
    private String methodName;
    private String commandName;
    private String helpMsg;
    private InvokeType invokeType;
    private CommanderClassMetaInfo clsInfo;
    private PropertySpec.MetaInfo propertySpec;
    private C.List<CommandParamMetaInfo> params = C.newList();
    private ReturnTypeInfo returnType;
    private Set<String> optionLeads = C.newSet();
    private CliView view = CliView.TO_STRING;
    private Act.Mode mode = Act.Mode.PROD;
    private int ctxParamCnt = -1;

    @Inject
    public CommandMethodMetaInfo(CommanderClassMetaInfo clsInfo) {
        this.clsInfo = (CommanderClassMetaInfo)$.NPE((Object)clsInfo);
    }

    public CommanderClassMetaInfo classInfo() {
        return this.clsInfo;
    }

    public CommandMethodMetaInfo methodName(String name) {
        this.methodName = (String)$.NPE((Object)name);
        return this;
    }

    public String methodName() {
        return this.methodName;
    }

    public CommandMethodMetaInfo view(CliView view) {
        this.view = (CliView)((Object)$.notNull((Object)((Object)view)));
        return this;
    }

    public CliView view() {
        return this.view;
    }

    public CommandMethodMetaInfo commandName(String name) {
        this.commandName = (String)$.NPE((Object)name);
        return this;
    }

    public String commandName() {
        return this.commandName;
    }

    public String fullName() {
        return S.newBuffer((String)this.clsInfo.className()).append(".").append(this.methodName()).toString();
    }

    public CommandMethodMetaInfo helpMsg(String msg) {
        this.helpMsg = msg;
        return this;
    }

    public String helpMsg() {
        return null == this.helpMsg ? "" : this.helpMsg;
    }

    public List<Osgl.T2<String, String>> options(CommanderClassMetaInfo classMetaInfo, AppClassLoader classLoader) {
        C.List retVal = C.newList();
        for (CommandParamMetaInfo param : this.params) {
            ParamOptionAnnoInfo opt = param.optionInfo();
            if (null == opt) continue;
            retVal.add($.T2((Object)opt.leads(), (Object)opt.help()));
        }
        for (OptionAnnoInfoBase opt : classMetaInfo.fieldOptionAnnoInfoList(classLoader)) {
            retVal.add($.T2((Object)opt.leads(), (Object)opt.help()));
        }
        return retVal;
    }

    public Osgl.T2<String, String> commandLine(CommanderClassMetaInfo classMetaInfo, AppClassLoader classLoader) {
        boolean hasOptions = classMetaInfo.hasOption(classLoader);
        String firstArg = null;
        boolean hasMoreArgs = false;
        for (CommandParamMetaInfo param : this.params) {
            if (param.optionInfo() != null) {
                hasOptions = true;
                continue;
            }
            if (firstArg == null) {
                firstArg = param.name();
                continue;
            }
            hasMoreArgs = true;
        }
        for (FieldOptionAnnoInfo fieldOptionAnnoInfo : classMetaInfo.fieldOptionAnnoInfoList(classLoader)) {
            hasOptions = true;
            if (null == firstArg) {
                firstArg = fieldOptionAnnoInfo.fieldName();
                continue;
            }
            hasMoreArgs = true;
        }
        S.Buffer sb = S.buffer((String)this.commandName);
        if (hasOptions) {
            sb.append(" [options]");
        }
        if (null != firstArg) {
            sb.append(" ");
            sb.append("[").append(firstArg);
            if (hasMoreArgs) {
                sb.append("...");
            }
            sb.append("]");
        }
        return $.T2((Object)sb.toString(), (Object)this.helpMsg());
    }

    public CommandMethodMetaInfo mode(Act.Mode mode) {
        this.mode = mode;
        return this;
    }

    public Act.Mode mode() {
        return this.mode;
    }

    public CommandMethodMetaInfo invokeStaticMethod() {
        this.invokeType = InvokeType.STATIC;
        return this;
    }

    public CommandMethodMetaInfo invokeInstanceMethod() {
        this.invokeType = InvokeType.VIRTUAL;
        return this;
    }

    public boolean isStatic() {
        return InvokeType.STATIC == this.invokeType;
    }

    public CommandMethodMetaInfo propertySpec(PropertySpec.MetaInfo propertySpec) {
        this.propertySpec = propertySpec;
        return this;
    }

    public PropertySpec.MetaInfo propertySpec() {
        return this.propertySpec;
    }

    public CommandMethodMetaInfo returnType(Type type) {
        this.returnType = ReturnTypeInfo.of(type);
        return this;
    }

    public Type returnType() {
        return this.returnType.type();
    }

    public CommandMethodMetaInfo addParam(CommandParamMetaInfo paramInfo) {
        this.params.add((Object)paramInfo);
        return this;
    }

    public C.List<CommandParamMetaInfo> params() {
        return C.list(this.params);
    }

    public CommandParamMetaInfo param(int id) {
        return (CommandParamMetaInfo)this.params.get(id);
    }

    public int paramCount() {
        return this.params.size();
    }

    public CommandMethodMetaInfo addLead(String lead) {
        if (null == lead) {
            return this;
        }
        if (this.optionLeads.contains(lead)) {
            throw E.unexpected((String)"Duplicate option lead %s found on %s.%s", (Object[])new Object[]{lead, this.clsInfo.className(), this.methodName});
        }
        this.optionLeads.add(lead);
        return this;
    }

    public int hashCode() {
        return $.hc((Object)this.methodName, (Object)((Object)this.invokeType), (Object)this.clsInfo, this.params);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CommandMethodMetaInfo) {
            CommandMethodMetaInfo that = (CommandMethodMetaInfo)$.cast((Object)obj);
            return $.eq((Object)that.methodName, (Object)this.methodName) && $.eq((Object)((Object)that.invokeType), (Object)((Object)this.invokeType)) && $.eq(that.params, this.params) && $.eq((Object)that.clsInfo, (Object)this.clsInfo);
        }
        return false;
    }

    @Override
    protected void releaseResources() {
        super.releaseResources();
        this.clsInfo.destroy();
        Destroyable.Util.destroyAll(this.params, ApplicationScoped.class);
    }
}

