/*
 * Decompiled with CFR 0.152.
 */
package act.cli.tree;

import act.cli.tree.TreeNode;
import java.util.List;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.S;

public class SimpleTreeNode
implements TreeNode {
    private String id;
    private String label;
    private C.List<TreeNode> children;

    public SimpleTreeNode() {
        this.children = C.newList();
    }

    public SimpleTreeNode(String id) {
        this(id, id);
    }

    public SimpleTreeNode(String id, String label) {
        this(id, label, (List<TreeNode>)C.newList());
    }

    public SimpleTreeNode(String id, String label, List<TreeNode> children) {
        this.id = id;
        this.label = label;
        this.children = null == children ? C.newList() : C.newList(children);
    }

    @Override
    public String id() {
        return this.id;
    }

    public SimpleTreeNode id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String label() {
        return null == this.label ? this.id : this.label;
    }

    public SimpleTreeNode label(String label) {
        this.label = label;
        return this;
    }

    @Override
    public List<TreeNode> children() {
        return C.list(this.children);
    }

    public SimpleTreeNode children(List<TreeNode> children) {
        this.children = C.newList(children);
        return this;
    }

    public SimpleTreeNode addChild(TreeNode child) {
        this.children.add((Object)child);
        return this;
    }

    public SimpleTreeNode removeChild(TreeNode child) {
        this.children.remove((Object)child);
        return this;
    }

    public SimpleTreeNode removeChild(final String id) {
        this.children.remove((Osgl.Function)new Osgl.Predicate<TreeNode>(){

            public boolean test(TreeNode treeNode) {
                return S.eq((String)treeNode.id(), (String)id);
            }
        });
        return this;
    }
}

