/*
 * Decompiled with CFR 0.152.
 */
package act.cli.view;

import act.cli.CliContext;
import act.cli.CliOverHttpContext;
import act.cli.ascii_table.impl.CollectionASCIITableAware;
import act.cli.tree.TreeNode;
import act.cli.util.CliCursor;
import act.cli.util.MappedFastJsonNameFilter;
import act.cli.util.TableCursor;
import act.data.DataPropertyRepository;
import act.util.ActContext;
import act.util.DisableFastJsonCircularReferenceDetect;
import act.util.FastJsonPropertyPreFilter;
import act.util.PropertySpec;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.utils.Escape;

public enum CliView {
    TABLE{

        @Override
        public String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
            DataPropertyRepository repo;
            C.List outputFields;
            int pageSize;
            if (null == result) {
                return "no data";
            }
            if (null == (spec = PropertySpec.MetaInfo.withCurrent(spec, context))) {
                spec = new PropertySpec.MetaInfo();
            }
            if (!(context instanceof CliContext)) {
                throw E.unsupport((String)"TableView support in CliContext only. You context: ", (Object[])new Object[]{context.getClass()});
            }
            CliContext cliContext = (CliContext)context;
            List dataList = this.toList(result);
            int n = pageSize = context instanceof CliOverHttpContext ? dataList.size() : context.config().cliTablePageSize();
            if (dataList.size() > pageSize) {
                TableCursor cursor = new TableCursor(dataList, pageSize, spec);
                cliContext.session().cursor(cursor);
                cursor.output(cliContext);
                return "";
            }
            if (dataList.isEmpty()) {
                return "no data";
            }
            Class componentType = Object.class;
            for (Object o : dataList) {
                if (null == o) continue;
                componentType = o.getClass();
                break;
            }
            if ((outputFields = (repo = context.app().service(DataPropertyRepository.class)).outputFields(spec, componentType, context)).isEmpty()) {
                outputFields = C.list((Object)"this as Item");
            }
            String tableString = cliContext.getTable(new CollectionASCIITableAware(dataList, (List<String>)outputFields, spec.labels((List<String>)outputFields, context)));
            int itemsFound = dataList.size();
            CliCursor cursor = cliContext.session().cursor();
            String appendix = "";
            if (null != cursor) {
                itemsFound = cursor.records();
                appendix = cursor.hasNext() ? "\nType \"it\" for more" : "";
            }
            return S.concat((String)tableString, (String)"Items found: ", (String)S.string((Object)itemsFound), (String)appendix);
        }
    }
    ,
    TREE{

        @Override
        public String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
            if (result instanceof TreeNode) {
                return this.toTreeString((TreeNode)result);
            }
            if (result instanceof Iterable) {
                return TABLE.render(result, spec, context);
            }
            if (null != spec) {
                return JSON.render(result, spec, context);
            }
            return S.string((Object)result);
        }

        private String toTreeString(TreeNode result) {
            StringBuilder sb = S.newBuilder();
            this.buildTree(sb, result, "", true);
            return sb.toString();
        }

        private void buildTree(StringBuilder sb, TreeNode node, String prefix, boolean isTrail) {
            StringBuilder sb0 = S.newBuilder().append(prefix).append(isTrail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(node.label()).append("\n");
            sb.append((CharSequence)sb0);
            List<TreeNode> children = node.children();
            int sz = children.size();
            if (sz == 0) {
                return;
            }
            String subPrefix = S.newBuilder().append(prefix).append(isTrail ? "    " : "\u2502   ").toString();
            for (int i = 0; i < sz - 1; ++i) {
                TreeNode child = children.get(i);
                this.buildTree(sb, child, subPrefix, false);
            }
            this.buildTree(sb, children.get(sz - 1), subPrefix, true);
        }
    }
    ,
    XML{

        @Override
        public String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
            throw E.unsupport();
        }
    }
    ,
    JSON{

        @Override
        public String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
            return this.render(result, spec, context, context instanceof CliContext);
        }

        public String render(Object result, PropertySpec.MetaInfo spec, ActContext context, boolean format) {
            String json;
            FastJsonPropertyPreFilter propertyFilter;
            if (null == (spec = PropertySpec.MetaInfo.withCurrent(spec, context))) {
                propertyFilter = null;
            } else {
                propertyFilter = new FastJsonPropertyPreFilter(new String[0]);
                List<String> outputs = spec.outputFields(context);
                Set<String> excluded = spec.excludedFields(context);
                if (excluded.isEmpty()) {
                    if (outputs.isEmpty()) {
                        propertyFilter = null;
                    } else {
                        propertyFilter.addIncludes(outputs);
                        if (FastJsonPropertyPreFilter.hasPattern(outputs)) {
                            propertyFilter.setFullPaths(context.app().service(DataPropertyRepository.class).propertyListOf(result.getClass()));
                        }
                    }
                } else {
                    propertyFilter.addExcludes(excluded);
                    if (FastJsonPropertyPreFilter.hasPattern(excluded)) {
                        propertyFilter.setFullPaths(context.app().service(DataPropertyRepository.class).propertyListOf(result.getClass()));
                    }
                }
            }
            C.List featureList = C.newList();
            if (format) {
                featureList.add(SerializerFeature.PrettyFormat);
            }
            if (null == propertyFilter) {
                Boolean b = DisableFastJsonCircularReferenceDetect.option.get();
                if (null != b && b.booleanValue()) {
                    featureList.add(SerializerFeature.DisableCircularReferenceDetect);
                }
                SerializerFeature[] featureArray = new SerializerFeature[featureList.size()];
                featureArray = featureList.toArray(featureArray);
                json = format ? com.alibaba.fastjson.JSON.toJSONString((Object)result, (SerializerFeature[])featureArray) : com.alibaba.fastjson.JSON.toJSONString((Object)result);
            } else {
                MappedFastJsonNameFilter nameFilter = new MappedFastJsonNameFilter(spec.labelMapping(context));
                SerializerFeature[] featureArray = new SerializerFeature[featureList.size()];
                featureArray = featureList.toArray(featureArray);
                if (nameFilter.isEmpty()) {
                    json = com.alibaba.fastjson.JSON.toJSONString((Object)result, (SerializeFilter)propertyFilter, (SerializerFeature[])featureArray);
                } else {
                    SerializeFilter[] filters = new SerializeFilter[]{nameFilter, propertyFilter};
                    json = com.alibaba.fastjson.JSON.toJSONString((Object)result, (SerializeFilter[])filters, (SerializerFeature[])featureArray);
                }
            }
            return json;
        }
    }
    ,
    TO_STRING{

        @Override
        public String render(Object result, PropertySpec.MetaInfo filter, ActContext context) {
            if (result instanceof Iterable) {
                return TABLE.render(result, filter, context);
            }
            if (result instanceof TreeNode) {
                return TREE.render(result, filter, context);
            }
            if (null != filter) {
                return JSON.render(result, filter, context);
            }
            return S.string((Object)result);
        }
    }
    ,
    CSV{

        @Override
        public String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
            if (null == result) {
                return "no data";
            }
            C.List dataList = result instanceof Iterable ? C.list((Iterable)((Iterable)result)) : (result instanceof Iterator ? C.list((Iterator)((Iterator)result)) : (result instanceof Enumeration ? C.list((Enumeration)((Enumeration)result)) : C.list((Object)result)));
            if (dataList.isEmpty()) {
                return "no data";
            }
            Class<?> componentType = dataList.get(0).getClass();
            DataPropertyRepository repo = context.app().service(DataPropertyRepository.class);
            if (null == (spec = PropertySpec.MetaInfo.withCurrent(spec, context))) {
                spec = new PropertySpec.MetaInfo();
                spec.onValue("-not_exists");
            }
            List<String> outputFields = repo.outputFields(spec, componentType, context);
            S.Buffer sb = S.buffer();
            this.buildHeaderLine(sb, outputFields, spec.labelMapping());
            for (Object entity : dataList) {
                sb.append($.OS.lineSeparator());
                this.buildDataLine(sb, entity, outputFields);
            }
            return sb.toString();
        }

        private void buildDataLine(S.Buffer sb, Object data, List<String> outputFields) {
            Iterator<String> itr = outputFields.iterator();
            String prop = itr.next();
            sb.append(this.getProperty(data, prop));
            while (itr.hasNext()) {
                sb.append(",").append(this.getProperty(data, itr.next()));
            }
        }

        private String getProperty(Object data, String prop) {
            if ("this".equals(prop)) {
                return this.escape(data);
            }
            return this.escape($.getProperty((Object)data, (String)prop));
        }

        private void buildHeaderLine(S.Buffer sb, List<String> outputFields, Map<String, String> labels) {
            if (null == labels) {
                labels = C.newMap((Object[])new Object[0]);
            }
            Iterator<String> itr = outputFields.iterator();
            String label = this.label(itr.next(), (Map<String, String>)labels);
            sb.append(label);
            while (itr.hasNext()) {
                sb.append(",").append(this.escape(this.label(itr.next(), (Map<String, String>)labels)));
            }
        }

        private String label(String key, Map<String, String> labels) {
            String s = labels.get(key);
            return null == s ? key : s;
        }

        private String escape(Object o) {
            return Escape.CSV.apply(o).toString();
        }
    };


    public String render(Object result, PropertySpec.MetaInfo spec, ActContext context) {
        throw E.unsupport();
    }

    public void print(Object result, PropertySpec.MetaInfo spec, CliContext context) {
        context.println(this.render(result, spec, context), new Object[0]);
    }

    protected List toList(Object result) {
        C.List dataList = result instanceof Iterable ? C.list((Iterable)((Iterable)result)) : (result instanceof Iterator ? C.list((Iterator)((Iterator)result)) : (result instanceof Enumeration ? C.list((Enumeration)((Enumeration)result)) : C.listOf((Object[])new Object[]{result})));
        return dataList;
    }
}

