/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.AppHolder;
import act.app.ProjectLayout;
import act.app.conf.AppConfigurator;
import act.app.event.AppEventId;
import act.app.util.NamedPort;
import act.cli.CliOverHttpAuthority;
import act.conf.AppConfigKey;
import act.conf.ConfLoader;
import act.conf.Config;
import act.conf.ConfigKey;
import act.db.util.SequenceNumberGenerator;
import act.db.util._SequenceNumberGenerator;
import act.handler.UnknownHttpMethodProcessor;
import act.handler.event.ResultEvent;
import act.i18n.I18n;
import act.security.CSRFProtector;
import act.util.ActErrorPageRender;
import act.util.ErrorTemplatePathResolver;
import act.util.IdGenerator;
import act.util.JavaVersion;
import act.util.MissingAuthenticationHandler;
import act.util.RedirectToLoginUrl;
import act.util.SessionMapper;
import act.view.TemplatePathResolver;
import act.view.View;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.cache.CacheService;
import org.osgl.cache.CacheServiceProvider;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.mvc.ErrorPageRenderer;
import org.osgl.mvc.MvcConfig;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.ListBuilder;
import org.osgl.util.S;
import org.osgl.web.util.UserAgent;

public class AppConfig<T extends AppConfigurator>
extends Config<AppConfigKey>
implements AppHolder<AppConfig<T>> {
    protected static Logger logger = L.get(AppConfig.class);
    public static final String CONF_FILE_NAME = "app.conf";
    public static final String PORT_CLI_OVER_HTTP = "__admin__";
    private App app;
    private Boolean basicAuth;
    private Boolean cors;
    private String corsOrigin;
    private String corsHeaders;
    private String corsHeadersExpose;
    private Boolean corsOptionCheck;
    private String corsHeadersAllowed;
    private Integer corsMaxAge;
    private Boolean csrf;
    private String csrfParamName;
    private CSRFProtector csrfProtector;
    private String csrfCookieName;
    private String csrfHeaderName;
    private Boolean cliEnabled;
    private int cliTablePageSz = -1;
    private int cliJSONPageSz = -1;
    private Boolean cliOverHttp;
    private CliOverHttpAuthority cliOverHttpAuthority;
    Integer cliOverHttpPort;
    String cliOverHttpTitle;
    Boolean cliOverHttpSysCmd;
    private Integer cliPort;
    private int cliSessionExpiration = -1;
    private String dspToken;
    private Provider<String> cookieDomainProvider;
    private int maxCliSession = -1;
    private Boolean enumResolvingCaseSensitive;
    private String defViewName = null;
    private View defView = null;
    private String xForwardedProtocol = null;
    private Boolean contentSuffixAware = null;
    private _SequenceNumberGenerator seqGen = null;
    private ErrorTemplatePathResolver errorTemplatePathResolver = null;
    private String host = null;
    private Boolean i18nEnabled;
    private String localeParamName;
    private String localeCookieName;
    Integer ipEffectiveBytes;
    private IdGenerator.NodeIdProvider nodeIdProvider;
    private String startIdFile;
    private IdGenerator.StartIdProvider startIdProvider;
    private IdGenerator.SequenceProvider sequenceProvider;
    private IdGenerator.LongEncoder longEncoder;
    private String loginUrl = null;
    private String ajaxLoginUrl = null;
    private int httpMaxParams = -1;
    private int jobPoolSize = -1;
    private int httpExternalPort = -1;
    private Boolean httpExternal = null;
    private int httpExternalSecurePort = -1;
    private int httpPort = -1;
    private Boolean httpSecure = null;
    private MissingAuthenticationHandler mah = null;
    private MissingAuthenticationHandler ajaxMah = null;
    private MissingAuthenticationHandler csrfCheckFailureHandler = null;
    private MissingAuthenticationHandler ajaxCsrfCheckFailureHandler = null;
    private List<NamedPort> namedPorts = null;
    private String encoding = null;
    private String dateFmt = null;
    private String timeFmt = null;
    private String dateDateTimeFmt = null;
    private Locale locale = null;
    private String sourceVersion = null;
    private String targetVersion = null;
    private Osgl.Predicate<String> APP_CLASS_TESTER = null;
    private final Osgl.Predicate<String> SYSTEM_SCAN_LIST = new Osgl.Predicate<String>(){

        public boolean test(String s) {
            Set<String> scanList = AppConfig.this.app().scanList();
            if (scanList.contains(s)) {
                return true;
            }
            for (String scan : scanList) {
                if (!s.matches(scan)) continue;
                return true;
            }
            return false;
        }
    };
    private Osgl.Predicate<String> CONTROLLER_CLASS_TESTER = null;
    private TemplatePathResolver templatePathResolver = null;
    private String templateHome = null;
    private boolean pingPathResolved = false;
    private String pingPath = null;
    private Osgl.Func0<H.Format> jsonContentTypeProvider = null;
    private Boolean renderJsonIeFix = null;
    private H.Format jsonIE;
    private Boolean renderJsonOutputCharset;
    private String serverHeader;
    private String sessionKeyUsername = null;
    private String cookiePrefix;
    private String sessionCookieName = null;
    private String flashCookieName = null;
    private Integer sessionTtl = null;
    private Boolean sessionPersistent = null;
    private Boolean sessionEncrypt = null;
    private SessionMapper sessionMapper = null;
    private Boolean sessionSecure = null;
    private String secret = null;
    private List<File> moduleBases;
    private Boolean metricEnabled;
    private CacheServiceProvider csp = null;
    private String _cacheName;
    private String _cacheNameSession;
    private UnknownHttpMethodProcessor _unknownHttpMethodProcessor = null;
    private Integer resourcePreloadSizeLimit;
    private Boolean uploadFileDownload;
    private Set<AppConfigurator> mergeTracker = C.newSet();

    public AppConfig(Map<String, ?> configuration) {
        super(configuration);
    }

    public AppConfig() {
        this(System.getProperties());
    }

    @Override
    public AppConfig<T> app(App app) {
        E.NPE((Object)app);
        this.app = app;
        AppConfigKey.onApp(app);
        return this;
    }

    public void preloadConfigurations() {
        this.basicAuthenticationEnabled();
        this.corsEnabled();
        this.sessionCookieName();
        this.cookiePrefix();
        this.encryptSession();
        this.sessionMapper();
        this.sessionKeyUsername();
        this.sessionSecure();
        this.sessionTtl();
        MvcConfig.renderJsonOutputCharset((boolean)this.renderJsonOutputCharset());
        Osgl.Func0<H.Format> jsonContentProvider = this.jsonContentTypeProvider();
        if (null != this.jsonContentTypeProvider) {
            MvcConfig.jsonMediaTypeProvider(jsonContentProvider);
        }
    }

    @Override
    public App app() {
        return this.app;
    }

    @Override
    protected ConfigKey keyOf(String s) {
        return AppConfigKey.valueOfIgnoreCase(s);
    }

    protected T enableBasicAuthentication(boolean b) {
        this.basicAuth = b;
        return this.me();
    }

    public boolean basicAuthenticationEnabled() {
        if (null == this.basicAuth) {
            Boolean B = (Boolean)this.get(AppConfigKey.BASIC_AUTHENTICATION);
            if (null == B) {
                B = Act.isDev();
            }
            this.basicAuth = B;
        }
        return this.basicAuth;
    }

    private void _mergeBasicAuthentication(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.BASIC_AUTHENTICATION)) {
            this.basicAuth = conf.basicAuth;
        }
    }

    protected T enableCors(boolean b) {
        this.cors = b;
        return this.me();
    }

    public boolean corsEnabled() {
        if (null == this.cors) {
            Boolean B = (Boolean)this.get(AppConfigKey.CORS);
            if (null == B) {
                B = false;
            }
            this.cors = B;
        }
        return this.cors;
    }

    private void _mergeCors(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS)) {
            this.cors = conf.cors;
        }
    }

    protected T corsAllowOrigin(String s) {
        this.corsOrigin = s;
        return this.me();
    }

    public String corsAllowOrigin() {
        if (null == this.corsOrigin) {
            String s = (String)this.get(AppConfigKey.CORS_ORIGIN);
            if (S.blank((String)s)) {
                s = "*";
            }
            this.corsOrigin = s;
        }
        return this.corsOrigin;
    }

    private void _mergeCorsOrigin(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_ORIGIN)) {
            this.corsOrigin = conf.corsOrigin;
        }
    }

    protected T corsHeaders(String s) {
        this.corsHeaders = s;
        return this.me();
    }

    private String corsHeaders() {
        if (null == this.corsHeaders) {
            String s = (String)this.get(AppConfigKey.CORS_HEADERS);
            if (null == s) {
                s = "Content-Type, X-HTTP-Method-Override, X-Requested-With";
            }
            this.corsHeaders = s;
        }
        return this.corsHeaders;
    }

    private void _mergeCorsHeaders(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_HEADERS)) {
            this.corsHeaders = conf.corsHeaders;
        }
    }

    protected T corsHeadersExpose(String s) {
        this.corsHeadersExpose = s;
        return this.me();
    }

    public String corsExposeHeaders() {
        if (null == this.corsHeadersExpose) {
            String s = (String)this.get(AppConfigKey.CORS_HEADERS_EXPOSE);
            if (null == s) {
                s = this.corsHeaders();
            }
            this.corsHeadersExpose = s;
        }
        return this.corsHeadersExpose;
    }

    private void _mergeCorsHeadersExpose(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_HEADERS_EXPOSE)) {
            this.corsHeadersExpose = conf.corsHeadersExpose;
        }
    }

    protected T corsOptionCheck(Boolean b) {
        this.corsOptionCheck = b;
        return this.me();
    }

    public Boolean corsOptionCheck() {
        if (null == this.corsOptionCheck) {
            Boolean b = (Boolean)this.get(AppConfigKey.CORS_CHECK_OPTION_METHOD);
            this.corsOptionCheck = null == b ? true : b;
        }
        return this.corsOptionCheck;
    }

    private void _mergeCorsOptionCheck(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_CHECK_OPTION_METHOD)) {
            this.corsOptionCheck = conf.corsOptionCheck;
        }
    }

    protected T corsAllowHeaders(String s) {
        this.corsHeadersExpose = s;
        return this.me();
    }

    public String corsAllowHeaders() {
        if (null == this.corsHeadersAllowed) {
            String s = (String)this.get(AppConfigKey.CORS_HEADERS_ALLOWED);
            if (null == s) {
                s = this.corsHeaders();
            }
            this.corsHeadersAllowed = s;
        }
        return this.corsHeadersAllowed;
    }

    private void _mergeCorsHeadersAllowed(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_HEADERS_EXPOSE)) {
            this.corsHeadersAllowed = conf.corsHeadersAllowed;
        }
    }

    protected T corsMaxAge(int corsMaxAge) {
        this.corsMaxAge = corsMaxAge;
        return this.me();
    }

    public int corsMaxAge() {
        if (null == this.corsMaxAge) {
            Integer I = this.getInteger(AppConfigKey.CORS_MAX_AGE);
            if (null == I) {
                I = 1800;
            }
            this.corsMaxAge = I;
        }
        return this.corsMaxAge;
    }

    private void _mergeCorsMaxAge(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CORS_MAX_AGE)) {
            this.corsMaxAge = conf.corsMaxAge;
        }
    }

    protected T enableCsrf(boolean b) {
        this.csrf = b;
        return this.me();
    }

    public boolean csrfEnabled() {
        if (null == this.csrf) {
            Boolean B = (Boolean)this.get(AppConfigKey.CSRF);
            if (null == B) {
                B = false;
            }
            this.csrf = B;
        }
        return this.csrf;
    }

    private void _mergeCsrf(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF)) {
            this.csrf = conf.csrf;
        }
    }

    protected T csrfParamName(String s) {
        this.csrfParamName = s;
        return this.me();
    }

    public String csrfParamName() {
        if (null == this.csrfParamName) {
            String s = (String)this.get(AppConfigKey.CSRF_PARAM_NAME);
            if (S.blank((String)s)) {
                s = "__csrf__";
            }
            this.csrfParamName = s;
        }
        return this.csrfParamName;
    }

    private void _mergeCsrfParamName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_PARAM_NAME)) {
            this.csrfParamName = conf.csrfParamName;
        }
    }

    protected T csrfProtector(CSRFProtector protector) {
        this.csrfProtector = (CSRFProtector)$.notNull((Object)protector);
        return this.me();
    }

    public CSRFProtector csrfProtector() {
        if (null == this.csrfProtector) {
            try {
                this.csrfProtector = (CSRFProtector)this.get(AppConfigKey.CSRF_PROTECTOR);
                if (null == this.csrfProtector) {
                    this.csrfProtector = CSRFProtector.Predefined.HMAC;
                }
            }
            catch (ConfigurationException e) {
                Object obj = AppConfigKey.helper.getValFromAliases(this.raw, AppConfigKey.CSRF_PROTECTOR.key(), "impl", null);
                if (null != obj) {
                    this.csrfProtector = CSRFProtector.Predefined.valueOfIgnoreCase(obj.toString());
                    if (null != this.csrfProtector) {
                        return this.csrfProtector;
                    }
                }
                throw e;
            }
        }
        return this.csrfProtector;
    }

    private void _mergeCsrfProtector(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_PROTECTOR)) {
            this.csrfProtector = config.csrfProtector;
        }
    }

    protected T csrfCookieName(String s) {
        this.csrfCookieName = s;
        return this.me();
    }

    public String csrfCookieName() {
        if (null == this.csrfCookieName) {
            String s = (String)this.get(AppConfigKey.CSRF_COOKIE_NAME);
            if (S.blank((String)s)) {
                s = this.cookieName("xsrf-token");
            }
            this.csrfCookieName = s;
        }
        return this.csrfCookieName;
    }

    private void _mergeCsrfCookieName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_COOKIE_NAME)) {
            this.csrfCookieName = conf.csrfCookieName;
        }
    }

    protected T csrfHeaderName(String s) {
        this.csrfHeaderName = s;
        return this.me();
    }

    public String csrfHeaderName() {
        if (null == this.csrfHeaderName) {
            String s = (String)this.get(AppConfigKey.CSRF_HEADER_NAME);
            if (S.blank((String)s)) {
                s = "X-Xsrf-Token";
            }
            this.csrfHeaderName = s;
        }
        return this.csrfHeaderName;
    }

    private void _mergeCsrfHeaderName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CSRF_HEADER_NAME)) {
            this.csrfHeaderName = conf.csrfHeaderName;
        }
    }

    protected T cliEnable(boolean enable) {
        this.cliEnabled = enable;
        return this.me();
    }

    public boolean cliEnabled() {
        if (null == this.cliEnabled) {
            this.cliEnabled = (Boolean)this.get(AppConfigKey.CLI_ENABLED);
            if (null == this.cliEnabled) {
                this.cliEnabled = true;
            }
        }
        return this.cliEnabled;
    }

    private void _mergeCliEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_ENABLED)) {
            this.cliEnabled = conf.cliEnabled;
        }
    }

    protected T cliTablePageSz(int sz) {
        E.illegalArgumentIf((sz < 1 ? 1 : 0) != 0, (String)"CLI table page size not valid: %s", (Object[])new Object[]{sz});
        this.cliTablePageSz = sz;
        return this.me();
    }

    public int cliTablePageSize() {
        if (-1 == this.cliTablePageSz) {
            Integer I = this.getInteger(AppConfigKey.CLI_PAGE_SIZE_TABLE);
            if (null == I) {
                I = 22;
            }
            this.cliTablePageSz = I;
        }
        return this.cliTablePageSz;
    }

    private void _mergeCliTablePageSz(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_PAGE_SIZE_TABLE)) {
            this.cliTablePageSz = conf.cliTablePageSz;
        }
    }

    protected T cliJSONPageSz(int sz) {
        E.illegalArgumentIf((sz < 1 ? 1 : 0) != 0, (String)"CLI JSON page size not valid: %s", (Object[])new Object[]{sz});
        this.cliJSONPageSz = sz;
        return this.me();
    }

    public int cliJSONPageSize() {
        if (-1 == this.cliJSONPageSz) {
            Integer I = this.getInteger(AppConfigKey.CLI_PAGE_SIZE_TABLE);
            if (null == I) {
                I = 22;
            }
            this.cliJSONPageSz = I;
        }
        return this.cliJSONPageSz;
    }

    private void _mergeCliJSONPageSz(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_PAGE_SIZE_TABLE)) {
            this.cliJSONPageSz = conf.cliJSONPageSz;
        }
    }

    protected T cliOverHttp(boolean enabled) {
        this.cliOverHttp = enabled;
        return this.me();
    }

    public boolean cliOverHttp() {
        if (null == this.cliOverHttp) {
            Boolean B = (Boolean)this.get(AppConfigKey.CLI_OVER_HTTP);
            if (null == B) {
                B = false;
            }
            this.cliOverHttp = B;
        }
        return this.cliOverHttp;
    }

    private void _mergeCliOverHttp(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP)) {
            this.cliOverHttp = config.cliOverHttp;
        }
    }

    protected T cliOverHttpAuthority(CliOverHttpAuthority authority) {
        this.cliOverHttpAuthority = authority;
        return this.me();
    }

    public CliOverHttpAuthority cliOverHttpAuthority() {
        if (null == this.cliOverHttpAuthority) {
            this.cliOverHttpAuthority = (CliOverHttpAuthority)this.get(AppConfigKey.CLI_OVER_HTTP_AUTHORITY);
            if (null == this.cliOverHttpAuthority) {
                this.cliOverHttpAuthority = new CliOverHttpAuthority.AllowAll();
            }
        }
        return this.cliOverHttpAuthority;
    }

    private void _mergeCliOverHttpAuthority(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_AUTHORITY)) {
            this.cliOverHttpAuthority = config.cliOverHttpAuthority;
        }
    }

    protected T cliOverHttpPort(int port) {
        this.cliOverHttpPort = port;
        return this.me();
    }

    public int cliOverHttpPort() {
        if (null == this.cliOverHttpPort) {
            String s = (String)this.get(AppConfigKey.CLI_OVER_HTTP_PORT);
            this.cliOverHttpPort = null == s ? 5462 : Integer.parseInt(s);
        }
        return this.cliOverHttpPort;
    }

    private void _mergeCliOverHttpPort(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_PORT)) {
            this.cliOverHttpPort = config.cliOverHttpPort;
        }
    }

    protected T cliOverHttpTitle(String title) {
        this.cliOverHttpTitle = title;
        return this.me();
    }

    public String cliOverHttpTitle() {
        if (null == this.cliOverHttpTitle) {
            this.cliOverHttpTitle = (String)this.get(AppConfigKey.CLI_OVER_HTTP_TITLE);
            if (null == this.cliOverHttpTitle) {
                this.cliOverHttpTitle = "Cli Over Http";
            }
        }
        return this.cliOverHttpTitle;
    }

    private void _mergeCliOverHttpTitle(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_TITLE)) {
            this.cliOverHttpTitle = config.cliOverHttpTitle;
        }
    }

    protected T cliOverHttpSysCmd(boolean enabled) {
        this.cliOverHttpSysCmd = enabled;
        return this.me();
    }

    public boolean cliOverHttpSysCmdEnabled() {
        if (null == this.cliOverHttpSysCmd) {
            this.cliOverHttpSysCmd = (Boolean)this.get(AppConfigKey.CLI_OVER_HTTP_SYS_CMD);
            if (null == this.cliOverHttpSysCmd) {
                this.cliOverHttpSysCmd = true;
            }
        }
        return this.cliOverHttpSysCmd;
    }

    private void _mergeCliOverHttpSysCmd(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CLI_OVER_HTTP_SYS_CMD)) {
            this.cliOverHttpSysCmd = config.cliOverHttpSysCmd;
        }
    }

    protected T cliPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.cliPort = port;
        return this.me();
    }

    public int cliPort() {
        if (null == this.cliPort) {
            String s = (String)this.get(AppConfigKey.CLI_PORT);
            this.cliPort = null == s ? 5461 : Integer.parseInt(s);
        }
        return this.cliPort;
    }

    private void _mergeCliPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_PORT)) {
            this.cliPort = conf.cliPort;
        }
    }

    protected T cliSessionExpiration(int expire) {
        E.illegalArgumentIf((expire < 1 ? 1 : 0) != 0, (String)"cli session expire not valid: %s", (Object[])new Object[]{expire});
        this.cliSessionExpiration = expire;
        return this.me();
    }

    public int cliSessionExpiration() {
        if (-1 == this.cliSessionExpiration) {
            Integer I = this.getInteger(AppConfigKey.CLI_SESSION_EXPIRATION);
            if (null == I) {
                I = 300;
            }
            this.cliSessionExpiration = I;
        }
        return this.cliSessionExpiration;
    }

    private void _mergeCliSessionExpiration(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_SESSION_EXPIRATION)) {
            this.cliSessionExpiration = conf.cliSessionExpiration;
        }
    }

    protected T dspToken(String tokenName) {
        this.dspToken = tokenName;
        return this.me();
    }

    public String dspToken() {
        if (null == this.dspToken) {
            this.dspToken = (String)this.get(AppConfigKey.DOUBLE_SUBMISSION_PROTECT_TOKEN);
            if (null == this.dspToken) {
                this.dspToken = "act_dsp_token";
            }
        }
        return this.dspToken;
    }

    private void _mergeDspToken(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.DOUBLE_SUBMISSION_PROTECT_TOKEN)) {
            this.dspToken = conf.dspToken;
        }
    }

    protected T cookieDomain(final String domain) {
        this.cookieDomainProvider = new Provider<String>(){

            public String get() {
                return domain;
            }
        };
        return this.me();
    }

    protected T cookieDomainProvider(Provider<String> provider) {
        this.cookieDomainProvider = (Provider)$.notNull(provider);
        return this.me();
    }

    public String cookieDomain() {
        String domain = (String)this.cookieDomainProvider().get();
        return "localhost".equals(domain) ? null : domain;
    }

    private Provider<String> cookieDomainProvider() {
        if (null == this.cookieDomainProvider) {
            try {
                this.cookieDomainProvider = (Provider)this.get(AppConfigKey.COOKIE_DOMAIN_PROVIDER);
            }
            catch (ConfigurationException e) {
                Object obj = AppConfigKey.helper.getValFromAliases(this.raw, AppConfigKey.COOKIE_DOMAIN_PROVIDER.key(), "impl", null);
                String s = obj.toString();
                if ("dynamic".equalsIgnoreCase(s) || "flexible".equalsIgnoreCase(s) || "contextual".equalsIgnoreCase(s)) {
                    this.cookieDomainProvider = new Provider<String>(){

                        public String get() {
                            H.Request req = ActionContext.current().req();
                            return req.domain();
                        }
                    };
                    return this.cookieDomainProvider;
                }
                throw e;
            }
            if (null == this.cookieDomainProvider) {
                this.cookieDomainProvider = new Provider<String>(){

                    public String get() {
                        return AppConfig.this.host();
                    }
                };
            }
        }
        return this.cookieDomainProvider;
    }

    private void _mergeCookieDomain(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.COOKIE_DOMAIN_PROVIDER)) {
            this.cookieDomainProvider = config.cookieDomainProvider;
        }
    }

    protected T maxCliSession(int size) {
        E.illegalArgumentIf((size < 1 ? 1 : 0) != 0, (String)"max cli session number cannot be zero or negative number: %s", (Object[])new Object[]{size});
        this.maxCliSession = size;
        return this.me();
    }

    public int maxCliSession() {
        if (-1 == this.maxCliSession) {
            Integer I = this.getInteger(AppConfigKey.CLI_SESSION_MAX);
            if (null == I) {
                I = 3;
            }
            this.maxCliSession = I;
        }
        return this.maxCliSession;
    }

    private void _mergeMaxCliSession(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CLI_SESSION_MAX)) {
            this.maxCliSession = conf.maxCliSession;
        }
    }

    protected T enumResolvingCaseSensitive(boolean b) {
        this.enumResolvingCaseSensitive = b;
        return this.me();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enumResolvingCaseSensitive() {
        AppConfigKey appConfigKey = AppConfigKey.ENUM_RESOLVING_CASE_SENSITIVE;
        synchronized (appConfigKey) {
            if (null == this.enumResolvingCaseSensitive) {
                this.enumResolvingCaseSensitive = (Boolean)this.get(AppConfigKey.ENUM_RESOLVING_CASE_SENSITIVE);
                if (null == this.enumResolvingCaseSensitive) {
                    this.enumResolvingCaseSensitive = false;
                }
            }
            return this.enumResolvingCaseSensitive;
        }
    }

    private void _mergeEnumResolvingCaseSensitive(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ENUM_RESOLVING_CASE_SENSITIVE)) {
            this.enumResolvingCaseSensitive = conf.enumResolvingCaseSensitive;
        }
    }

    protected T defaultView(View view) {
        E.NPE((Object)view);
        this.defView = view;
        return this.me();
    }

    public View defaultView() {
        if (null == this.defViewName) {
            this.defViewName = (String)this.get(AppConfigKey.VIEW_DEFAULT);
            if (null == this.defViewName) {
                this.defViewName = "rythm";
            }
            this.defView = Act.viewManager().view(this.defViewName);
        }
        return this.defView;
    }

    private void _mergeDefaultView(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.VIEW_DEFAULT)) {
            this.defViewName = conf.defViewName;
            this.defView = conf.defView;
        }
    }

    protected T forceHttps() {
        this.xForwardedProtocol = "https";
        return this.me();
    }

    public String xForwardedProtocol() {
        if (null == this.xForwardedProtocol) {
            this.xForwardedProtocol = (String)this.get(AppConfigKey.X_FORWARD_PROTOCOL);
            if (null == this.xForwardedProtocol) {
                this.xForwardedProtocol = "http";
            }
        }
        return this.xForwardedProtocol;
    }

    private void _mergeXForwardedProtocol(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.X_FORWARD_PROTOCOL)) {
            this.xForwardedProtocol = conf.xForwardedProtocol;
        }
    }

    protected T contentSuffixAware(boolean b) {
        this.contentSuffixAware = b;
        return this.me();
    }

    public Boolean contentSuffixAware() {
        if (null == this.contentSuffixAware) {
            this.contentSuffixAware = (Boolean)this.get(AppConfigKey.CONTENT_SUFFIX_AWARE);
            if (null == this.contentSuffixAware) {
                this.contentSuffixAware = false;
            }
        }
        return this.contentSuffixAware;
    }

    private void _mergeContentSuffixAware(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.CONTENT_SUFFIX_AWARE)) {
            this.contentSuffixAware = conf.contentSuffixAware;
        }
    }

    protected T sequenceNumberGenerator(_SequenceNumberGenerator seqGen) {
        this.seqGen = seqGen;
        return this.me();
    }

    public _SequenceNumberGenerator sequenceNumberGenerator() {
        if (null == this.seqGen) {
            this.seqGen = (_SequenceNumberGenerator)this.get(AppConfigKey.DB_SEQ_GENERATOR);
            if (null == this.seqGen) {
                Provider provider = this.app().getInstance(SequenceNumberGenerator.Provider.class);
                this.seqGen = (_SequenceNumberGenerator)provider.get();
                logger.debug("Sequence number generator loaded: %s", new Object[]{this.seqGen.getClass().getName()});
            }
        }
        return this.seqGen;
    }

    private void _mergeSequenceNumberGenerator(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.DB_SEQ_GENERATOR)) {
            this.seqGen = conf.seqGen;
        }
    }

    protected T errorTemplatePathResolver(ErrorTemplatePathResolver resolver) {
        this.errorTemplatePathResolver = resolver;
        return this.me();
    }

    public ErrorTemplatePathResolver errorTemplatePathResolver() {
        if (null == this.errorTemplatePathResolver) {
            this.errorTemplatePathResolver = (ErrorTemplatePathResolver)this.get(AppConfigKey.RESOLVER_ERROR_TEMPLATE_PATH);
            if (null == this.errorTemplatePathResolver) {
                this.errorTemplatePathResolver = new ErrorTemplatePathResolver.DefaultErrorTemplatePathResolver();
            }
        }
        return this.errorTemplatePathResolver;
    }

    private void _mergeErrorTemplatePathResolver(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RESOLVER_ERROR_TEMPLATE_PATH)) {
            this.errorTemplatePathResolver = conf.errorTemplatePathResolver;
        }
    }

    protected T host(String hostname) {
        E.illegalArgumentIf(((hostname = hostname.trim()).length() == 0 ? 1 : 0) != 0, (String)"hostname cannot be empty");
        this.host = hostname;
        return this.me();
    }

    public String host() {
        if (null == this.host) {
            this.host = (String)this.get(AppConfigKey.HOST);
            if (null == this.host) {
                logger.warn("host is not configured. Use localhost as hostname");
                this.host = "localhost";
            }
        }
        return this.host;
    }

    private void _mergeHost(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HOST)) {
            this.host = conf.host;
        }
    }

    protected T i18n(boolean enabled) {
        this.i18nEnabled = enabled;
        return this.me();
    }

    public boolean i18nEnabled() {
        if (null == this.i18nEnabled) {
            Boolean b = (Boolean)this.get(AppConfigKey.I18N);
            if (null == b) {
                b = false;
            }
            this.i18nEnabled = b;
        }
        return this.i18nEnabled;
    }

    private void _mergeI18nEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.I18N)) {
            this.i18nEnabled = conf.i18nEnabled;
        }
    }

    protected T localeParamName(String name) {
        E.illegalArgumentIf((boolean)S.blank((String)name), (String)"locale param name must not be empty");
        this.localeParamName = name;
        return this.me();
    }

    public String localeParamName() {
        if (null == this.localeParamName) {
            String s = (String)this.get(AppConfigKey.I18N_LOCALE_PARAM_NAME);
            if (S.blank((String)s)) {
                s = "act_locale";
            }
            this.localeParamName = s;
        }
        return this.localeParamName;
    }

    private void _mergeLocaleParamName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.I18N_LOCALE_PARAM_NAME)) {
            this.localeParamName = conf.localeParamName;
        }
    }

    protected T localeCookieName(String name) {
        E.illegalArgumentIf((boolean)S.blank((String)name), (String)"locale Cookie name must not be empty");
        this.localeCookieName = name;
        return this.me();
    }

    public String localeCookieName() {
        if (null == this.localeCookieName) {
            String s = (String)this.get(AppConfigKey.I18N_LOCALE_COOKIE_NAME);
            if (S.blank((String)s)) {
                s = this.cookieName("locale");
            }
            this.localeCookieName = s;
        }
        return this.localeCookieName;
    }

    private void _mergeLocaleCookieName(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.I18N_LOCALE_COOKIE_NAME)) {
            this.localeCookieName = conf.localeCookieName;
        }
    }

    protected T ipEffectiveBytes(int n) {
        E.illegalArgumentIf((n < 1 || n > 4 ? 1 : 0) != 0, (String)"integer from 1 to 4 (inclusive) expected");
        this.ipEffectiveBytes = n;
        return this.me();
    }

    public int ipEffectiveBytes() {
        if (null == this.ipEffectiveBytes) {
            this.ipEffectiveBytes = this.getInteger(AppConfigKey.ID_GEN_NODE_ID_EFFECTIVE_IP_BYTES);
            if (null == this.ipEffectiveBytes) {
                this.ipEffectiveBytes = 4;
            }
        }
        return this.ipEffectiveBytes;
    }

    private void _mergeIpEffectiveBytes(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_NODE_ID_EFFECTIVE_IP_BYTES)) {
            this.ipEffectiveBytes = conf.ipEffectiveBytes;
        }
    }

    protected T nodeIdProvider(IdGenerator.NodeIdProvider provider) {
        this.nodeIdProvider = (IdGenerator.NodeIdProvider)$.NPE((Object)provider);
        return this.me();
    }

    public IdGenerator.NodeIdProvider nodeIdProvider() {
        if (null == this.nodeIdProvider) {
            this.nodeIdProvider = (IdGenerator.NodeIdProvider)this.get(AppConfigKey.ID_GEN_NODE_ID_PROVIDER);
            if (null == this.nodeIdProvider) {
                this.nodeIdProvider = new IdGenerator.NodeIdProvider.IpProvider(this.ipEffectiveBytes());
            }
        }
        return this.nodeIdProvider;
    }

    private void _mergeNodeIdProvider(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_NODE_ID_PROVIDER)) {
            this.nodeIdProvider = conf.nodeIdProvider;
        }
    }

    protected T startIdFile(String file) {
        E.illegalArgumentIf((boolean)S.blank((String)file));
        this.startIdFile = file;
        return this.me();
    }

    public String startIdFile() {
        if (null == this.startIdFile) {
            this.startIdFile = (String)this.get(AppConfigKey.ID_GEN_START_ID_FILE);
            if (null == this.startIdFile) {
                this.startIdFile = ".act.id-app";
            }
        }
        return this.startIdFile;
    }

    private void _mergeStartIdFile(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_START_ID_FILE)) {
            this.startIdFile = conf.startIdFile;
        }
    }

    protected T startIdProvider(IdGenerator.StartIdProvider provider) {
        this.startIdProvider = (IdGenerator.StartIdProvider)$.NPE((Object)provider);
        return this.me();
    }

    public IdGenerator.StartIdProvider startIdProvider() {
        if (null == this.startIdProvider) {
            this.startIdProvider = (IdGenerator.StartIdProvider)this.get(AppConfigKey.ID_GEN_START_ID_PROVIDER);
            if (null == this.startIdProvider) {
                this.startIdProvider = new IdGenerator.StartIdProvider.DefaultStartIdProvider(this.startIdFile());
            }
        }
        return this.startIdProvider;
    }

    private void _mergeStartIdProvider(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_START_ID_PROVIDER)) {
            this.startIdProvider = conf.startIdProvider;
        }
    }

    protected T sequenceProvider(IdGenerator.SequenceProvider provider) {
        this.sequenceProvider = (IdGenerator.SequenceProvider)$.NPE((Object)provider);
        return this.me();
    }

    public IdGenerator.SequenceProvider sequenceProvider() {
        if (null == this.sequenceProvider) {
            this.sequenceProvider = (IdGenerator.SequenceProvider)this.get(AppConfigKey.ID_GEN_SEQ_ID_PROVIDER);
            if (null == this.sequenceProvider) {
                this.sequenceProvider = new IdGenerator.SequenceProvider.AtomicLongSeq();
            }
        }
        return this.sequenceProvider;
    }

    private void _mergeSequenceProvider(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_SEQ_ID_PROVIDER)) {
            this.sequenceProvider = conf.sequenceProvider;
        }
    }

    protected T longEncoder(IdGenerator.LongEncoder longEncoder) {
        this.longEncoder = (IdGenerator.LongEncoder)$.NPE((Object)longEncoder);
        return this.me();
    }

    public IdGenerator.LongEncoder longEncoder() {
        if (null == this.longEncoder) {
            this.longEncoder = (IdGenerator.LongEncoder)this.get(AppConfigKey.ID_GEN_LONG_ENCODER);
            if (null == this.longEncoder) {
                this.longEncoder = IdGenerator.SAFE_ENCODER;
            }
        }
        return this.longEncoder;
    }

    private void _mergeLongEncoder(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ID_GEN_LONG_ENCODER)) {
            this.longEncoder = conf.longEncoder;
        }
    }

    protected T loginUrl(String url) {
        E.illegalArgumentIf((!url.startsWith("/") ? 1 : 0) != 0, (String)"login URL shall start with '/'");
        this.loginUrl = url;
        return this.me();
    }

    public String loginUrl() {
        ActionContext context;
        if (null == this.loginUrl) {
            this.loginUrl = (String)this.get(AppConfigKey.URL_LOGIN);
            if (null == this.loginUrl) {
                this.loginUrl = "/login";
            }
        }
        if (null != (context = ActionContext.current()) && context.isAjax()) {
            return this.ajaxLoginUrl();
        }
        return this.loginUrl;
    }

    private void _mergeLoginUrl(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.URL_LOGIN)) {
            this.loginUrl = conf.loginUrl;
        }
    }

    protected T ajaxLoginUrl(String url) {
        E.illegalArgumentIf((!url.startsWith("/") ? 1 : 0) != 0, (String)"login URL shall start with '/'");
        this.ajaxLoginUrl = url;
        return this.me();
    }

    public String ajaxLoginUrl() {
        if (null == this.ajaxLoginUrl) {
            this.ajaxLoginUrl = (String)this.get(AppConfigKey.URL_LOGIN_AJAX);
            if (null == this.ajaxLoginUrl) {
                this.ajaxLoginUrl = this.loginUrl;
            }
            if (null == this.ajaxLoginUrl) {
                this.ajaxLoginUrl = (String)this.get(AppConfigKey.URL_LOGIN);
            }
            if (null == this.ajaxLoginUrl) {
                this.ajaxLoginUrl = "/login";
            }
        }
        return this.ajaxLoginUrl;
    }

    private void _mergeAjaxLoginUrl(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.URL_LOGIN_AJAX)) {
            this.ajaxLoginUrl = conf.ajaxLoginUrl;
        }
    }

    protected T httpMaxParams(int max) {
        E.illegalArgumentIf((max < 0 ? 1 : 0) != 0, (String)"max params cannot be negative number: %s", (Object[])new Object[]{max});
        this.httpMaxParams = max;
        return this.me();
    }

    public int httpMaxParams() {
        if (-1 == this.httpMaxParams) {
            Integer I = this.getInteger(AppConfigKey.HTTP_MAX_PARAMS);
            if (null == I) {
                I = 128;
            }
            if (I < 0) {
                throw new ConfigurationException("http.params.max setting cannot be negative number. Found: %s", new Object[]{I});
            }
            this.httpMaxParams = I;
        }
        return this.httpMaxParams;
    }

    private void _mergeHttpMaxParams(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_MAX_PARAMS)) {
            this.httpMaxParams = conf.httpMaxParams;
        }
    }

    protected T jobPoolSize(int size) {
        E.illegalArgumentIf((size < 1 ? 1 : 0) != 0, (String)"job pool size cannot be zero or negative number: %s", (Object[])new Object[]{size});
        this.jobPoolSize = size;
        return this.me();
    }

    public int jobPoolSize() {
        if (-1 == this.jobPoolSize) {
            Integer I = this.getInteger(AppConfigKey.JOB_POOL_SIZE);
            if (null == I) {
                I = 10;
            }
            this.jobPoolSize = I;
        }
        return this.jobPoolSize;
    }

    private void _mergeJobPoolSize(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.JOB_POOL_SIZE)) {
            this.jobPoolSize = conf.jobPoolSize;
        }
    }

    protected T httpExternalPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpExternalPort = port;
        return this.me();
    }

    public int httpExternalPort() {
        if (-1 == this.httpExternalPort) {
            String s = (String)this.get(AppConfigKey.HTTP_EXTERNAL_PORT);
            this.httpExternalPort = null == s ? (this.httpExternal() ? 80 : this.httpPort()) : Integer.parseInt(s);
        }
        return this.httpExternalPort;
    }

    private void _mergeHttpExternalPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_EXTERNAL_PORT)) {
            this.httpExternalPort = conf.httpExternalPort();
        }
    }

    protected T httpExternal(boolean setting) {
        this.httpExternal = setting;
        return this.me();
    }

    public boolean httpExternal() {
        if (null == this.httpExternal) {
            Boolean b = (Boolean)this.get(AppConfigKey.HTTP_EXTERNAL_SERVER);
            this.httpExternal = null == b ? Act.mode().isProd() : b.booleanValue();
        }
        return this.httpExternal;
    }

    private void _mergeHttpExternal(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_EXTERNAL_SERVER)) {
            this.httpExternal = conf.httpExternal;
        }
    }

    protected T httpExternalSecurePort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpExternalSecurePort = port;
        return this.me();
    }

    public int httpExternalSecurePort() {
        if (-1 == this.httpExternalSecurePort) {
            String s = (String)this.get(AppConfigKey.HTTP_EXTERNAL_SECURE_PORT);
            this.httpExternalSecurePort = null == s ? (this.httpExternal() ? 443 : this.httpPort()) : Integer.parseInt(s);
        }
        return this.httpExternalSecurePort;
    }

    private void _mergeHttpExternalSecurePort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_EXTERNAL_PORT)) {
            this.httpExternalSecurePort = conf.httpExternalSecurePort;
        }
    }

    protected T httpPort(int port) {
        E.illegalArgumentIf((port < 1 ? 1 : 0) != 0, (String)"port value not valid: %s", (Object[])new Object[]{port});
        this.httpPort = port;
        return this.me();
    }

    public int httpPort() {
        if (-1 == this.httpPort) {
            String s = (String)this.get(AppConfigKey.HTTP_PORT);
            this.httpPort = null == s ? 5460 : Integer.parseInt(s);
        }
        return this.httpPort;
    }

    private void _mergeHttpPort(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_PORT)) {
            this.httpPort = conf.httpPort;
        }
    }

    protected T httpSecure(boolean secure) {
        this.httpSecure = secure;
        return this.me();
    }

    public boolean httpSecure() {
        if (null == this.httpSecure) {
            Boolean B = (Boolean)this.get(AppConfigKey.HTTP_SECURE);
            if (null == B) {
                B = !Act.isDev() && S.neq((String)Act.profile(), (String)"dev", (int)4096);
            }
            this.httpSecure = B;
        }
        return this.httpSecure;
    }

    private void _mergeHttpSecure(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.HTTP_SECURE)) {
            this.httpSecure = conf.httpSecure;
        }
    }

    protected T missingAuthenticationHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.mah = handler;
        return this.me();
    }

    public MissingAuthenticationHandler missingAuthenticationHandler() {
        if (null == this.mah) {
            this.mah = (MissingAuthenticationHandler)this.get(AppConfigKey.HANDLER_MISSING_AUTHENTICATION);
            if (null == this.mah) {
                this.mah = this.app.getInstance(RedirectToLoginUrl.class);
            }
        }
        return this.mah;
    }

    private void _mergeMissingAuthenticationHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_MISSING_AUTHENTICATION)) {
            this.mah = config.mah;
        }
    }

    protected T ajaxMissingAuthenticationHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.ajaxMah = handler;
        return this.me();
    }

    public MissingAuthenticationHandler ajaxMissingAuthenticationHandler() {
        if (null == this.ajaxMah) {
            this.ajaxMah = (MissingAuthenticationHandler)this.get(AppConfigKey.HANDLER_MISSING_AUTHENTICATION_AJAX);
            if (null == this.ajaxMah) {
                this.ajaxMah = this.missingAuthenticationHandler();
            }
        }
        return this.ajaxMah;
    }

    private void _mergeAjaxMissingAuthenticationHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_MISSING_AUTHENTICATION_AJAX)) {
            this.ajaxMah = config.ajaxMah;
        }
    }

    protected T csrfCheckFailureHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.csrfCheckFailureHandler = handler;
        return this.me();
    }

    public MissingAuthenticationHandler csrfCheckFailureHandler() {
        if (null == this.csrfCheckFailureHandler) {
            this.csrfCheckFailureHandler = (MissingAuthenticationHandler)this.get(AppConfigKey.HANDLER_CSRF_CHECK_FAILURE);
            if (null == this.csrfCheckFailureHandler) {
                this.csrfCheckFailureHandler = this.missingAuthenticationHandler();
            }
        }
        return this.csrfCheckFailureHandler;
    }

    private void _mergeCsrfCheckFailureHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_CSRF_CHECK_FAILURE)) {
            this.csrfCheckFailureHandler = config.csrfCheckFailureHandler;
        }
    }

    protected T ajaxCsrfCheckFailureHandler(MissingAuthenticationHandler handler) {
        E.NPE((Object)handler);
        this.ajaxCsrfCheckFailureHandler = handler;
        return this.me();
    }

    public MissingAuthenticationHandler ajaxCsrfCheckFailureHandler() {
        if (null == this.csrfCheckFailureHandler) {
            this.csrfCheckFailureHandler = (MissingAuthenticationHandler)this.get(AppConfigKey.HANDLER_AJAX_CSRF_CHECK_FAILURE);
            if (null == this.csrfCheckFailureHandler) {
                this.csrfCheckFailureHandler = this.csrfCheckFailureHandler();
            }
        }
        return this.csrfCheckFailureHandler;
    }

    private void _mergeAjaxCsrfCheckFailureHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_AJAX_CSRF_CHECK_FAILURE)) {
            this.csrfCheckFailureHandler = config.csrfCheckFailureHandler;
        }
    }

    protected T namedPorts(NamedPort ... namedPorts) {
        this.namedPorts = C.listOf((Object[])namedPorts);
        return this.me();
    }

    public List<NamedPort> namedPorts() {
        if (null == this.namedPorts) {
            String s = (String)this.get(AppConfigKey.NAMED_PORTS);
            if (null == s) {
                this.namedPorts = this.cliOverHttp() ? C.list((Object)new NamedPort(PORT_CLI_OVER_HTTP, this.cliOverHttpPort())) : C.list();
            } else {
                String[] sa = s.split("[,;]+");
                ListBuilder builder = ListBuilder.create();
                for (String s0 : sa) {
                    String[] sa0 = s0.split(":");
                    E.invalidConfigurationIf((2 != sa0.length ? 1 : 0) != 0, (String)"Unknown named port configuration: %s", (Object[])new Object[]{s});
                    String name = sa0[0].trim();
                    String val = sa0[1].trim();
                    NamedPort port = new NamedPort(name, Integer.parseInt(val));
                    if (builder.contains((Object)port)) {
                        throw E.invalidConfiguration((String)"port[%s] already configured", (Object[])new Object[]{name});
                    }
                    builder.add((Object)port);
                }
                if (this.cliOverHttp()) {
                    builder.add((Object)new NamedPort(PORT_CLI_OVER_HTTP, this.cliOverHttpPort()));
                }
                this.namedPorts = builder.toList();
            }
        }
        return this.namedPorts;
    }

    public NamedPort namedPort(String portId) {
        for (NamedPort np : this.namedPorts()) {
            if (!np.name().equalsIgnoreCase(portId)) continue;
            return np;
        }
        return null;
    }

    private void _mergePorts(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.NAMED_PORTS)) {
            this.namedPorts = config.namedPorts;
        }
    }

    protected T encoding(String encoding) {
        E.illegalArgumentIf(((encoding = encoding.trim()).length() == 0 ? 1 : 0) != 0, (String)"encoding cannot be empty");
        this.encoding = encoding;
        return this.me();
    }

    public String encoding() {
        if (null == this.encoding) {
            this.encoding = (String)this.get(AppConfigKey.ENCODING);
            if (null == this.encoding) {
                this.encoding = StandardCharsets.UTF_8.name();
            }
        }
        return this.encoding;
    }

    private void _mergeEncoding(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.ENCODING)) {
            this.encoding = conf.encoding;
        }
    }

    protected T dateFormat(String fmt) {
        E.illegalArgumentIf((boolean)S.blank((String)fmt), (String)"Date format cannot be empty");
        this.dateFmt = fmt;
        return this.me();
    }

    public String dateFormat() {
        if (null == this.dateFmt) {
            this.dateFmt = (String)this.get(AppConfigKey.FORMAT_DATE);
            if (null == this.dateFmt) {
                DateFormat formatter = DateFormat.getDateInstance();
                this.dateFmt = ((SimpleDateFormat)formatter).toPattern();
            }
        }
        return this.dateFmt;
    }

    private void _mergeDateFmt(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.FORMAT_DATE)) {
            this.dateFmt = conf.dateFmt;
        }
    }

    protected T timeFormat(String fmt) {
        E.illegalArgumentIf((boolean)S.blank((String)fmt), (String)"Time format cannot be empty");
        this.timeFmt = fmt;
        return this.me();
    }

    public String timeFormat() {
        if (null == this.timeFmt) {
            this.timeFmt = (String)this.get(AppConfigKey.FORMAT_TIME);
            if (null == this.timeFmt) {
                DateFormat formatter = DateFormat.getTimeInstance();
                this.timeFmt = ((SimpleDateFormat)formatter).toPattern();
            }
        }
        return this.timeFmt;
    }

    private void _mergeTimeFmt(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.FORMAT_TIME)) {
            this.timeFmt = conf.timeFmt;
        }
    }

    protected T dateTimeFormat(String fmt) {
        E.illegalArgumentIf((boolean)S.blank((String)fmt), (String)"Date time format cannot be empty");
        this.dateDateTimeFmt = fmt;
        return this.me();
    }

    public String dateTimeFormat() {
        if (null == this.dateDateTimeFmt) {
            this.dateDateTimeFmt = (String)this.get(AppConfigKey.FORMAT_DATE_TIME);
            if (null == this.dateDateTimeFmt) {
                DateFormat formatter = DateFormat.getDateTimeInstance();
                this.dateDateTimeFmt = ((SimpleDateFormat)formatter).toPattern();
            }
        }
        return this.dateDateTimeFmt;
    }

    private void _mergeDateTimeFmt(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.FORMAT_DATE_TIME)) {
            this.dateDateTimeFmt = conf.dateDateTimeFmt;
        }
    }

    protected T locale(Locale locale) {
        E.NPE((Object)locale);
        this.locale = locale;
        return this.me();
    }

    public Locale locale() {
        if (null == this.locale) {
            this.locale = (Locale)this.get(AppConfigKey.LOCALE);
            if (null == this.locale) {
                this.locale = Locale.getDefault();
            }
        }
        return this.locale;
    }

    private void _mergeLocale(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.LOCALE)) {
            this.locale = conf.locale;
        }
    }

    protected T sourceVersion(JavaVersion version) {
        this.sourceVersion = ((FastStr)FastStr.of((String)version.name()).substr(1)).replace('_', '.').toString();
        return this.me();
    }

    public String sourceVersion() {
        if (null == this.sourceVersion) {
            this.sourceVersion = (String)this.get(AppConfigKey.SOURCE_VERSION);
            if (null == this.sourceVersion) {
                this.sourceVersion = "1." + $.JAVA_VERSION;
            } else if (this.sourceVersion.startsWith("1.")) {
                this.sourceVersion = this.sourceVersion.substring(0, 3);
            }
        }
        return this.sourceVersion;
    }

    private void _mergeSourceVersion(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.SOURCE_VERSION)) {
            this.sourceVersion = conf.sourceVersion;
        }
    }

    protected T targetVersion(JavaVersion version) {
        this.targetVersion = ((FastStr)FastStr.of((String)version.name()).substr(1)).replace('_', '.').toString();
        return this.me();
    }

    public String targetVersion() {
        if (null == this.targetVersion) {
            this.targetVersion = (String)this.get(AppConfigKey.TARGET_VERSION);
            if (null == this.targetVersion) {
                this.targetVersion = "1." + $.JAVA_VERSION;
            } else if (this.targetVersion.startsWith("1.")) {
                this.targetVersion = this.targetVersion.substring(0, 3);
            }
        }
        return this.targetVersion;
    }

    private void _mergeTargetVersion(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.TARGET_VERSION)) {
            this.targetVersion = conf.targetVersion;
        }
    }

    public Osgl.Predicate<String> appClassTester() {
        if (null == this.APP_CLASS_TESTER) {
            String[] sp;
            int len;
            String scanPackage = (String)this.get(AppConfigKey.SCAN_PACKAGE);
            this.APP_CLASS_TESTER = S.isBlank((String)scanPackage) ? this.SYSTEM_SCAN_LIST : (1 == (len = (sp = scanPackage.trim().split("[\\s,;:]+")).length) ? S.F.startsWith((String)sp[0]).or(new Osgl.Function[]{this.SYSTEM_SCAN_LIST}) : new Osgl.Predicate<String>(){

                public boolean test(String className) {
                    for (int i = 0; i < len; ++i) {
                        if (!className.startsWith(sp[i])) continue;
                        return true;
                    }
                    return false;
                }
            }.or(new Osgl.Function[]{this.SYSTEM_SCAN_LIST}));
        }
        return this.APP_CLASS_TESTER;
    }

    public boolean needEnhancement(String className) {
        return this.appClassTester().test((Object)className) || this.controllerNameTester().test((Object)className);
    }

    private Osgl.Predicate<String> controllerNameTester() {
        if (null == this.CONTROLLER_CLASS_TESTER) {
            Osgl.Predicate f2 = Osgl.F.no();
            this.CONTROLLER_CLASS_TESTER = f2.or(new Osgl.Function[]{this.app().router().f.IS_CONTROLLER});
        }
        return this.CONTROLLER_CLASS_TESTER;
    }

    protected T templatePathResolver(TemplatePathResolver resolver) {
        E.NPE((Object)resolver);
        this.templatePathResolver = resolver;
        return this.me();
    }

    public TemplatePathResolver templatePathResolver() {
        if (null == this.templatePathResolver) {
            this.templatePathResolver = (TemplatePathResolver)this.get(AppConfigKey.RESOLVER_TEMPLATE_PATH);
            if (null == this.templatePathResolver) {
                this.templatePathResolver = new TemplatePathResolver();
            }
        }
        return this.templatePathResolver;
    }

    private void _mergeTemplatePathResolver(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RESOLVER_TEMPLATE_PATH)) {
            this.templatePathResolver = conf.templatePathResolver;
        }
    }

    protected T templateHome(String home) {
        E.illegalArgumentIf(((home = home.trim()).length() == 0 ? 1 : 0) != 0, (String)"template home cannot be empty");
        this.templateHome = home;
        return this.me();
    }

    public String templateHome() {
        if (null == this.templateHome) {
            this.templateHome = (String)this.get(AppConfigKey.TEMPLATE_HOME);
            if (null == this.templateHome) {
                this.templateHome = "default";
            }
        }
        return this.templateHome;
    }

    private void _mergeTemplateHome(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.TEMPLATE_HOME)) {
            this.templateHome = conf.templateHome;
        }
    }

    protected T pingPath(String path) {
        this.pingPathResolved = true;
        this.pingPath = path.trim();
        return this.me();
    }

    public String pingPath() {
        if (!this.pingPathResolved) {
            this.pingPath = (String)this.get(AppConfigKey.PING_PATH);
            this.pingPathResolved = true;
        }
        return this.pingPath;
    }

    private void _mergePingPath(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.PING_PATH)) {
            this.pingPath = config.pingPath;
            this.pingPathResolved = config.pingPathResolved;
        }
    }

    protected T renderJsonContentTypeIE(String contentType) {
        this.setRenderJsonContenTypeIE(contentType);
        return this.me();
    }

    private void setRenderJsonContenTypeIE(String contentType) {
        if (H.Format.JSON.contentType().equalsIgnoreCase(contentType)) {
            this.renderJsonIeFix = false;
            return;
        }
        this.renderJsonIeFix = true;
        this.jsonIE = H.Format.of((String)"json_ie", (String)contentType);
        this.jsonContentTypeProvider = new Osgl.Func0<H.Format>(){

            public H.Format apply() throws NotAppliedException, Osgl.Break {
                UserAgent ua;
                ActionContext context = ActionContext.current();
                if (null != context && (ua = context.userAgent()).isIE()) {
                    return AppConfig.this.jsonIE;
                }
                return H.Format.JSON;
            }
        };
    }

    public Osgl.Func0<H.Format> jsonContentTypeProvider() {
        if (null == this.renderJsonIeFix) {
            String contentType = (String)this.get(AppConfigKey.RENDER_JSON_CONTENT_TYPE_IE);
            if (null != contentType) {
                this.setRenderJsonContenTypeIE(contentType);
            } else {
                this.renderJsonIeFix = false;
            }
        }
        return this.renderJsonIeFix != false ? this.jsonContentTypeProvider : null;
    }

    private void _mergeRenderJsonContentTypeIE(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RENDER_JSON_CONTENT_TYPE_IE)) {
            this.jsonContentTypeProvider = conf.jsonContentTypeProvider;
            this.renderJsonIeFix = conf.renderJsonIeFix;
            this.jsonIE = conf.jsonIE;
        }
    }

    protected T renderJsonOutputCharset(boolean outputCharset) {
        this.renderJsonOutputCharset = outputCharset;
        return this.me();
    }

    public boolean renderJsonOutputCharset() {
        if (null == this.renderJsonOutputCharset) {
            this.renderJsonOutputCharset = (Boolean)this.get(AppConfigKey.RENDER_JSON_OUTPUT_CHARSET);
            if (null == this.renderJsonOutputCharset) {
                this.renderJsonOutputCharset = true;
            }
        }
        return this.renderJsonOutputCharset;
    }

    private void _mergeRenderJsonOutputCharset(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.RENDER_JSON_OUTPUT_CHARSET)) {
            this.renderJsonOutputCharset = config.renderJsonOutputCharset;
        }
    }

    protected T serverHeader(String header) {
        this.serverHeader = header;
        return this.me();
    }

    public String serverHeader() {
        if (null == this.serverHeader) {
            this.serverHeader = (String)this.get(AppConfigKey.SERVER_HEADER);
            if (null == this.serverHeader) {
                this.serverHeader = "act";
            }
        }
        return this.serverHeader;
    }

    private void _mergeServerHeader(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SERVER_HEADER)) {
            this.serverHeader = config.serverHeader;
        }
    }

    protected T sessionKeyUsername(String name) {
        E.illegalArgumentIf(((name = name.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"session cookie name cannot be blank");
        this.sessionKeyUsername = name;
        return this.me();
    }

    public String sessionKeyUsername() {
        if (null == this.sessionKeyUsername) {
            String username = (String)this.get(AppConfigKey.SESSION_KEY_USERNAME);
            if (S.blank((String)username)) {
                username = "username";
            }
            this.sessionKeyUsername = username;
        }
        return this.sessionKeyUsername;
    }

    private void _mergeSessionKeyUsername(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_KEY_USERNAME)) {
            this.sessionKeyUsername = config.sessionKeyUsername;
        }
    }

    protected T cookiePrefix(String prefix) {
        E.illegalArgumentIf(((prefix = prefix.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"cookie prefix cannot be blank");
        this.cookiePrefix = prefix;
        return this.me();
    }

    private String cookiePrefix() {
        if (null == this.cookiePrefix) {
            this.cookiePrefix = (String)this.get(AppConfigKey.COOKIE_PREFIX);
            if (null == this.cookiePrefix) {
                String appName = this.app().name();
                if (S.blank((String)appName)) {
                    appName = "act";
                }
                String[] sa = appName.split("[\\s]+");
                int len = sa.length;
                switch (len) {
                    case 1: {
                        String s = sa[0];
                        this.cookiePrefix = S.concat((String)(s.length() > 2 ? s.substring(0, 3) : s), (String)"-");
                        break;
                    }
                    case 2: {
                        String s1 = sa[0];
                        String s2 = sa[1];
                        s1 = s1.length() > 1 ? s1.substring(0, 2) : s1;
                        s2 = s2.length() > 1 ? s2.substring(0, 2) : s2;
                        this.cookiePrefix = S.concat((String)s1, (String)"-", (String)s2, (String)"-");
                        break;
                    }
                    default: {
                        this.cookiePrefix = S.concat((String)sa[0].substring(0, 1), (String)sa[1].substring(0, 1), (String)sa[2].substring(0, 1), (String)"-");
                    }
                }
            }
            this.cookiePrefix = this.cookiePrefix.trim().toLowerCase();
        }
        return this.cookiePrefix;
    }

    private void _mergeCookiePrefix(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.COOKIE_PREFIX)) {
            this.cookiePrefix = config.cookiePrefix;
        }
    }

    protected T sessionCookieName(String name) {
        E.illegalArgumentIf(((name = name.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"session cookie name cannot be blank");
        E.illegalArgumentIf((boolean)S.eq((String)name, (String)this.flashCookieName), (String)"session cookie name cannot be the same with flash cookie name");
        this.sessionCookieName = name;
        return this.me();
    }

    public String sessionCookieName() {
        if (null == this.sessionCookieName) {
            this.sessionCookieName = this.cookieName("session");
        }
        return this.sessionCookieName;
    }

    private void _mergeSessionCookieName(AppConfig config) {
        if (null != config.sessionCookieName) {
            this.sessionCookieName = config.sessionCookieName;
        }
    }

    protected T flashCookieName(String name) {
        E.illegalArgumentIf(((name = name.trim().toLowerCase()).length() == 0 ? 1 : 0) != 0, (String)"flash cookie name cannot be blank");
        E.illegalArgumentIf((boolean)S.eq((String)name, (String)this.sessionCookieName), (String)"flash cookie name cannot be the same with session cookie name");
        this.flashCookieName = name;
        return this.me();
    }

    public String flashCookieName() {
        if (null == this.flashCookieName) {
            this.flashCookieName = this.cookieName("flash");
        }
        return this.flashCookieName;
    }

    private void _mergeFlashCookieName(AppConfig config) {
        if (null != config.flashCookieName) {
            this.flashCookieName = config.flashCookieName;
        }
    }

    protected T sessionTtl(int seconds) {
        this.sessionTtl = seconds;
        return this.me();
    }

    public int sessionTtl() {
        if (null == this.sessionTtl) {
            this.sessionTtl = this.getInteger(AppConfigKey.SESSION_TTL);
            if (null == this.sessionTtl) {
                this.sessionTtl = 1800;
            }
        }
        return this.sessionTtl;
    }

    private void _mergeSessionTtl(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_TTL)) {
            this.sessionTtl = conf.sessionTtl;
        }
    }

    protected T sessionPersistent(boolean persistenSession) {
        this.sessionPersistent = persistenSession;
        return this.me();
    }

    public boolean persistSession() {
        if (null == this.sessionPersistent) {
            this.sessionPersistent = (Boolean)this.get(AppConfigKey.SESSION_PERSISTENT_ENABLED);
            if (null == this.sessionPersistent) {
                this.sessionPersistent = false;
            }
        }
        return this.sessionPersistent;
    }

    private void _mergeSessionPersistent(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_PERSISTENT_ENABLED)) {
            this.sessionPersistent = config.sessionPersistent;
        }
    }

    protected T sessionEncrypt(boolean encryptSession) {
        this.sessionEncrypt = encryptSession;
        return this.me();
    }

    public boolean encryptSession() {
        if (null == this.sessionEncrypt) {
            this.sessionEncrypt = (Boolean)this.get(AppConfigKey.SESSION_ENCRYPT_ENABLED);
            if (null == this.sessionEncrypt) {
                this.sessionEncrypt = false;
            }
        }
        return this.sessionEncrypt;
    }

    private void _mergeSessionEncrpt(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_ENCRYPT_ENABLED)) {
            this.sessionEncrypt = config.sessionEncrypt;
        }
    }

    protected T sessionMapper(SessionMapper sessionMapper) {
        this.sessionMapper = sessionMapper;
        return this.me();
    }

    public SessionMapper sessionMapper() {
        if (null == this.sessionMapper) {
            Object o = this.get(AppConfigKey.SESSION_MAPPER);
            this.sessionMapper = SessionMapper.DefaultSessionMapper.wrap((SessionMapper)o);
        }
        return this.sessionMapper;
    }

    private void _mergeSessionMapper(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_MAPPER)) {
            this.sessionMapper = config.sessionMapper;
        }
    }

    protected T sessionSecure(boolean secure) {
        this.sessionSecure = secure;
        return this.me();
    }

    public boolean sessionSecure() {
        if (null == this.sessionSecure) {
            this.sessionSecure = (Boolean)this.get(AppConfigKey.SESSION_SECURE);
            if (null == this.sessionSecure) {
                this.sessionSecure = this.httpSecure();
            }
        }
        return this.sessionSecure;
    }

    private void _mergeSessionSecure(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SESSION_SECURE)) {
            this.sessionSecure = config.sessionSecure;
        }
    }

    protected T secret(String secret) {
        E.illegalArgumentIf((boolean)S.blank((String)secret));
        this.secret = secret;
        return this.me();
    }

    public String secret() {
        if (null == this.secret) {
            this.secret = (String)this.get(AppConfigKey.SECRET);
            if (null == this.secret) {
                this.secret = "myawesomeapp";
                logger.warn("Application secret key not set! You are in the dangerous zone!!!");
            }
        }
        return this.secret;
    }

    private void _mergeSecret(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.SECRET)) {
            this.secret = config.secret;
        }
    }

    public List<File> moduleBases() {
        if (null == this.moduleBases) {
            String v = (String)this.get(AppConfigKey.MODULES);
            this.moduleBases = this.processModules(v);
        }
        return this.moduleBases;
    }

    private List<File> processModules(String v) {
        if (S.blank((String)v)) {
            return C.list();
        }
        C.List files = C.newList();
        File base = this.app.base();
        for (String s : v.trim().split("[;:]+")) {
            File file = (s = s.trim()).startsWith("/") || s.startsWith("\\") ? new File(s) : ProjectLayout.Utils.file(base, s);
            if (!file.isDirectory()) {
                logger.warn("Cannot locate extra source dir: %s", new Object[]{s});
                continue;
            }
            files.add(file);
        }
        return C.list((List)files);
    }

    protected T metricEnable(boolean enable) {
        this.metricEnabled = enable;
        return this.me();
    }

    public boolean metricEnabled() {
        if (null == this.metricEnabled) {
            this.metricEnabled = (Boolean)this.get(AppConfigKey.METRIC_ENABLED);
            if (null == this.metricEnabled) {
                this.metricEnabled = true;
            }
        }
        return this.metricEnabled;
    }

    private void _mergeMetricEnabled(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.METRIC_ENABLED)) {
            this.metricEnabled = conf.metricEnabled;
        }
    }

    public boolean possibleControllerClass(String className) {
        return this.appClassTester().test((Object)className);
    }

    protected T cacheService(CacheServiceProvider csp) {
        E.NPE((Object)csp);
        this.csp = csp;
        return this.me();
    }

    protected T cacheService(Class<? extends CacheServiceProvider> csp) {
        this.csp = (CacheServiceProvider)$.newInstance(csp);
        return this.me();
    }

    public CacheService cacheService(String name) {
        if (null == this.csp) {
            try {
                this.csp = (CacheServiceProvider)this.get(AppConfigKey.CACHE_IMPL);
            }
            catch (ConfigurationException e) {
                Object obj = AppConfigKey.helper.getValFromAliases(this.raw, AppConfigKey.CACHE_IMPL.toString(), "impl", null);
                this.csp = CacheServiceProvider.Impl.valueOfIgnoreCase((String)obj.toString());
                if (null != this.csp) {
                    return this.csp.get(name);
                }
                throw e;
            }
            if (null == this.csp) {
                this.csp = CacheServiceProvider.Impl.Auto;
            }
        }
        return this.csp.get(name);
    }

    private void _mergeCacheServiceProvider(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CACHE_IMPL)) {
            this.csp = config.csp;
        }
    }

    protected T cacheName(String name) {
        this._cacheName = name;
        return this.me();
    }

    public String cacheName() {
        if (null == this._cacheName) {
            this._cacheName = (String)this.get(AppConfigKey.SESSION_KEY_USERNAME);
            if (null == this._cacheName) {
                this._cacheName = "_act_app_";
            }
        }
        return this._cacheName;
    }

    private void _mergeCacheName(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.CACHE_NAME)) {
            this._cacheName = config._cacheName;
        }
    }

    protected T cacheNameSession(String name) {
        this._cacheNameSession = name;
        return this.me();
    }

    public String cacheNameSession() {
        if (null == this._cacheNameSession) {
            this._cacheNameSession = (String)this.get(AppConfigKey.CACHE_NAME_SESSION);
            if (null == this._cacheNameSession) {
                this._cacheNameSession = this.cacheName();
            }
        }
        return this._cacheNameSession;
    }

    protected T unknownHttpMethodProcessor(UnknownHttpMethodProcessor handler) {
        this._unknownHttpMethodProcessor = (UnknownHttpMethodProcessor)$.notNull((Object)handler);
        return this.me();
    }

    public UnknownHttpMethodProcessor unknownHttpMethodProcessor() {
        if (null == this._unknownHttpMethodProcessor) {
            this._unknownHttpMethodProcessor = (UnknownHttpMethodProcessor)this.get(AppConfigKey.HANDLER_UNKNOWN_HTTP_METHOD);
            if (null == this._unknownHttpMethodProcessor) {
                this._unknownHttpMethodProcessor = UnknownHttpMethodProcessor.METHOD_NOT_ALLOWED;
            }
        }
        return this._unknownHttpMethodProcessor;
    }

    private void _mergeUnknownHttpMethodHandler(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.HANDLER_UNKNOWN_HTTP_METHOD)) {
            this._unknownHttpMethodProcessor = config._unknownHttpMethodProcessor;
        }
    }

    protected T resourcePreloadSizeLimit(int limit) {
        this.resourcePreloadSizeLimit = limit;
        return this.me();
    }

    public int resourcePreloadSizeLimit() {
        if (null == this.resourcePreloadSizeLimit) {
            this.resourcePreloadSizeLimit = this.getInteger(AppConfigKey.RESOURCE_PRELOAD_SIZE_LIMIT);
            if (null == this.resourcePreloadSizeLimit) {
                this.resourcePreloadSizeLimit = 10240;
            } else if (this.resourcePreloadSizeLimit <= 0) {
                logger.warn("resource.preload.size.limit is set to zero or below, resource preload is disabled!");
            }
        }
        return this.resourcePreloadSizeLimit;
    }

    private void _mergeResourcePreloadSizeLimit(AppConfig conf) {
        if (!this.hasConfiguration(AppConfigKey.RESOURCE_PRELOAD_SIZE_LIMIT)) {
            this.resourcePreloadSizeLimit = conf.resourcePreloadSizeLimit;
        }
    }

    protected T enableUploadFileDownload(boolean b) {
        this.uploadFileDownload = b;
        return this.me();
    }

    public boolean allowDownloadUploadFile() {
        if (null == this.uploadFileDownload) {
            this.uploadFileDownload = (Boolean)this.get(AppConfigKey.UPLOAD_FILE_DOWNLOAD);
            if (null == this.uploadFileDownload) {
                this.uploadFileDownload = false;
            }
        }
        return this.uploadFileDownload;
    }

    private void _mergeUploadFileDownload(AppConfig config) {
        if (!this.hasConfiguration(AppConfigKey.UPLOAD_FILE_DOWNLOAD)) {
            this.uploadFileDownload = config.uploadFileDownload;
        }
    }

    public void loadJarProperties(Map<String, Properties> jarProperties) {
        Properties p0 = jarProperties.remove("common");
        Properties p1 = jarProperties.remove(ConfLoader.confSetName());
        if (null != p1) {
            if (null != p0) {
                p0.putAll((Map<?, ?>)p1);
            } else {
                p0 = p1;
            }
        }
        if (null != p0) {
            this.loadJarProperties(p0);
        }
    }

    private void loadJarProperties(Properties p) {
        Enumeration<?> keys = p.propertyNames();
        while (keys.hasMoreElements()) {
            String key = S.string(keys.nextElement());
            if (this.raw.containsKey(key)) continue;
            this.raw.put(key, p.getProperty(key));
        }
    }

    public void _merge(AppConfigurator conf) {
        this.app.eventBus().trigger(AppEventId.CONFIG_PREMERGE);
        if (this.mergeTracker.contains(conf)) {
            return;
        }
        this.mergeTracker.add(conf);
        this._mergeBasicAuthentication(conf);
        this._mergeCacheName(conf);
        this._mergeCors(conf);
        this._mergeCorsOrigin(conf);
        this._mergeCorsHeaders(conf);
        this._mergeCorsHeadersExpose(conf);
        this._mergeCorsHeadersAllowed(conf);
        this._mergeCorsMaxAge(conf);
        this._mergeCorsOptionCheck(conf);
        this._mergeCliEnabled(conf);
        this._mergeCliJSONPageSz(conf);
        this._mergeCliTablePageSz(conf);
        this._mergeCliOverHttp(conf);
        this._mergeCliOverHttpAuthority(conf);
        this._mergeCliOverHttpPort(conf);
        this._mergeCliOverHttpTitle(conf);
        this._mergeCliOverHttpSysCmd(conf);
        this._mergeCliPort(conf);
        this._mergeCliSessionExpiration(conf);
        this._mergeCsrf(conf);
        this._mergeCsrfParamName(conf);
        this._mergeCsrfHeaderName(conf);
        this._mergeCsrfCookieName(conf);
        this._mergeCsrfProtector(conf);
        this._mergeCsrfCheckFailureHandler(conf);
        this._mergeAjaxCsrfCheckFailureHandler(conf);
        this._mergeCookieDomain(conf);
        this._mergeMaxCliSession(conf);
        this._mergeDspToken(conf);
        this._mergeEnumResolvingCaseSensitive(conf);
        this._mergeXForwardedProtocol(conf);
        this._mergeHost(conf);
        this._mergeLoginUrl(conf);
        this._mergeAjaxLoginUrl(conf);
        this._mergeHttpMaxParams(conf);
        this._mergeJobPoolSize(conf);
        this._mergeMissingAuthenticationHandler(conf);
        this._mergeAjaxMissingAuthenticationHandler(conf);
        this._mergeHttpExternal(conf);
        this._mergeHttpExternalPort(conf);
        this._mergeHttpExternalSecurePort(conf);
        this._mergeHttpPort(conf);
        this._mergeHttpSecure(conf);
        this._mergePorts(conf);
        this._mergeContentSuffixAware(conf);
        this._mergeSequenceNumberGenerator(conf);
        this._mergeErrorTemplatePathResolver(conf);
        this._mergeDateFmt(conf);
        this._mergeDateTimeFmt(conf);
        this._mergeMetricEnabled(conf);
        this._mergeTimeFmt(conf);
        this._mergeEncoding(conf);
        this._mergeNodeIdProvider(conf);
        this._mergeI18nEnabled(conf);
        this._mergeLocaleParamName(conf);
        this._mergeLocaleCookieName(conf);
        this._mergeIpEffectiveBytes(conf);
        this._mergeStartIdFile(conf);
        this._mergeStartIdProvider(conf);
        this._mergeSequenceProvider(conf);
        this._mergeLongEncoder(conf);
        this._mergeLocale(conf);
        this._mergeResourcePreloadSizeLimit(conf);
        this._mergeSourceVersion(conf);
        this._mergeTargetVersion(conf);
        this._mergeTemplatePathResolver(conf);
        this._mergeTemplateHome(conf);
        this._mergeDefaultView(conf);
        this._mergePingPath(conf);
        this._mergeRenderJsonContentTypeIE(conf);
        this._mergeRenderJsonOutputCharset(conf);
        this._mergeServerHeader(conf);
        this._mergeCookiePrefix(conf);
        this._mergeSessionCookieName(conf);
        this._mergeFlashCookieName(conf);
        this._mergeSessionTtl(conf);
        this._mergeSessionPersistent(conf);
        this._mergeSessionEncrpt(conf);
        this._mergeSessionSecure(conf);
        this._mergeSessionKeyUsername(conf);
        this._mergeSessionMapper(conf);
        this._mergeSecret(conf);
        this._mergeCacheServiceProvider(conf);
        this._mergeUnknownHttpMethodHandler(conf);
        this._mergeUploadFileDownload(conf);
        Set<String> keys = conf.propKeys();
        if (!keys.isEmpty()) {
            for (String k : keys) {
                if (this.raw.containsKey(k)) continue;
                this.raw.put(k, conf.propVal(k));
            }
        }
    }

    @Override
    protected void releaseResources() {
        this.app = null;
        super.releaseResources();
    }

    protected T me() {
        return (T)((AppConfigurator)$.cast((Object)this));
    }

    private String cookieName(String suffix) {
        return S.concat((String)this.cookiePrefix(), (String)suffix);
    }

    static {
        MvcConfig.errorPageRenderer((ErrorPageRenderer)new ActErrorPageRender());
        MvcConfig.beforeCommitResultHandler(ResultEvent.BEFORE_COMMIT_HANDLER);
        MvcConfig.afterCommitResultHandler(ResultEvent.AFTER_COMMIT_HANDLER);
        MvcConfig.messageTranslater((Osgl.Function)new Osgl.Transformer<String, String>(){

            public String transform(String message) {
                if (Act.appConfig().i18nEnabled()) {
                    String translated = I18n.i18n(true, I18n.locale(), "messages", message, new Object[0]);
                    if (message == translated) {
                        message = translated = I18n.i18n(true, I18n.locale(), MvcConfig.class.getName(), message, new Object[0]);
                    }
                    return message;
                }
                return message;
            }
        });
    }
}

