/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.Act;
import act.conf.AppConfigKey;
import act.conf.Config;
import act.util.SysProps;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public abstract class ConfLoader<T extends Config> {
    private static Logger logger = L.get(ConfLoader.class);

    private static Map<String, Object> processConf(Map<String, ?> conf) {
        HashMap<String, Object> m = new HashMap<String, Object>(conf.size());
        for (String s : conf.keySet()) {
            Object o = conf.get(s);
            if (s.startsWith("act.")) {
                s = s.substring(4);
            }
            m.put(s, o);
        }
        return m;
    }

    public T load(File confFile) {
        Object rawConf = null == confFile ? C.newMap((Object[])new Object[0]) : this.loadConfFromDisk(confFile);
        Properties sysProps = System.getProperties();
        rawConf.putAll(sysProps);
        rawConf = ConfLoader.processConf(rawConf);
        return this.create((Map<String, ?>)rawConf);
    }

    protected abstract T create(Map<String, ?> var1);

    protected abstract String confFileName();

    private Map loadConfFromDisk(File conf) {
        if (conf.isDirectory()) {
            return this.loadConfFromDir(conf);
        }
        return this.loadConfFromFile(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadConfFromFile(File conf) {
        if (!conf.canRead()) {
            logger.warn("Cannot read conf file[%s]", new Object[]{conf.getAbsolutePath()});
            return C.newMap((Object[])new Object[0]);
        }
        InputStream is = null;
        if (null == conf) {
            ClassLoader cl = Act.class.getClassLoader();
            is = cl.getResourceAsStream("/" + this.confFileName());
        } else {
            try {
                is = new FileInputStream(conf);
            }
            catch (IOException e) {
                logger.warn((Throwable)e, "Error opening conf file:" + conf);
            }
        }
        if (null != is) {
            Properties p = new Properties();
            try {
                p.load(is);
                Properties properties = p;
                return properties;
            }
            catch (Exception e) {
                logger.warn((Throwable)e, "Error loading %s", new Object[]{this.confFileName()});
            }
            finally {
                IO.close((Closeable)is);
            }
        }
        return C.newMap((Object[])new Object[0]);
    }

    public static String common() {
        String common = SysProps.get("commonConfTag");
        if (S.blank((String)common)) {
            common = "common";
        }
        return common;
    }

    public static String confSetName() {
        String profile = SysProps.get(AppConfigKey.PROFILE.key());
        if (S.blank((String)profile)) {
            profile = Act.mode().name().toLowerCase();
        }
        return profile;
    }

    private Map loadConfFromDir(File confDir) {
        if (!confDir.exists()) {
            logger.warn("Cannot read conf dir[%s]", new Object[]{confDir.getAbsolutePath()});
            return C.newMap((Object[])new Object[0]);
        }
        C.Map map = C.newMap((Object[])new Object[0]);
        String common = ConfLoader.common();
        File commonConfDir = new File(confDir, common);
        if (commonConfDir.isDirectory()) {
            map.putAll(this.loadConfFromDir_(commonConfDir));
        }
        String profile = ConfLoader.confSetName();
        logger.debug("Loading conf profile: %s", new Object[]{profile});
        File taggedConfDir = new File(confDir, profile);
        if (taggedConfDir.exists() && taggedConfDir.isDirectory()) {
            map.putAll(this.loadConfFromDir_(taggedConfDir));
            return map;
        }
        map.putAll(this.loadConfFromDir_(confDir));
        return map;
    }

    private Map loadConfFromDir_(File confDir) {
        File[] confFiles = confDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".properties") || name.endsWith(".conf");
            }
        });
        if (null == confFiles) {
            return C.map((Object[])new Object[0]);
        }
        C.Map map = C.newMap((Object[])new Object[0]);
        int n = confFiles.length;
        for (int i = 0; i < n; ++i) {
            map.putAll(this.loadConfFromFile(confFiles[i]));
        }
        return map;
    }
}

