/*
 * Decompiled with CFR 0.152.
 */
package act.conf;

import act.conf.AppConfigKey;
import act.conf.ConfigKey;
import act.util.DestroyableBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.UnexpectedNewInstanceException;
import org.osgl.util.C;
import org.osgl.util.S;

public abstract class Config<E extends ConfigKey>
extends DestroyableBase {
    static final String PREFIX = "act.";
    static final int PREFIX_LEN = "act.".length();
    protected Map<String, Object> raw;
    protected Map<ConfigKey, Object> data;
    private static final Object NULL = new Object();

    public Config(Map<String, ?> configuration) {
        this.raw = new HashMap(configuration);
        this.data = new HashMap<ConfigKey, Object>(configuration.size());
    }

    public Config() {
        this(System.getProperties());
    }

    @Override
    protected void releaseResources() {
        this.raw.clear();
        this.data.clear();
        super.releaseResources();
    }

    public <T> T get(ConfigKey key) {
        Object o = this.data.get(key);
        if (null == o) {
            o = key.val(this.raw);
            if (null != o) {
                this.data.put(key, o);
            } else {
                this.data.put(key, NULL);
            }
        }
        if (o == NULL) {
            return null;
        }
        return (T)o;
    }

    public Integer getInteger(ConfigKey key) {
        Object retVal = this.get(key);
        if (null == retVal) {
            return null;
        }
        if (retVal instanceof Number) {
            return ((Number)retVal).intValue();
        }
        return Integer.parseInt(S.string(retVal));
    }

    boolean hasConfiguration(ConfigKey key) {
        Object o = this.data.get(key);
        if (null != o && NULL != o) {
            return true;
        }
        try {
            o = key.val(this.raw);
            if (null == o) {
                this.data.put(key, NULL);
                return false;
            }
            return true;
        }
        catch (ConfigurationException e) {
            Throwable t = e.getCause();
            if (t instanceof UnexpectedNewInstanceException) {
                return true;
            }
            throw e;
        }
    }

    public <T> List<T> getList(AppConfigKey key, Class<T> c) {
        Object o = this.data.get(key);
        if (null == o) {
            List<T> l = key.implList(key.key(), this.raw, c);
            this.data.put(key, l);
            return l;
        }
        return (List)o;
    }

    public <T> T get(String key) {
        ConfigKey rk;
        if (key.startsWith(PREFIX)) {
            key = key.substring(PREFIX_LEN);
        }
        if (null != (rk = this.keyOf(key))) {
            return this.get(rk);
        }
        return AppConfigKey.helper.getConfiguration(key, null, this.raw);
    }

    public <T> T getIgnoreCase(String key) {
        T t;
        if (key.startsWith(PREFIX)) {
            key = key.substring(PREFIX_LEN);
        }
        if (null != (t = this.get(key))) {
            return t;
        }
        key = key.toLowerCase();
        for (Map.Entry<String, Object> entries : this.raw.entrySet()) {
            if (entries.getKey().toLowerCase().equals(key)) {
                Object o = entries.getValue();
                if (o instanceof String) {
                    return (T)AppConfigKey.helper.evaluate(o.toString(), this.raw);
                }
                return (T)o;
            }
            if (!entries.getKey().replace('_', '.').equals(key.replace('_', '.'))) continue;
            Object o = entries.getValue();
            if (o instanceof String) {
                return (T)AppConfigKey.helper.evaluate(o.toString(), this.raw);
            }
            return (T)o;
        }
        return null;
    }

    public Map rawConfiguration() {
        return this.raw;
    }

    public Map subSet(String prefix) {
        String prefix2 = PREFIX + prefix;
        C.Map subset = C.newMap((Object[])new Object[0]);
        for (String key : this.raw.keySet()) {
            if (!key.startsWith(prefix) && !key.startsWith(prefix2)) continue;
            Object o = this.data.get(key);
            if (null == o) {
                o = this.raw.get(key);
                if (null == o) continue;
                if (o instanceof String) {
                    o = AppConfigKey.helper.evaluate(o.toString(), this.raw);
                }
            }
            if (key.startsWith(PREFIX)) {
                key = key.substring(4);
            }
            if (subset.containsKey(key)) continue;
            subset.put(key, o);
        }
        return subset;
    }

    protected abstract ConfigKey keyOf(String var1);
}

