/*
 * Decompiled with CFR 0.152.
 */
package act.controller;

import act.Act;
import act.app.ActionContext;
import act.controller.meta.HandlerMethodMetaInfo;
import act.data.Versioned;
import act.route.Router;
import act.util.ActContext;
import act.util.DisableFastJsonCircularReferenceDetect;
import act.util.FastJsonIterable;
import act.util.PropertySpec;
import act.view.ActBadRequest;
import act.view.ActConflict;
import act.view.ActForbidden;
import act.view.ActNotFound;
import act.view.ActUnauthorized;
import act.view.FilteredRenderJSON;
import act.view.FilteredRenderXML;
import act.view.RenderAny;
import act.view.RenderCSV;
import act.view.RenderJsonMap;
import act.view.RenderTemplate;
import act.view.ZXingResult;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.mvc.result.Accepted;
import org.osgl.mvc.result.BadRequest;
import org.osgl.mvc.result.Conflict;
import org.osgl.mvc.result.Created;
import org.osgl.mvc.result.Forbidden;
import org.osgl.mvc.result.NoContent;
import org.osgl.mvc.result.NotAcceptable;
import org.osgl.mvc.result.NotModified;
import org.osgl.mvc.result.Ok;
import org.osgl.mvc.result.Redirect;
import org.osgl.mvc.result.RenderBinary;
import org.osgl.mvc.result.RenderHtml;
import org.osgl.mvc.result.RenderJSON;
import org.osgl.mvc.result.RenderText;
import org.osgl.mvc.result.RenderXML;
import org.osgl.mvc.result.Result;
import org.osgl.mvc.result.Unauthorized;
import org.osgl.storage.ISObject;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.TYPE})
public @interface Controller {
    public String value() default "/";

    public String[] port() default {};

    public static class Util {
        public static final Ok OK = Ok.get();
        public static final Created CREATED = Created.INSTANCE;
        public static final Result CREATED_JSON = new Result(H.Status.CREATED, "{\"message\": \"Created\"}"){};
        public static final Result CREATED_XML = new Result(H.Status.CREATED, "<?xml version=\"1.0\" ?><message>Created</message>"){};
        public static final Result OK_JSON = new Result(H.Status.OK, "{\"message\": \"Okay\"}"){};
        public static final Result OK_XML = new Result(H.Status.OK, "<?xml version=\"1.0\" ?><message>Okay</message>"){};
        public static final NoContent NO_CONTENT = NoContent.get();

        public static Result ok() {
            H.Format accept = ActionContext.current().accept();
            if (H.Format.JSON == accept) {
                return OK_JSON;
            }
            if (H.Format.XML == accept) {
                return OK_XML;
            }
            return OK;
        }

        public static Created created(String resourceGetUrl) {
            return Created.withLocation((String)resourceGetUrl);
        }

        public static Created created() {
            return Created.INSTANCE;
        }

        public static NotModified notModified() {
            return NotModified.get();
        }

        public static NotModified notModified(String etag, Object ... args) {
            return NotModified.of((String)etag, (Object[])args);
        }

        public static Result accepted(String statusMonitorUrl) {
            return new Accepted(statusMonitorUrl);
        }

        public static Result notAcceptable() {
            return NotAcceptable.get();
        }

        public static Result notAcceptable(String msg, Object ... args) {
            return NotAcceptable.of((String)msg, (Object[])args);
        }

        public static Result notFound() {
            return ActNotFound.create();
        }

        public static Result notFound(String msg, Object ... args) {
            return ActNotFound.create(msg, args);
        }

        public static <T> T notFoundIfNull(T o) {
            if (null == o) {
                throw ActNotFound.create();
            }
            return o;
        }

        public static <T> T notFoundIfNull(T o, String msg, Object ... args) {
            if (null == o) {
                throw ActNotFound.create(msg, args);
            }
            return o;
        }

        public static void notFoundIf(boolean test) {
            if (test) {
                throw ActNotFound.create();
            }
        }

        public static void notFoundIf(boolean test, String msg, Object ... args) {
            if (test) {
                throw ActNotFound.create(msg, args);
            }
        }

        public static void notFoundIfNot(boolean test) {
            Util.notFoundIf(!test);
        }

        public static void notFoundIfNot(boolean test, String msg, Object ... args) {
            Util.notFoundIf(!test, msg, args);
        }

        public static BadRequest badRequest() {
            return ActBadRequest.create();
        }

        public static BadRequest badRequest(String msg, Object ... args) {
            return ActBadRequest.create(msg, args);
        }

        public static void badRequestIf(boolean test) {
            if (test) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIf(boolean test, String msg, Object ... args) {
            if (test) {
                throw ActBadRequest.create(msg, args);
            }
        }

        public static void badRequestIfBlank(String test) {
            if (S.blank((String)test)) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIfBlank(String test, String msg, Object ... args) {
            if (S.blank((String)test)) {
                throw ActBadRequest.create(msg, args);
            }
        }

        public static void badRequestIfNull(Object test) {
            if (null == test) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIfNull(Object test, String msg, Object ... args) {
            if (null == test) {
                throw ActBadRequest.create(msg, args);
            }
        }

        public static void badRequestIfNot(boolean test) {
            if (!test) {
                throw ActBadRequest.create();
            }
        }

        public static void badRequestIfNot(boolean test, String msg, Object ... args) {
            Util.badRequestIf(!test, msg, args);
        }

        public static Conflict conflict() {
            return ActConflict.create();
        }

        public static Conflict conflict(String message, Object ... args) {
            return ActConflict.create(message, args);
        }

        public static void conflictIf(boolean test) {
            if (test) {
                throw ActConflict.create();
            }
        }

        public static void conflictIf(boolean test, String message, Object ... args) {
            if (test) {
                throw ActConflict.create(message, args);
            }
        }

        public static void conflictIfNot(boolean test) {
            Util.conflictIf(!test);
        }

        public static void conflictIfNot(boolean test, String message, Object ... args) {
            Util.conflictIf(!test, message, args);
        }

        public static Unauthorized unauthorized() {
            return ActUnauthorized.create();
        }

        public static Unauthorized unauthorized(String realm) {
            return ActUnauthorized.create(realm);
        }

        public static void unauthorizedIf(boolean test) {
            if (test) {
                throw ActUnauthorized.create();
            }
        }

        public static void unauthorizedIf(boolean test, String realm) {
            if (test) {
                throw ActUnauthorized.create(realm);
            }
        }

        public static void unauthorizedIfNot(boolean test) {
            Util.unauthorizedIf(!test);
        }

        public static void unauthorizedIfNot(boolean test, String realm) {
            Util.unauthorizedIf(!test, realm);
        }

        public static Forbidden forbidden() {
            return ActForbidden.create();
        }

        public static Forbidden forbidden(String msg, Object ... args) {
            return ActForbidden.create(msg, args);
        }

        public static void forbiddenIf(boolean test) {
            if (test) {
                throw ActForbidden.create();
            }
        }

        public static void forbiddenIfNot(boolean test) {
            Util.forbiddenIf(!test);
        }

        public static void forbiddenIf(boolean test, String msg, Object ... args) {
            if (test) {
                throw ActForbidden.create(msg, args);
            }
        }

        public static void forbiddenIfNot(boolean test, String msg, Object ... args) {
            Util.forbiddenIf(!test, msg, args);
        }

        public static Redirect redirect(String url, Object ... args) {
            String inferFullActionPath;
            if (((url = S.fmt((String)url, (Object[])args)).contains(".") || url.contains("(")) && (inferFullActionPath = Router.inferFullActionPath(url)) != url) {
                url = ActionContext.current().router().reverseRoute(url);
            }
            return Redirect.of((String)url);
        }

        public static Redirect redirect(String url, Map reverseRoutingArguments) {
            url = Router.inferFullActionPath(url);
            url = ActionContext.current().router().reverseRoute(url, reverseRoutingArguments);
            return Redirect.of((String)url);
        }

        public static RenderText text(String msg, Object ... args) {
            return RenderText.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderText renderText(String msg, Object ... args) {
            return Util.text(msg, args);
        }

        public static RenderHtml html(String msg, Object ... args) {
            return RenderHtml.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderHtml renderHtml(String msg, Object args) {
            return Util.html(msg, args);
        }

        public static RenderJSON json(String msg, Object ... args) {
            return RenderJSON.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderJSON renderJson(String msg, Object ... args) {
            return Util.json(msg, args);
        }

        public static RenderJSON json(Object data) {
            return RenderJSON.of((H.Status)Util.successStatus(), (Object)data);
        }

        public static RenderJSON renderJson(Object data) {
            return Util.json(data);
        }

        public static RenderJsonMap jsonMap(Object ... data) {
            return RenderJsonMap.get();
        }

        public static RenderJsonMap renderJsonMap(Object ... data) {
            return Util.jsonMap(data);
        }

        public static RenderXML xml(String msg, Object ... args) {
            return RenderXML.of((H.Status)Util.successStatus(), (String)msg, (Object[])args);
        }

        public static RenderXML renderXml(String msg, Object ... args) {
            return Util.xml(msg, args);
        }

        public static RenderBinary binary(ISObject sobj) {
            return new RenderBinary(sobj.asInputStream(), sobj.getAttribute("filename"), sobj.getAttribute("content-type"), true);
        }

        public static RenderBinary renderBinary(ISObject sobj) {
            return Util.binary(sobj);
        }

        public static RenderBinary download(ISObject sobj) {
            return new RenderBinary(sobj.asInputStream(), sobj.getAttribute("filename"), sobj.getAttribute("content-type"), false);
        }

        public static RenderBinary binary(File file) {
            return new RenderBinary(file);
        }

        public static RenderBinary renderBinary(File file) {
            return Util.binary(file);
        }

        public static RenderBinary binary(Osgl.Function<OutputStream, ?> outputStreamWriter) {
            return new RenderBinary(outputStreamWriter);
        }

        public static RenderBinary renderBinary(Osgl.Function<OutputStream, ?> outputStreamWriter) {
            return Util.binary(outputStreamWriter);
        }

        public static RenderBinary download(File file) {
            return new RenderBinary(file, file.getName(), false);
        }

        public static ZXingResult barcode(String content) {
            return ZXingResult.barcode(content);
        }

        public static ZXingResult renderBarcode(String content) {
            return Util.barcode(content);
        }

        public static ZXingResult qrcode(String content) {
            return ZXingResult.qrcode(content);
        }

        public static ZXingResult renderQrcode(String content) {
            return Util.qrcode(content);
        }

        public static RenderTemplate template(Map<String, Object> args) {
            return RenderTemplate.of(args);
        }

        public static RenderTemplate renderTemplate(Map<String, Object> args) {
            return Util.template(args);
        }

        public static RenderTemplate renderTemplate(Object ... args) {
            return RenderTemplate.get();
        }

        public static RenderTemplate template(Object ... args) {
            return RenderTemplate.get(ActionContext.current().successStatus());
        }

        public static RenderAny render(Object ... args) {
            return RenderAny.get();
        }

        public static Result inferResult(Result r, ActionContext actionContext) {
            return r;
        }

        public static Result inferResult(String s, ActionContext actionContext) {
            H.Status status = actionContext.successStatus();
            if (actionContext.acceptJson()) {
                if (!(s = s.trim()).startsWith("[") && !s.startsWith("{")) {
                    s = S.fmt((String)"{\"result\": \"%s\"}", (Object[])new Object[]{org.rythmengine.utils.S.escapeJSON((Object)s)});
                }
                return RenderJSON.of((H.Status)status, (String)s);
            }
            H.Format fmt = actionContext.accept();
            if (H.Format.HTML == fmt || H.Format.UNKNOWN == fmt) {
                return RenderHtml.of((H.Status)status, (String)s);
            }
            if (H.Format.TXT == fmt || H.Format.CSV == fmt) {
                return RenderText.of((H.Status)status, (H.Format)fmt, (String)s, (Object[])new Object[0]);
            }
            if (H.Format.XML == fmt) {
                if (!(s = s.trim()).startsWith("<") && !s.endsWith(">")) {
                    s = S.fmt((String)"<result>%s</result>", (Object[])new Object[]{s});
                }
                return RenderText.of((H.Status)status, (H.Format)fmt, (String)s, (Object[])new Object[0]);
            }
            throw E.unexpected((String)"Cannot apply text result to format: %s", (Object[])new Object[]{fmt});
        }

        public static Result inferResult(Map<String, Object> map, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of(map);
            }
            return RenderTemplate.of(map);
        }

        public static Result inferResult(Object[] array, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((H.Status)actionContext.successStatus(), (Object)array);
            }
            throw E.tbd((String)"render template with render args in array");
        }

        public static Result inferResult(InputStream is, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((String)IO.readContentAsString((InputStream)is));
            }
            return new RenderBinary(is, null, true);
        }

        public static Result inferResult(File file, ActionContext actionContext) {
            if (actionContext.acceptJson()) {
                return RenderJSON.of((String)IO.readContentAsString((File)file));
            }
            return new RenderBinary(file);
        }

        public static Result inferResult(ISObject sobj, ActionContext context) {
            if (context.acceptJson()) {
                return RenderJSON.of((String)sobj.asString());
            }
            return Util.binary(sobj);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Result inferResult(HandlerMethodMetaInfo meta, Object v, ActionContext context, boolean hasTemplate) {
            H.Status status;
            if (v instanceof Result) {
                return (Result)((Object)v);
            }
            H.Request req = context.req();
            H.Status status2 = status = req.method() == H.Method.POST ? H.Status.CREATED : H.Status.OK;
            if (Act.isProd() && v instanceof Versioned && req.method().safe()) {
                Util.processEtag(meta, v, context, req);
            }
            if (hasTemplate) {
                if (v instanceof Map) {
                    return Util.inferToTemplate((Map)((Object)v), context);
                }
                return Util.inferToTemplate(v, context);
            }
            if (null == v) {
                return null;
            }
            if (v instanceof String) {
                return Util.inferResult((String)((Object)v), context);
            }
            if (v instanceof InputStream) {
                return Util.inferResult((InputStream)((Object)v), context);
            }
            if (v instanceof File) {
                return Util.inferResult((File)((Object)v), context);
            }
            if (v instanceof ISObject) {
                return Util.inferResult((ISObject)v, context);
            }
            if (v instanceof Map) {
                return RenderJSON.of((Object)v);
            }
            if (context.acceptJson()) {
                if (meta.disableJsonCircularRefDetect()) {
                    DisableFastJsonCircularReferenceDetect.option.set(true);
                }
                if (v instanceof Iterable && !(v instanceof Collection)) {
                    v = new FastJsonIterable(v);
                }
                PropertySpec.MetaInfo propertySpec = PropertySpec.MetaInfo.withCurrent(meta, (ActContext)context);
                try {
                    if (null == propertySpec) {
                        RenderJSON renderJSON = RenderJSON.of((H.Status)status, v);
                        return renderJSON;
                    }
                    FilteredRenderJSON filteredRenderJSON = FilteredRenderJSON.get(status, v, propertySpec, context);
                    return filteredRenderJSON;
                }
                finally {
                    if (meta.disableJsonCircularRefDetect()) {
                        DisableFastJsonCircularReferenceDetect.option.set(false);
                    }
                }
            }
            if (context.acceptXML()) {
                PropertySpec.MetaInfo propertySpec = PropertySpec.MetaInfo.withCurrent(meta, (ActContext)context);
                return new FilteredRenderXML(v, propertySpec, context);
            }
            if (context.accept() == H.Format.CSV) {
                PropertySpec.MetaInfo propertySpec = PropertySpec.MetaInfo.withCurrent(meta, (ActContext)context);
                return RenderCSV.get(status, v, propertySpec, context);
            }
            String s = meta.returnType().getDescriptor().startsWith("[") ? $.toString2(v) : v.toString();
            return Util.inferResult(s, context);
        }

        private static void processEtag(HandlerMethodMetaInfo meta, Object v, ActionContext context, H.Request req) {
            if (!(v instanceof Versioned)) {
                return;
            }
            String version = ((Versioned)v)._version();
            String etagVersion = Util.etag(meta, version);
            if (req.etagMatches(etagVersion)) {
                throw NotModified.get();
            }
            context.resp().etag(etagVersion);
        }

        private static String etag(HandlerMethodMetaInfo meta, String version) {
            return S.newBuffer((String)version).append(meta.hashCode()).toString();
        }

        private static Result inferToTemplate(Object v, ActionContext actionContext) {
            actionContext.renderArg("result", v);
            return RenderTemplate.get();
        }

        private static Result inferToTemplate(Map map, ActionContext actionContext) {
            return RenderTemplate.of(map);
        }

        private static H.Status successStatus() {
            return ActionContext.current().successStatus();
        }
    }
}

