/*
 * Decompiled with CFR 0.152.
 */
package act.controller.bytecode;

import act.Act;
import act.app.App;
import act.app.AppByteCodeScannerBase;
import act.app.AppClassLoader;
import act.app.event.AppEventId;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import act.asm.signature.SignatureReader;
import act.asm.signature.SignatureVisitor;
import act.controller.Controller;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.BindAnnoInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.ControllerClassMetaInfoManager;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.controller.meta.InterceptorType;
import act.controller.meta.ParamAnnoInfo;
import act.controller.meta.ParamAnnoInfoTrait;
import act.route.RouteSource;
import act.route.Router;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.util.ClassNode;
import act.util.GeneralAnnoInfo;
import act.util.PropertySpec;
import act.util.Virtual;
import java.lang.annotation.Annotation;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.mvc.annotation.With;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.ListBuilder;
import org.osgl.util.S;

public class ControllerByteCodeScanner
extends AppByteCodeScannerBase {
    private static final Logger logger = L.get(ControllerByteCodeScanner.class);
    private Router router;
    private ControllerClassMetaInfo classInfo;
    private volatile ControllerClassMetaInfoManager classInfoBase;

    @Override
    protected boolean shouldScan(String className) {
        boolean possibleController = this.config().possibleControllerClass(className);
        this.classInfo = new ControllerClassMetaInfo().possibleController(possibleController);
        return possibleController;
    }

    @Override
    protected void onAppSet() {
        this.router = this.app().router();
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        if (this.classInfo.isController()) {
            this.classInfoBase().registerControllerMetaInfo(this.classInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ControllerClassMetaInfoManager classInfoBase() {
        if (null == this.classInfoBase) {
            ControllerByteCodeScanner controllerByteCodeScanner = this;
            synchronized (controllerByteCodeScanner) {
                if (null == this.classInfoBase) {
                    this.classInfoBase = this.app().classLoader().controllerClassMetaInfoManager();
                }
            }
        }
        return this.classInfoBase;
    }

    private static class RouteRegister
    implements Runnable {
        List<Router> routers;
        List<String> paths;
        String methodName;
        ControllerClassMetaInfo classInfo;
        List<H.Method> httpMethods;
        Osgl.Var<Boolean> isVirtual;
        boolean noRegister;

        RouteRegister(List<H.Method> methods, List<String> paths, String methodName, List<Router> routers, ControllerClassMetaInfo classInfo, boolean noRegister, Osgl.Var<Boolean> isVirtual) {
            this.routers = routers;
            this.paths = paths;
            this.methodName = methodName;
            this.classInfo = classInfo;
            this.httpMethods = methods;
            this.noRegister = noRegister;
            this.isVirtual = isVirtual;
        }

        @Override
        public void run() {
            final HashSet<String> contexts = new HashSet<String>();
            if (!this.noRegister) {
                String contextPath = this.classInfo.contextPath();
                String className = this.classInfo.className();
                String action = S.newSizedBuffer((int)(className.length() + this.methodName.length() + 1)).append(className).append(".").append(this.methodName).toString();
                this.registerOnContext(contextPath, action);
                contexts.add(contextPath);
            }
            if (!((Boolean)this.isVirtual.get()).booleanValue()) {
                return;
            }
            App app = Act.app();
            final AppClassLoader classLoader = app.classLoader();
            ClassNode node = classLoader.classInfoRepository().node(this.classInfo.className());
            node.visitSubTree((Osgl.Function<ClassNode, ?>)new Osgl.Visitor<ClassNode>(){

                public void visit(ClassNode classNode) throws Osgl.Break {
                    String subClassContextPath;
                    String className = classNode.name();
                    ControllerClassMetaInfo subClassInfo = classLoader.controllerClassMetaInfo(className);
                    if (null != subClassInfo && null != (subClassContextPath = subClassInfo.contextPath())) {
                        if (!contexts.contains(subClassContextPath)) {
                            RouteRegister.this.registerOnContext(subClassContextPath, S.builder((String)subClassInfo.className()).append(".").append(RouteRegister.this.methodName).toString());
                            contexts.add(subClassContextPath);
                        } else {
                            throw E.invalidConfiguration((String)"the context path of Sub controller %s has already been registered: %s", (Object[])new Object[]{className, subClassContextPath});
                        }
                    }
                }
            }, true, true);
        }

        private void registerOnContext(String ctxPath, String action) {
            S.Buffer sb = S.newBuffer();
            for (Router r : this.routers) {
                for (String actionPath : this.paths) {
                    if (!(actionPath.startsWith("/") || S.blank((String)ctxPath) || "/".equals(ctxPath))) {
                        if (ctxPath.endsWith("/")) {
                            ctxPath = ctxPath.substring(0, ctxPath.length() - 1);
                        }
                        sb.setLength(0);
                        sb.append(ctxPath);
                        if (!actionPath.startsWith("/")) {
                            sb.append("/");
                        }
                        sb.append(actionPath);
                        actionPath = sb.toString();
                    }
                    for (H.Method m : this.httpMethods) {
                        r.addMapping(m, (CharSequence)actionPath, action, RouteSource.ACTION_ANNOTATION);
                    }
                }
            }
        }
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private String[] ports = new String[0];

        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            logger.trace("Scanning %s", new Object[]{name});
            ControllerByteCodeScanner.this.classInfo.className(name);
            String className = name.replace('/', '.');
            if (ControllerByteCodeScanner.this.router.possibleController(className)) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
            }
            Type superType = Type.getObjectType((String)superName);
            ControllerByteCodeScanner.this.classInfo.superType(superType);
            if (_ByteCodeVisitor.isAbstract(access)) {
                ControllerByteCodeScanner.this.classInfo.setAbstract();
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor av = super.visitAnnotation(desc, visible);
            if (Type.getType(Controller.class).getDescriptor().equals(desc)) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new ControllerAnnotationVisitor(av);
            }
            if (Type.getType(With.class).getDescriptor().equals(desc)) {
                ControllerByteCodeScanner.this.classInfo.isController(true);
                return new WithAnnotationVisitor(av);
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (!ControllerByteCodeScanner.this.classInfo.possibleController() || !this.isEligibleMethod(access, name)) {
                return mv;
            }
            String className = ControllerByteCodeScanner.this.classInfo.className();
            boolean isRoutedMethod = ControllerByteCodeScanner.this.router.isActionMethod(className, name);
            return new ActionMethodVisitor(isRoutedMethod, mv, access, name, desc, signature, exceptions);
        }

        private boolean isEligibleMethod(int access, String name) {
            return !_ByteCodeVisitor.isAbstract(access) && !_ByteCodeVisitor.isConstructor(name);
        }

        static /* synthetic */ String[] access$402(_ByteCodeVisitor x0, String[] x1) {
            x0.ports = x1;
            return x1;
        }

        private class ActionMethodVisitor
        extends MethodVisitor
        implements Opcodes {
            private String methodName;
            private int access;
            private String desc;
            private String signature;
            private boolean isStatic;
            private String[] exceptions;
            private boolean requireScan;
            private boolean isRoutedMethod;
            private HandlerMethodMetaInfo methodInfo;
            private PropertySpec.MetaInfo propSpec;
            private Map<Integer, List<ParamAnnoInfoTrait>> paramAnnoInfoList;
            private Map<Integer, List<GeneralAnnoInfo>> genericParamAnnoInfoList;
            private BitSet contextInfo;
            private Osgl.Var<Boolean> isVirtual;

            ActionMethodVisitor(boolean isRoutedMethod, MethodVisitor mv, int access, String methodName, String desc, String signature, String[] exceptions) {
                super(327680, mv);
                this.paramAnnoInfoList = C.newMap((Object[])new Object[0]);
                this.genericParamAnnoInfoList = C.newMap((Object[])new Object[0]);
                this.contextInfo = new BitSet();
                this.isVirtual = $.var((Object)false);
                this.isRoutedMethod = isRoutedMethod;
                this.access = access;
                this.methodName = methodName;
                this.desc = desc;
                this.signature = signature;
                this.exceptions = exceptions;
                this.isStatic = ByteCodeVisitor.isStatic(access);
                if (ControllerByteCodeScanner.this.classInfo.isAbstract()) {
                    this.isVirtual.set((Object)true);
                }
                if (isRoutedMethod) {
                    this.markRequireScan();
                }
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                Type type = Type.getType((String)desc);
                String className = type.getClassName();
                Class c = $.classForName((String)className);
                if (Virtual.class.getName().equals(c.getName())) {
                    this.isVirtual.set((Object)true);
                    return av;
                }
                if (ControllerClassMetaInfo.isActionAnnotation(c)) {
                    this.markRequireScan();
                    ActionMethodMetaInfo tmp = new ActionMethodMetaInfo(ControllerByteCodeScanner.this.classInfo);
                    this.methodInfo = tmp;
                    ControllerByteCodeScanner.this.classInfo.addAction(tmp);
                    if (null != this.propSpec) {
                        this.methodInfo.propertySpec(this.propSpec);
                    }
                    return new ActionAnnotationVisitor(av, ControllerClassMetaInfo.lookupHttpMethod(c), ControllerClassMetaInfo.isActionUtilAnnotation(c), this.isStatic);
                }
                if (ControllerClassMetaInfo.isInterceptorAnnotation(c)) {
                    this.markRequireScan();
                    InterceptorAnnotationVisitor visitor = new InterceptorAnnotationVisitor(av, c);
                    this.methodInfo = visitor.info;
                    if (null != this.propSpec) {
                        this.methodInfo.propertySpec(this.propSpec);
                    }
                    return visitor;
                }
                if ($.eq((Object)AsmTypes.PROPERTY_SPEC.asmType(), (Object)type)) {
                    this.propSpec = new PropertySpec.MetaInfo();
                    if (null != this.methodInfo) {
                        this.methodInfo.propertySpec(this.propSpec);
                    }
                    return new AnnotationVisitor(327680, av){

                        public AnnotationVisitor visitArray(String name) {
                            AnnotationVisitor av0 = super.visitArray(name);
                            if (S.eq((String)"value", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        ActionMethodVisitor.this.propSpec.onValue(S.string((Object)value));
                                    }
                                };
                            }
                            if (S.eq((String)"cli", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        ActionMethodVisitor.this.propSpec.onCli(S.string((Object)value));
                                    }
                                };
                            }
                            if (S.eq((String)"http", (String)name)) {
                                return new AnnotationVisitor(327680, av0){

                                    public void visit(String name, Object value) {
                                        super.visit(name, value);
                                        ActionMethodVisitor.this.propSpec.onHttp(S.string((Object)value));
                                    }
                                };
                            }
                            return av0;
                        }
                    };
                }
                if ($.eq((Object)AsmTypes.DISABLE_JSON_CIRCULAR_REF_DETECT.asmType(), (Object)type)) {
                    this.methodInfo.disableJsonCircularRefDetect(true);
                }
                return av;
            }

            public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                AnnotationVisitor av = super.visitParameterAnnotation(parameter, desc, visible);
                Type type = Type.getType((String)desc);
                if ($.eq((Object)type, (Object)AsmTypes.PARAM.asmType())) {
                    return new ParamAnnotationVisitor(av, parameter);
                }
                if ($.eq((Object)type, (Object)AsmTypes.BIND.asmType())) {
                    return new BindAnnotationVisitor(av, parameter);
                }
                if ($.eq((Object)type, (Object)AsmTypes.CONTEXT.asmType())) {
                    this.contextInfo.set(parameter);
                    return av;
                }
                GeneralAnnoInfo info = new GeneralAnnoInfo(type);
                C.List list = this.genericParamAnnoInfoList.get(parameter);
                if (null == list) {
                    list = C.newList();
                    this.genericParamAnnoInfoList.put(parameter, (List<GeneralAnnoInfo>)list);
                }
                list.add(info);
                return new GeneralAnnoInfo.Visitor(av, info);
            }

            public void visitEnd() {
                if (!this.requireScan()) {
                    super.visitEnd();
                    return;
                }
                ControllerByteCodeScanner.this.classInfo.isController(true);
                if (null == this.methodInfo) {
                    ActionMethodMetaInfo action = new ActionMethodMetaInfo(ControllerByteCodeScanner.this.classInfo);
                    this.methodInfo = action;
                    ControllerByteCodeScanner.this.classInfo.addAction(action);
                }
                final HandlerMethodMetaInfo info = this.methodInfo;
                info.name(this.methodName);
                boolean isStatic = AsmTypes.isStatic(this.access);
                if (isStatic) {
                    info.invokeStaticMethod();
                } else {
                    info.invokeInstanceMethod();
                }
                info.returnType(Type.getReturnType((String)this.desc));
                Type[] argTypes = Type.getArgumentTypes((String)this.desc);
                boolean ctxByParam = false;
                for (int i = 0; i < argTypes.length; ++i) {
                    List<GeneralAnnoInfo> list;
                    List<ParamAnnoInfoTrait> paraAnnoList;
                    Type type = argTypes[i];
                    if (AsmTypes.ACTION_CONTEXT.asmType().equals((Object)type)) {
                        ctxByParam = true;
                        info.appContextViaParam(i);
                    }
                    HandlerParamMetaInfo param = new HandlerParamMetaInfo().type(type);
                    if (this.contextInfo.get(i)) {
                        param.setContext();
                    }
                    if (null != (paraAnnoList = this.paramAnnoInfoList.get(i))) {
                        for (ParamAnnoInfoTrait trait : paraAnnoList) {
                            trait.attachTo(param);
                        }
                    }
                    if (null != (list = this.genericParamAnnoInfoList.get(i))) {
                        param.addGeneralAnnotations(list);
                    }
                    info.addParam(param);
                }
                if (!ctxByParam) {
                    if (ControllerByteCodeScanner.this.classInfo.hasCtxField() && !isStatic) {
                        info.appContextViaField(ControllerByteCodeScanner.this.classInfo.ctxField());
                    } else {
                        info.appContextViaLocalStorage();
                    }
                }
                if (null != this.signature) {
                    SignatureReader sr = new SignatureReader(this.signature);
                    final Osgl.Var id = new Osgl.Var((Object)-1);
                    sr.accept(new SignatureVisitor(327680){
                        boolean startParsing;

                        public SignatureVisitor visitParameterType() {
                            id.set((Object)((Integer)id.get() + 1));
                            return this;
                        }

                        public SignatureVisitor visitTypeArgument(char wildcard) {
                            if (wildcard == '=') {
                                this.startParsing = true;
                            }
                            return this;
                        }

                        public void visitClassType(String name) {
                            if (this.startParsing) {
                                Type type = Type.getObjectType((String)name);
                                int n = (Integer)id.get();
                                if (n < 0) {
                                    info.returnComponentType(type);
                                } else {
                                    info.param(n).componentType(type);
                                }
                            }
                            this.startParsing = false;
                        }
                    });
                }
                super.visitEnd();
            }

            private void markRequireScan() {
                this.requireScan = true;
            }

            private boolean requireScan() {
                return this.requireScan;
            }

            private class BindAnnotationVisitor
            extends ParamAnnotationVisitorBase<BindAnnoInfo> {
                public BindAnnotationVisitor(AnnotationVisitor av, int index) {
                    super(av, index);
                }

                @Override
                protected BindAnnoInfo createAnnotationInfo(int index) {
                    return new BindAnnoInfo(index);
                }

                public void visit(String name, Object value) {
                    if ("model".endsWith(name)) {
                        ((BindAnnoInfo)this.info).model((String)value);
                    }
                }

                public AnnotationVisitor visitArray(String name) {
                    AnnotationVisitor av = super.visitArray(name);
                    if ("value".equals(name)) {
                        return new AnnotationVisitor(327680, av){

                            public void visit(String name, Object value) {
                                Type type = (Type)value;
                                Class c = $.classForName((String)type.getClassName(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                                ((BindAnnoInfo)BindAnnotationVisitor.this.info).binder(c);
                            }
                        };
                    }
                    return av;
                }
            }

            private class ParamAnnotationVisitor
            extends ParamAnnotationVisitorBase<ParamAnnoInfo> {
                public ParamAnnotationVisitor(AnnotationVisitor av, int index) {
                    super(av, index);
                }

                @Override
                protected ParamAnnoInfo createAnnotationInfo(int index) {
                    return new ParamAnnoInfo(index);
                }

                public void visit(String name, Object value) {
                    if (S.eq((String)"value", (String)name)) {
                        ((ParamAnnoInfo)this.info).bindName((String)value);
                    } else if (S.eq((String)"defVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(String.class, value);
                    } else if (S.eq((String)"defIntVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Integer.class, value);
                    } else if (S.eq((String)"defBooleanVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Boolean.class, value);
                    } else if (S.eq((String)"defLongVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Long.class, value);
                    } else if (S.eq((String)"defDoubleVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Double.class, value);
                    } else if (S.eq((String)"defFloatVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Float.class, value);
                    } else if (S.eq((String)"defCharVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Character.class, value);
                    } else if (S.eq((String)"defByteVal", (String)name)) {
                        ((ParamAnnoInfo)this.info).defVal(Byte.class, name);
                    }
                    super.visit(name, value);
                }

                private <T> T c(Object v) {
                    return (T)$.cast((Object)v);
                }
            }

            private abstract class ParamAnnotationVisitorBase<T extends ParamAnnoInfoTrait>
            extends AnnotationVisitor
            implements Opcodes {
                protected int index;
                protected T info;

                public ParamAnnotationVisitorBase(AnnotationVisitor av, int index) {
                    super(327680, av);
                    this.index = index;
                    this.info = this.createAnnotationInfo(index);
                }

                public void visitEnd() {
                    List traits = (List)ActionMethodVisitor.this.paramAnnoInfoList.get(this.index);
                    if (null == traits) {
                        traits = C.newList();
                        ActionMethodVisitor.this.paramAnnoInfoList.put(this.index, traits);
                    } else {
                        for (ParamAnnoInfoTrait trait : traits) {
                            if (this.info.compatibleWith(trait)) continue;
                            throw E.unexpected((String)this.info.compatibilityErrorMessage(trait), (Object[])new Object[0]);
                        }
                    }
                    traits.add(this.info);
                    super.visitEnd();
                }

                protected abstract T createAnnotationInfo(int var1);
            }

            private class ActionAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                List<H.Method> httpMethods;
                List<String> paths;
                boolean isUtil;
                boolean isStatic;

                public ActionAnnotationVisitor(AnnotationVisitor av, H.Method method, boolean isUtil, boolean staticMethod) {
                    super(327680, av);
                    this.httpMethods = C.newList();
                    this.paths = C.newList();
                    if (null != method) {
                        this.httpMethods.add(method);
                    }
                    this.isUtil = isUtil;
                    this.isStatic = staticMethod;
                }

                public AnnotationVisitor visitArray(String name) {
                    AnnotationVisitor av = super.visitArray(name);
                    if ("value".equals(name)) {
                        return new AnnotationVisitor(327680, av){

                            public void visit(String name, Object value) {
                                super.visit(name, value);
                                ActionAnnotationVisitor.this.paths.add((String)value);
                            }
                        };
                    }
                    if ("methods".equals(name)) {
                        return new AnnotationVisitor(327680, av){

                            public void visitEnum(String name, String desc, String value) {
                                super.visitEnum(name, desc, value);
                                String enumClass = Type.getType((String)desc).getClassName();
                                if (H.Method.class.getName().equals(enumClass)) {
                                    H.Method method = H.Method.valueOf((String)value);
                                    ActionAnnotationVisitor.this.httpMethods.add(method);
                                }
                            }
                        };
                    }
                    return av;
                }

                public void visitEnd() {
                    super.visitEnd();
                    if (this.isUtil) {
                        return;
                    }
                    if (this.httpMethods.isEmpty()) {
                        this.httpMethods.addAll(H.Method.actionMethods());
                    }
                    C.List routers = C.newList();
                    if (null == _ByteCodeVisitor.this.ports || _ByteCodeVisitor.this.ports.length == 0) {
                        routers.add(ControllerByteCodeScanner.this.app().router());
                    } else {
                        App app = ControllerByteCodeScanner.this.app();
                        for (String portName : _ByteCodeVisitor.this.ports) {
                            Router r = app.router(portName);
                            if (null == r) {
                                if (S.eq((String)"__admin__", (String)portName)) {
                                    return;
                                }
                                throw E.invalidConfiguration((String)"Cannot find configuration for named port[%s]", (Object[])new Object[]{portName});
                            }
                            routers.add(r);
                        }
                    }
                    if (this.paths.isEmpty()) {
                        this.paths.add("");
                    }
                    ControllerByteCodeScanner.this.app().jobManager().on(AppEventId.APP_CODE_SCANNED, (Runnable)new RouteRegister(this.httpMethods, this.paths, ActionMethodVisitor.this.methodName, (List<Router>)routers, ControllerByteCodeScanner.this.classInfo, ControllerByteCodeScanner.this.classInfo.isAbstract() && !this.isStatic, (Osgl.Var<Boolean>)ActionMethodVisitor.this.isVirtual));
                }
            }

            private class InterceptorAnnotationVisitor
            extends AnnotationVisitor
            implements Opcodes {
                private InterceptorMethodMetaInfo info;
                private InterceptorType interceptorType;

                public InterceptorAnnotationVisitor(AnnotationVisitor av, Class<? extends Annotation> annoCls) {
                    super(327680, av);
                    this.interceptorType = InterceptorType.of(annoCls);
                    this.info = this.interceptorType.createMetaInfo(ControllerByteCodeScanner.this.classInfo);
                    ControllerByteCodeScanner.this.classInfo.addInterceptor(this.info, annoCls);
                }

                public void visit(String name, Object value) {
                    if ("priority".equals(name)) {
                        this.info.priority((Integer)value);
                    }
                    super.visit(name, value);
                }

                public AnnotationVisitor visitArray(String name) {
                    if ("only".equals(name)) {
                        return new OnlyValueVisitor(this.av);
                    }
                    if ("except".equals(name)) {
                        return new ExceptValueVisitor(this.av);
                    }
                    if ("value".equals(name) && this.info instanceof CatchMethodMetaInfo) {
                        return new CatchValueVisitor(this.av);
                    }
                    return super.visitArray(name);
                }

                private class CatchValueVisitor
                extends AnnotationVisitor {
                    List<String> exceptions;

                    public CatchValueVisitor(AnnotationVisitor av) {
                        super(327680, av);
                        this.exceptions = C.newList();
                    }

                    public void visit(String name, Object value) {
                        this.exceptions.add(((Type)value).getClassName());
                    }

                    public void visitEnd() {
                        CatchMethodMetaInfo ci = (CatchMethodMetaInfo)InterceptorAnnotationVisitor.this.info;
                        ci.exceptionClasses(this.exceptions);
                        super.visitEnd();
                    }
                }

                private class ExceptValueVisitor
                extends StringArrayVisitor {
                    public ExceptValueVisitor(AnnotationVisitor av) {
                        super(av);
                    }

                    public void visitEnd() {
                        Object[] sa = new String[this.strings.size()];
                        sa = (String[])this.strings.toArray(sa);
                        InterceptorAnnotationVisitor.this.info.addExcept((String[])sa);
                        super.visitEnd();
                    }
                }

                private class OnlyValueVisitor
                extends StringArrayVisitor {
                    public OnlyValueVisitor(AnnotationVisitor av) {
                        super(av);
                    }

                    public void visitEnd() {
                        Object[] sa = new String[this.strings.size()];
                        sa = (String[])this.strings.toArray(sa);
                        InterceptorAnnotationVisitor.this.info.addOnly((String[])sa);
                        super.visitEnd();
                    }
                }
            }
        }

        private class ControllerAnnotationVisitor
        extends AnnotationVisitor {
            ControllerAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public void visit(String name, Object value) {
                if ("value".equals(name)) {
                    ControllerByteCodeScanner.this.classInfo.contextPath(value.toString());
                }
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("port".equals(name)) {
                    return new StringArrayVisitor(av){

                        public void visitEnd() {
                            _ByteCodeVisitor.access$402(_ByteCodeVisitor.this, new String[this.strings.size()]);
                            _ByteCodeVisitor.access$402(_ByteCodeVisitor.this, (String[])this.strings.toArray((Object[])_ByteCodeVisitor.this.ports));
                            super.visitEnd();
                        }
                    };
                }
                return av;
            }
        }

        private class WithAnnotationVisitor
        extends AnnotationVisitor {
            public WithAnnotationVisitor(AnnotationVisitor av) {
                super(327680, av);
            }

            public AnnotationVisitor visitArray(String name) {
                AnnotationVisitor av = super.visitArray(name);
                if ("value".equals(name)) {
                    return new StringArrayVisitor(av){

                        public void visitEnd() {
                            Object[] sa = new String[this.strings.size()];
                            sa = (String[])this.strings.toArray(sa);
                            ControllerByteCodeScanner.this.classInfo.addWith((String[])sa);
                            super.visitEnd();
                        }
                    };
                }
                return av;
            }
        }

        private class StringArrayVisitor
        extends AnnotationVisitor {
            protected ListBuilder<String> strings;

            public StringArrayVisitor(AnnotationVisitor av) {
                super(327680, av);
                this.strings = ListBuilder.create();
            }

            public void visit(String name, Object value) {
                this.strings.add((Object)value.toString());
                super.visit(name, value);
            }
        }
    }
}

