/*
 * Decompiled with CFR 0.152.
 */
package act.controller.bytecode;

import act.app.App;
import act.asm.ClassVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.controller.bytecode.HandlerEnhancer;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.ControllerClassMetaInfoHolder;
import act.controller.meta.HandlerMethodMetaInfo;
import act.util.AppByteCodeEnhancer;
import org.osgl.Osgl;

public class ControllerEnhancer
extends AppByteCodeEnhancer<ControllerEnhancer> {
    private ControllerClassMetaInfoHolder classInfoHolder;
    private String className;

    public ControllerEnhancer() {
        super((Osgl.Predicate<String>)null);
    }

    public ControllerEnhancer(ClassVisitor cv, ControllerClassMetaInfoHolder infoHolder) {
        super((Osgl.Predicate<String>)_F.isController(infoHolder), cv);
        this.classInfoHolder = infoHolder;
    }

    @Override
    public AppByteCodeEnhancer app(App app) {
        this.classInfoHolder = app.classLoader();
        return super.app(app);
    }

    @Override
    protected Class<ControllerEnhancer> subClass() {
        return ControllerEnhancer.class;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = Type.getObjectType((String)name).getClassName();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        HandlerMethodMetaInfo info = this.methodInfo(name);
        if (null == info) {
            return mv;
        }
        logger.debug(">>>About to enhance handler: %s", new Object[]{name});
        return new HandlerEnhancer(mv, info, access, name, desc, signature, exceptions);
    }

    private HandlerMethodMetaInfo methodInfo(String name) {
        if (!ControllerEnhancer.isConstructor(name)) {
            ControllerClassMetaInfo ccInfo = this.classInfoHolder.controllerClassMetaInfo(this.className);
            if (null == ccInfo) {
                return null;
            }
            return ccInfo.handler(name);
        }
        return null;
    }

    private static enum _F {


        private static final Osgl.Predicate<String> isController(final ControllerClassMetaInfoHolder infoSrc) {
            return new Osgl.Predicate<String>(){

                public boolean test(String s) {
                    return infoSrc.controllerClassMetaInfo(s) != null;
                }
            };
        }
    }
}

