/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import org.osgl.$;
import org.osgl.util.S;

public class ActContextInjection<T> {
    private InjectType type;
    protected T v;

    private ActContextInjection(InjectType type, T v) {
        this.type = type;
        this.v = v;
    }

    public InjectType injectVia() {
        return this.type;
    }

    public int hashCode() {
        return $.hc((Object)((Object)this.type), this.v);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ActContextInjection) {
            ActContextInjection that = (ActContextInjection)obj;
            return that.type == this.type && $.eq(that.v, this.v);
        }
        return false;
    }

    public String toString() {
        return S.concat((String)"inject[", (String)this.type.name().toLowerCase(), (String)", ", (String)S.string(this.v), (String)"]");
    }

    public static class LocalAppContextInjection
    extends ActContextInjection<Void> {
        public LocalAppContextInjection() {
            super(InjectType.LOCAL, null);
        }

        @Override
        public String toString() {
            return "inject[local]";
        }
    }

    public static class ParamAppContextInjection
    extends ActContextInjection<Integer> {
        private int lvLookupIdx;

        public ParamAppContextInjection(Integer paramIndex) {
            super(InjectType.PARAM, paramIndex);
        }

        public int paramIndex() {
            return (Integer)this.v;
        }

        public ParamAppContextInjection lvLookupIdx(int index) {
            this.lvLookupIdx = index;
            return this;
        }

        public int lvLookupIdx() {
            return this.lvLookupIdx;
        }
    }

    public static class FieldActContextInjection
    extends ActContextInjection<String> {
        public FieldActContextInjection(String fieldName) {
            super(InjectType.FIELD, fieldName);
        }

        public String fieldName() {
            return (String)this.v;
        }
    }

    public static enum InjectType {
        FIELD,
        PARAM,
        LOCAL;


        public boolean isLocal() {
            return this == LOCAL;
        }

        public boolean isField() {
            return this == FIELD;
        }

        public boolean isParam() {
            return this == PARAM;
        }
    }
}

