/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import java.util.List;
import org.osgl.util.C;
import org.osgl.util.S;

public class CatchMethodMetaInfo
extends InterceptorMethodMetaInfo {
    private static final List<String> CATCH_THROWABLE = C.list((Object)Throwable.class.getName());
    private List<String> targetExceptionClassNames = CATCH_THROWABLE;

    protected CatchMethodMetaInfo(CatchMethodMetaInfo copy, ControllerClassMetaInfo clsInfo) {
        super(copy, clsInfo);
        this.targetExceptionClassNames = copy.targetExceptionClassNames;
    }

    public CatchMethodMetaInfo(ControllerClassMetaInfo clsInfo) {
        super(clsInfo);
    }

    @Override
    protected void releaseResources() {
        this.targetExceptionClassNames = null;
        super.releaseResources();
    }

    public CatchMethodMetaInfo exceptionClasses(List<String> list) {
        this.targetExceptionClassNames = C.list(list);
        return this;
    }

    public List<String> exceptionClasses() {
        return this.targetExceptionClassNames;
    }

    @Override
    public String toString() {
        return this.toStrBuffer(S.newBuffer()).toString();
    }

    @Override
    protected S.Buffer toStrBuffer(S.Buffer sb) {
        StringBuilder prependix = S.builder((String)"catch").append(this.targetExceptionClassNames).append(" ");
        return super.toStrBuffer(sb).prepend(prependix);
    }

    @Override
    protected InterceptorMethodMetaInfo doExtend(ControllerClassMetaInfo clsInfo) {
        return new CatchMethodMetaInfo(this, clsInfo);
    }
}

