/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppClassLoader;
import act.asm.Type;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfoManager;
import act.controller.meta.GroupInterceptorMetaInfo;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.DestroyableBase;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.http.H;
import org.osgl.mvc.annotation.Action;
import org.osgl.mvc.annotation.ActionUtil;
import org.osgl.mvc.annotation.After;
import org.osgl.mvc.annotation.Before;
import org.osgl.mvc.annotation.Catch;
import org.osgl.mvc.annotation.DeleteAction;
import org.osgl.mvc.annotation.Finally;
import org.osgl.mvc.annotation.GetAction;
import org.osgl.mvc.annotation.PatchAction;
import org.osgl.mvc.annotation.PostAction;
import org.osgl.mvc.annotation.PutAction;
import org.osgl.util.C;
import org.osgl.util.S;

@ApplicationScoped
public final class ControllerClassMetaInfo
extends DestroyableBase {
    private Type type;
    private Type superType;
    private boolean isAbstract = false;
    private String ctxField = null;
    private boolean ctxFieldIsPrivate = true;
    private C.Set<String> withList = C.newSet();
    private C.List<ActionMethodMetaInfo> actions = C.newList();
    private C.Map<String, ActionMethodMetaInfo> actionLookup = null;
    private C.Map<String, HandlerMethodMetaInfo> handlerLookup = null;
    private GroupInterceptorMetaInfo interceptors = new GroupInterceptorMetaInfo();
    private ControllerClassMetaInfo parent;
    private boolean isController;
    private boolean possibleController;
    private String contextPath;
    private static final C.Set<Class<? extends Annotation>> INTERCEPTOR_ANNOTATION_TYPES = C.set(Before.class, (Object[])new Class[]{After.class, Catch.class, Finally.class});
    public static final C.Set<H.Method> ACTION_METHODS = C.set((Object)H.Method.GET, (Object[])new H.Method[]{H.Method.POST, H.Method.PUT, H.Method.DELETE});
    private static final Map<Class<? extends Action>, H.Method> METHOD_LOOKUP = C.newMap((Object[])new Object[]{GetAction.class, H.Method.GET, PostAction.class, H.Method.POST, PutAction.class, H.Method.PUT, DeleteAction.class, H.Method.DELETE, PatchAction.class, H.Method.PATCH});

    public ControllerClassMetaInfo className(String name) {
        this.type = Type.getObjectType((String)name);
        return this;
    }

    @Override
    protected void releaseResources() {
        this.withList.clear();
        Destroyable.Util.destroyAll(this.actions, ApplicationScoped.class);
        this.actions.clear();
        if (null != this.actionLookup) {
            Destroyable.Util.destroyAll(this.actionLookup.values(), ApplicationScoped.class);
            this.actionLookup.clear();
        }
        if (null != this.handlerLookup) {
            Destroyable.Util.destroyAll(this.handlerLookup.values(), ApplicationScoped.class);
            this.handlerLookup.clear();
        }
        this.interceptors.destroy();
        if (null != this.parent) {
            this.parent.destroy();
        }
        super.releaseResources();
    }

    public String className() {
        return this.type.getClassName();
    }

    public String internalName() {
        return this.type.getInternalName();
    }

    public Type type() {
        return this.type;
    }

    public ControllerClassMetaInfo superType(Type type) {
        this.superType = type;
        return this;
    }

    public Type superType() {
        return this.superType;
    }

    public List<String> withList() {
        return C.list(this.withList);
    }

    public ControllerClassMetaInfo setAbstract() {
        this.isAbstract = true;
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isController() {
        return this.isController;
    }

    public ControllerClassMetaInfo isController(boolean b) {
        this.isController = b;
        return this;
    }

    public boolean possibleController() {
        return this.possibleController;
    }

    public ControllerClassMetaInfo possibleController(boolean b) {
        this.possibleController = b;
        return this;
    }

    boolean isMyAncestor(ControllerClassMetaInfo clsInfo) {
        ControllerClassMetaInfo parentInfo = this.parent(true);
        if (null == parentInfo) {
            return false;
        }
        if (parentInfo.equals(clsInfo)) {
            return true;
        }
        return parentInfo.isMyAncestor(clsInfo);
    }

    public ControllerClassMetaInfo parent(ControllerClassMetaInfo parentInfo) {
        this.parent = parentInfo;
        return this;
    }

    public ControllerClassMetaInfo parent() {
        return this.parent;
    }

    public ControllerClassMetaInfo parent(boolean checkClassInfoRepo) {
        if (null != this.parent) {
            return this.parent;
        }
        if (!checkClassInfoRepo) {
            return null;
        }
        AppClassLoader classLoader = Act.app().classLoader();
        ClassInfoRepository repo = classLoader.classInfoRepository();
        ClassNode parentNode = repo.node(this.superType.getClassName());
        while (null != parentNode) {
            if (null != (parentNode = parentNode.parent())) {
                ControllerClassMetaInfo parentInfo = classLoader.controllerClassMetaInfo(parentNode.name());
                if (null == parentInfo) continue;
                return parentInfo;
            }
            return null;
        }
        return null;
    }

    public ControllerClassMetaInfo ctxField(String fieldName, boolean isPrivate) {
        this.ctxField = fieldName;
        this.ctxFieldIsPrivate = isPrivate;
        return this;
    }

    public String nonPrivateCtxField() {
        if (null != this.ctxField) {
            return this.ctxFieldIsPrivate ? null : this.ctxField;
        }
        return null == this.parent ? null : this.parent.nonPrivateCtxField();
    }

    public String ctxField() {
        if (null != this.ctxField) {
            return this.ctxField;
        }
        if (null != this.parent) {
            return this.parent.nonPrivateCtxField();
        }
        return null;
    }

    public boolean hasCtxField() {
        return null != this.ctxField;
    }

    public boolean ctxFieldIsPrivate() {
        return this.ctxFieldIsPrivate;
    }

    public ControllerClassMetaInfo addWith(String ... classes) {
        int len = classes.length;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                this._addWith(classes[i]);
            }
        }
        return this;
    }

    public ControllerClassMetaInfo addBefore(InterceptorMethodMetaInfo before) {
        this.interceptors.addBefore(before);
        return this;
    }

    public ControllerClassMetaInfo addAfter(InterceptorMethodMetaInfo after) {
        this.interceptors.addAfter(after);
        return this;
    }

    public ControllerClassMetaInfo addCatch(CatchMethodMetaInfo cat) {
        this.interceptors.addCatch(cat);
        return this;
    }

    public ControllerClassMetaInfo addFinally(InterceptorMethodMetaInfo after) {
        this.interceptors.addFinally(after);
        return this;
    }

    public ControllerClassMetaInfo addInterceptor(InterceptorMethodMetaInfo info, Class<? extends Annotation> type) {
        this.interceptors.add(info, type);
        return this;
    }

    public ControllerClassMetaInfo addAction(ActionMethodMetaInfo info) {
        this.actions.add((Object)info);
        return this;
    }

    public ActionMethodMetaInfo action(String name) {
        if (null == this.actionLookup) {
            for (ActionMethodMetaInfo act : this.actions) {
                if (!S.eq((String)name, (String)act.name())) continue;
                return act;
            }
            return null;
        }
        return (ActionMethodMetaInfo)this.actionLookup.get((Object)name);
    }

    public HandlerMethodMetaInfo handler(String name) {
        if (null == this.handlerLookup) {
            ActionMethodMetaInfo info = this.action(name);
            if (null != info) {
                return info;
            }
            return this.interceptors.find(name, this.className());
        }
        return (HandlerMethodMetaInfo)this.handlerLookup.get((Object)name);
    }

    <T extends InterceptorMethodMetaInfo> List<T> convertDerived(List<T> interceptors) {
        C.List list = C.newSizedList((int)interceptors.size());
        for (InterceptorMethodMetaInfo derived : interceptors) {
            list.add((Object)derived.extended(this));
        }
        return list;
    }

    public List<InterceptorMethodMetaInfo> beforeInterceptors() {
        return this.interceptors.beforeList();
    }

    public List<InterceptorMethodMetaInfo> afterInterceptors() {
        return this.interceptors.afterList();
    }

    public List<CatchMethodMetaInfo> exceptionInterceptors() {
        return this.interceptors.catchList();
    }

    public List<InterceptorMethodMetaInfo> finallyInterceptors() {
        return this.interceptors.finallyList();
    }

    public ControllerClassMetaInfo merge(ControllerClassMetaInfoManager infoBase, App app) {
        this.mergeFromWithList(infoBase, app);
        this.mergeIntoActionList();
        this.buildActionLookup();
        this.buildHandlerLookup(app);
        return this;
    }

    public String contextPath() {
        if (null != this.parent) {
            if (S.notBlank((String)this.contextPath) && this.contextPath.length() > 1 && this.contextPath.startsWith("/")) {
                return this.contextPath;
            }
            String parentContextPath = this.parent.contextPath();
            if (null == this.contextPath) {
                return parentContextPath;
            }
            if (null == parentContextPath) {
                return this.contextPath;
            }
            S.Buffer sb = S.newBuffer((String)parentContextPath);
            if (parentContextPath.endsWith("/")) {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (!this.contextPath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(this.contextPath);
            return sb.toString();
        }
        return this.contextPath;
    }

    public ControllerClassMetaInfo contextPath(String path) {
        this.contextPath = S.blank((String)path) ? "/" : path;
        return this;
    }

    private void _addWith(String clsName) {
        this.withList.add((Object)Type.getType((String)clsName).getClassName());
    }

    private void getAllWithList(Set<String> withList, ControllerClassMetaInfoManager infoBase) {
        withList.addAll((Collection<String>)this.withList);
        if (null != this.superType) {
            String superClass = this.superType.getClassName();
            App app = App.instance();
            ClassInfoRepository repo = app.classLoader().classInfoRepository();
            ControllerClassMetaInfo info = infoBase.controllerMetaInfo(superClass);
            String curSuperClass = superClass;
            while (null == info && !"java.lang.Object".equals(curSuperClass)) {
                ClassNode node = repo.node(curSuperClass);
                if (null != node) {
                    node = node.parent();
                }
                if (null == node) break;
                curSuperClass = node.name();
                info = infoBase.controllerMetaInfo(curSuperClass);
            }
            if (null != info) {
                withList.add(superClass);
            }
        }
    }

    private void mergeFromWithList(ControllerClassMetaInfoManager infoBase, App app) {
        C.Set withClasses = C.newSet();
        this.getAllWithList((Set<String>)withClasses, infoBase);
        ControllerClassMetaInfo me = this;
        ClassInfoRepository repo = app.classLoader().classInfoRepository();
        Iterator iterator = withClasses.iterator();
        while (iterator.hasNext()) {
            String withClass;
            String curWithClass = withClass = (String)iterator.next();
            ControllerClassMetaInfo withClassInfo = infoBase.controllerMetaInfo(curWithClass);
            while (null == withClassInfo && !"java.lang.Object".equals(curWithClass)) {
                ClassNode node = repo.node(curWithClass);
                if (null != node) {
                    node = node.parent();
                }
                if (null == node) break;
                curWithClass = node.name();
                withClassInfo = infoBase.controllerMetaInfo(curWithClass);
            }
            if (null == withClassInfo) continue;
            withClassInfo.merge(infoBase, app);
            if (this.isMyAncestor(withClassInfo)) {
                this.interceptors.mergeFrom(withClassInfo.interceptors, me);
                continue;
            }
            this.interceptors.mergeFrom(withClassInfo.interceptors);
        }
    }

    private void mergeIntoActionList() {
        for (ActionMethodMetaInfo info : this.actions) {
            info.mergeFromClassInterceptors(this.interceptors);
        }
    }

    private void buildActionLookup() {
        C.Map lookup = C.newMap((Object[])new Object[0]);
        for (ActionMethodMetaInfo act : this.actions) {
            lookup.put((Object)act.name(), (Object)act);
        }
        this.actionLookup = lookup;
    }

    private void buildHandlerLookup(App app) {
        C.Map lookup = C.newMap((Object[])new Object[0]);
        lookup.putAll(this.actionLookup);
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : this.beforeInterceptors()) {
            lookup.put((Object)interceptorMethodMetaInfo.name(), (Object)interceptorMethodMetaInfo);
        }
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : this.afterInterceptors()) {
            lookup.put((Object)interceptorMethodMetaInfo.name(), (Object)interceptorMethodMetaInfo);
        }
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : this.exceptionInterceptors()) {
            lookup.put((Object)interceptorMethodMetaInfo.name(), (Object)interceptorMethodMetaInfo);
        }
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : this.finallyInterceptors()) {
            lookup.put((Object)interceptorMethodMetaInfo.name(), (Object)interceptorMethodMetaInfo);
        }
        this.handlerLookup = lookup;
    }

    public static boolean isActionAnnotation(Class<? extends Annotation> type) {
        return METHOD_LOOKUP.containsKey(type) || Action.class == type;
    }

    public static H.Method lookupHttpMethod(Class annotationClass) {
        return METHOD_LOOKUP.get(annotationClass);
    }

    public static boolean isActionUtilAnnotation(Class<? extends Annotation> type) {
        return ActionUtil.class == type;
    }

    public static boolean isInterceptorAnnotation(Class<? extends Annotation> type) {
        return INTERCEPTOR_ANNOTATION_TYPES.contains(type);
    }
}

