/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.asm.Label;
import act.asm.Type;
import act.controller.meta.ActContextInjection;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.LocalVariableMetaInfo;
import act.sys.meta.InvokeType;
import act.sys.meta.ReturnTypeInfo;
import act.util.DestroyableBase;
import act.util.Prioritised;
import act.util.PropertySpec;
import java.util.Map;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public abstract class HandlerMethodMetaInfo<T extends HandlerMethodMetaInfo>
extends DestroyableBase
implements Prioritised {
    private String name;
    private InvokeType invokeType;
    private ActContextInjection actContextInjection;
    private ControllerClassMetaInfo clsInfo;
    private C.List<HandlerParamMetaInfo> params = C.newList();
    private transient String fullName;
    private ReturnTypeInfo returnType;
    private PropertySpec.MetaInfo propertySpec;
    private boolean disableJsonCircularRefDetect = false;
    private Map<Label, Map<Integer, LocalVariableMetaInfo>> locals = C.newMap((Object[])new Object[0]);
    private int appCtxLVT_id = -1;
    private int ctxParamCnt = -1;

    protected HandlerMethodMetaInfo(HandlerMethodMetaInfo copy, ControllerClassMetaInfo clsInfo) {
        E.illegalArgumentIf((!clsInfo.isMyAncestor(copy.classInfo()) ? 1 : 0) != 0);
        this.clsInfo = (ControllerClassMetaInfo)$.notNull((Object)clsInfo);
        this.name = copy.name;
        this.invokeType = copy.invokeType;
        this.actContextInjection = copy.actContextInjection;
        this.params = copy.params;
        this.returnType = copy.returnType;
        this.propertySpec = copy.propertySpec;
        this.disableJsonCircularRefDetect = copy.disableJsonCircularRefDetect;
        this.locals = copy.locals;
        this.appCtxLVT_id = copy.appCtxLVT_id;
        this.ctxParamCnt = copy.ctxParamCnt;
    }

    public HandlerMethodMetaInfo(ControllerClassMetaInfo clsInfo) {
        this.clsInfo = clsInfo;
    }

    @Override
    protected void releaseResources() {
        this.clsInfo.destroy();
        this.params.clear();
        this.locals.clear();
        super.releaseResources();
    }

    public ControllerClassMetaInfo classInfo() {
        return this.clsInfo;
    }

    public T name(String name) {
        this.name = name;
        return this.me();
    }

    public String name() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fullName() {
        if (null == this.fullName) {
            HandlerMethodMetaInfo handlerMethodMetaInfo = this;
            synchronized (handlerMethodMetaInfo) {
                if (null == this.fullName) {
                    this.fullName = S.concat((String)this.classInfo().className(), (String)".", (String)this.name);
                }
            }
        }
        return this.fullName;
    }

    @Override
    public int priority() {
        return -1;
    }

    public T appContextViaField(String fieldName) {
        this.actContextInjection = new ActContextInjection.FieldActContextInjection(fieldName);
        return this.me();
    }

    public T appContextViaParam(int paramIndex) {
        this.actContextInjection = new ActContextInjection.ParamAppContextInjection(paramIndex);
        return this.me();
    }

    public T appContextViaLocalStorage() {
        this.actContextInjection = new ActContextInjection.LocalAppContextInjection();
        return this.me();
    }

    public ActContextInjection appContextInjection() {
        return this.actContextInjection;
    }

    public T disableJsonCircularRefDetect(boolean b) {
        this.disableJsonCircularRefDetect = b;
        return this.me();
    }

    public boolean disableJsonCircularRefDetect() {
        return this.disableJsonCircularRefDetect;
    }

    public T invokeStaticMethod() {
        this.invokeType = InvokeType.STATIC;
        return this.me();
    }

    public T invokeInstanceMethod() {
        this.invokeType = InvokeType.VIRTUAL;
        return this.me();
    }

    public boolean isStatic() {
        return InvokeType.STATIC == this.invokeType;
    }

    public HandlerMethodMetaInfo propertySpec(PropertySpec.MetaInfo propertySpec) {
        this.propertySpec = propertySpec;
        return this;
    }

    public PropertySpec.MetaInfo propertySpec() {
        return this.propertySpec;
    }

    public T returnType(Type type) {
        this.returnType = ReturnTypeInfo.of(type);
        return this.me();
    }

    public T appCtxLocalVariableTableIndex(int index) {
        this.appCtxLVT_id = index;
        return this.me();
    }

    public int appCtxLocalVariableTableIndex() {
        return this.appCtxLVT_id;
    }

    public Type returnType() {
        return this.returnType.type();
    }

    public ReturnTypeInfo returnTypeInfo() {
        return this.returnType;
    }

    public Type returnComponentType() {
        return this.returnType.componentType();
    }

    public HandlerMethodMetaInfo returnComponentType(Type type) {
        this.returnType.componentType(type);
        return this;
    }

    public boolean hasReturn() {
        return this.returnType.hasReturn();
    }

    public boolean hasLocalVariableTable() {
        return !this.locals.isEmpty();
    }

    public HandlerMethodMetaInfo addParam(HandlerParamMetaInfo param) {
        this.params.add((Object)param);
        return this;
    }

    public T addLocal(LocalVariableMetaInfo local) {
        Label start = local.start();
        C.Map m = this.locals.get(start);
        if (null == m) {
            m = C.newMap((Object[])new Object[0]);
            this.locals.put(start, (Map<Integer, LocalVariableMetaInfo>)m);
        }
        int index = local.index();
        E.illegalStateIf((boolean)m.containsKey(index), (String)"Local variable index conflict");
        m.put(local.index(), local);
        return this.me();
    }

    public LocalVariableMetaInfo localVariable(int index, Label start) {
        Map<Integer, LocalVariableMetaInfo> l = this.locals.get(start);
        if (null == l) {
            return null;
        }
        return l.get(index);
    }

    public HandlerParamMetaInfo param(int id) {
        return (HandlerParamMetaInfo)this.params.get(id);
    }

    public int paramCount() {
        return this.params.size();
    }

    public synchronized int ctxParamCount() {
        if (this.ctxParamCnt < 0) {
            if (this.paramCount() == 0) {
                this.ctxParamCnt = 0;
            } else {
                this.ctxParamCnt = 0;
                for (HandlerParamMetaInfo param : this.params) {
                    if (!param.isContext()) continue;
                    ++this.ctxParamCnt;
                }
            }
        }
        return this.ctxParamCnt;
    }

    public int hashCode() {
        return $.hc((Object)this.fullName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof HandlerMethodMetaInfo) {
            HandlerMethodMetaInfo that = (HandlerMethodMetaInfo)obj;
            return $.eq((Object)that.fullName(), (Object)this.fullName());
        }
        return false;
    }

    public String toString() {
        return this.toStrBuffer(S.newBuffer()).toString();
    }

    protected S.Buffer toStrBuffer(S.Buffer sb) {
        sb.append((Object)this.actContextInjection).append("");
        sb.append(this._invokeType()).append(this._return()).append(this.fullName()).append("(").append(this._params()).append(")");
        return sb;
    }

    private String _invokeType() {
        if (null == this.invokeType) {
            return "";
        }
        switch (this.invokeType) {
            case VIRTUAL: {
                return "";
            }
            case STATIC: {
                return "static ";
            }
        }
        assert (false);
        return "";
    }

    private String _return() {
        if (null == this.returnType) {
            return "";
        }
        if (this.returnType.hasReturn()) {
            return this.returnType.type().getClassName() + " ";
        }
        return "";
    }

    private String _params() {
        return S.join((String)", ", (Iterable)this.params.map((Osgl.Function)new Osgl.Transformer<HandlerParamMetaInfo, String>(){

            public String transform(HandlerParamMetaInfo paramMetaInfo) {
                return paramMetaInfo.type().getClassName();
            }
        }));
    }

    private T me() {
        return (T)this;
    }
}

