/*
 * Decompiled with CFR 0.152.
 */
package act.controller.meta;

import act.app.App;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.HandlerMethodMetaInfo;
import java.util.Set;
import org.osgl.util.C;
import org.osgl.util.S;

public class InterceptorMethodMetaInfo
extends HandlerMethodMetaInfo<InterceptorMethodMetaInfo>
implements Comparable<InterceptorMethodMetaInfo> {
    private Set<String> whiteList = C.newSet();
    private Set<String> blackList = C.newSet();
    private int priority;

    protected InterceptorMethodMetaInfo(InterceptorMethodMetaInfo copy, ControllerClassMetaInfo clsInfo) {
        super(copy, clsInfo);
        this.whiteList = copy.whiteList;
        this.blackList = copy.blackList;
        this.priority = copy.priority;
    }

    public InterceptorMethodMetaInfo(ControllerClassMetaInfo clsInfo) {
        super(clsInfo);
    }

    @Override
    protected void releaseResources() {
        this.whiteList.clear();
        this.blackList.clear();
        super.releaseResources();
    }

    public InterceptorMethodMetaInfo addOnly(String ... only) {
        if (!this.blackList.isEmpty()) {
            App.logger.warn("Both [only] and [except] list are used for interceptor method[%s]. You should use only one", new Object[]{this.name()});
        }
        return this.addTo(this.whiteList, only);
    }

    public InterceptorMethodMetaInfo addExcept(String ... except) {
        if (!this.whiteList.isEmpty()) {
            App.logger.warn("Both [only] and [except] list are used for interceptor method[%s]. You should use only one", new Object[]{this.name()});
            return this;
        }
        return this.addTo(this.blackList, except);
    }

    public InterceptorMethodMetaInfo priority(int priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    public Set<String> whiteList() {
        return C.set(this.whiteList);
    }

    public Set<String> blackList() {
        return C.set(this.blackList);
    }

    void mergeInto(C.List<InterceptorMethodMetaInfo> list, String targetName) {
        if (!(!this.whiteList.contains(targetName) && this.blackList.contains(targetName) || list.contains((Object)this))) {
            list.add((Object)this);
        }
    }

    private InterceptorMethodMetaInfo addTo(Set<String> set, String ... strings) {
        int len = strings.length;
        if (len == 0) {
            return this;
        }
        for (int i = 0; i < len; ++i) {
            String[] sa = strings[i].split("[\\s,;:]+");
            int saLen = sa.length;
            for (int j = 0; j < saLen; ++j) {
                set.add(sa[j]);
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toStrBuffer(S.newBuffer()).toString();
    }

    @Override
    protected S.Buffer toStrBuffer(S.Buffer sb) {
        S.Buffer prependix = S.newBuffer();
        if (0 != this.priority) {
            prependix.append("p[").append(this.priority).append("] ");
        }
        if (!this.whiteList.isEmpty()) {
            prependix.append("+").append(this.whiteList).append(" ");
        }
        if (!this.blackList.isEmpty()) {
            prependix.append("-").append(this.blackList).append(" ");
        }
        return super.toStrBuffer(sb).prepend(prependix);
    }

    @Override
    public int compareTo(InterceptorMethodMetaInfo o) {
        return o.priority - this.priority;
    }

    public final InterceptorMethodMetaInfo extended(ControllerClassMetaInfo clsInfo) {
        if (clsInfo.isMyAncestor(this.classInfo()) && !this.isStatic()) {
            return this.doExtend(clsInfo);
        }
        return this;
    }

    protected InterceptorMethodMetaInfo doExtend(ControllerClassMetaInfo clsInfo) {
        return new InterceptorMethodMetaInfo(this, clsInfo);
    }
}

