/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.ActionContext;
import act.data.ContentTypeWithEncoding;
import act.data.MapUtil;
import act.data.MultipartStream;
import act.data.RequestBodyParser;
import act.util.UploadFileStorageService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ParameterParser;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.util.Closeable;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.storage.ISObject;
import org.osgl.util.IO;

public class ApacheMultipartParser
extends RequestBodyParser {
    private static final String CONTENT_TYPE = "Content-type";
    private static final String CONTENT_DISPOSITION = "Content-disposition";
    private static final String FORM_DATA = "form-data";
    private static final String ATTACHMENT = "attachment";
    private static final String MULTIPART = "multipart/";
    private static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private static final String MULTIPART_MIXED = "multipart/mixed";
    private long sizeMax = -1L;
    private long fileSizeMax = -1L;

    @Override
    public Map<String, String[]> parse(ActionContext context) {
        H.Request request = context.req();
        InputStream body = request.inputStream();
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        try {
            FileItemIteratorImpl iter = new FileItemIteratorImpl(body, request.header("content-type"), request.characterEncoding());
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                AutoFileItem fileItem = new AutoFileItem(item, context);
                try {
                    IO.copy((InputStream)item.openStream(), (OutputStream)fileItem.getOutputStream(), (boolean)true);
                }
                catch (FileUploadIOException e) {
                    throw (FileUploadException)e.getCause();
                }
                catch (IOException e) {
                    throw new IOFileUploadException("Processing of multipart/form-data request failed. " + e.getMessage(), e);
                }
                if (fileItem.getSize() == 0L) continue;
                if (fileItem.isFormField()) {
                    String _encoding = request.characterEncoding();
                    String _contentType = fileItem.getContentType();
                    if (_contentType != null) {
                        ContentTypeWithEncoding contentTypeEncoding = ContentTypeWithEncoding.parse(_contentType);
                        if (contentTypeEncoding.encoding != null) {
                            _encoding = contentTypeEncoding.encoding;
                        }
                    }
                    MapUtil.mergeValueInMap(result, fileItem.getFieldName(), fileItem.getString(_encoding));
                    continue;
                }
                ISObject obj = UploadFileStorageService.store(fileItem, context.app());
                context.addUpload(fileItem.getFieldName(), obj);
                MapUtil.mergeValueInMap(result, fileItem.getFieldName(), fileItem.getFieldName());
            }
        }
        catch (FileUploadIOException e) {
            logger.debug((Throwable)e, "error");
            throw new IllegalStateException("Error when handling upload", e);
        }
        catch (IOException e) {
            logger.debug((Throwable)e, "error");
            throw new IllegalStateException("Error when handling upload", e);
        }
        catch (FileUploadException e) {
            logger.debug((Throwable)e, "error");
            throw new IllegalStateException("Error when handling upload", e);
        }
        catch (Exception e) {
            logger.debug((Throwable)e, "error");
            throw new UnexpectedException((Throwable)e);
        }
        return result;
    }

    private byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map params = parser.parse(contentType, ';');
        String boundaryStr = (String)params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    private String getFileName(Map headers) {
        String cdl;
        String fileName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && ((cdl = cd.toLowerCase()).startsWith(FORM_DATA) || cdl.startsWith(ATTACHMENT))) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(cd, ';');
            if (params.containsKey("filename")) {
                fileName = (String)params.get("filename");
                if (fileName != null) {
                    if ((fileName = fileName.trim()).indexOf(92) != -1) {
                        fileName = fileName.substring(fileName.lastIndexOf(92) + 1);
                    }
                } else {
                    fileName = "";
                }
            }
        }
        return fileName;
    }

    private String getFieldName(Map headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && cd.toLowerCase().startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(cd, ';');
            fieldName = (String)params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    private Map parseHeaders(String headerPart) {
        int end;
        int len = headerPart.length();
        HashMap<String, String> headers = new HashMap<String, String>();
        int start = 0;
        while (start != (end = this.parseEndOfLine(headerPart, start))) {
            String header = headerPart.substring(start, end);
            start = end + 2;
            while (start < len) {
                char c;
                int nonWs;
                for (nonWs = start; nonWs < len && ((c = headerPart.charAt(nonWs)) == ' ' || c == '\t'); ++nonWs) {
                }
                if (nonWs == start) break;
                end = this.parseEndOfLine(headerPart, nonWs);
                header = header + " " + headerPart.substring(nonWs, end);
                start = end + 2;
            }
            this.parseHeaderLine(headers, header);
        }
        return headers;
    }

    private int parseEndOfLine(String headerPart, int end) {
        int index = end;
        while (true) {
            int offset;
            if ((offset = headerPart.indexOf(13, index)) == -1 || offset + 1 >= headerPart.length()) {
                throw new IllegalStateException("Expected headers to be terminated by an empty line.");
            }
            if (headerPart.charAt(offset + 1) == '\n') {
                return offset;
            }
            index = offset + 1;
        }
    }

    private void parseHeaderLine(Map<String, String> headers, String header) {
        int colonOffset = header.indexOf(58);
        if (colonOffset == -1) {
            return;
        }
        String headerName = header.substring(0, colonOffset).trim().toLowerCase();
        String headerValue = header.substring(header.indexOf(58) + 1).trim();
        if (this.getHeader(headers, headerName) != null) {
            headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
        } else {
            headers.put(headerName, headerValue);
        }
    }

    private final String getHeader(Map headers, String name) {
        return (String)headers.get(name.toLowerCase());
    }

    private static class FileSizeLimitExceededException
    extends SizeException {
        private static final long serialVersionUID = 8150776562029630058L;

        public FileSizeLimitExceededException(String message, long actual, long permitted) {
            super(message, actual, permitted);
        }
    }

    private static class SizeLimitExceededException
    extends SizeException {
        private static final long serialVersionUID = -2474893167098052828L;

        public SizeLimitExceededException(String message, long actual, long permitted) {
            super(message, actual, permitted);
        }
    }

    protected static abstract class SizeException
    extends FileUploadException {
        private final long actual;
        private final long permitted;

        protected SizeException(String message, long actual, long permitted) {
            super(message);
            this.actual = actual;
            this.permitted = permitted;
        }

        public long getActualSize() {
            return this.actual;
        }

        public long getPermittedSize() {
            return this.permitted;
        }
    }

    private static class IOFileUploadException
    extends FileUploadException {
        private static final long serialVersionUID = 1749796615868477269L;
        private final IOException cause;

        public IOFileUploadException(String pMsg, IOException pException) {
            super(pMsg);
            this.cause = pException;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    private static class InvalidContentTypeException
    extends FileUploadException {
        private static final long serialVersionUID = -9073026332015646668L;

        public InvalidContentTypeException(String message) {
            super(message);
        }
    }

    private static class FileUploadIOException
    extends IOException {
        private static final long serialVersionUID = -7047616958165584154L;
        private final FileUploadException cause;

        public FileUploadIOException(FileUploadException pCause) {
            this.cause = pCause;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    private class FileItemIteratorImpl
    implements FileItemIterator {
        private final MultipartStream multi;
        private final byte[] boundary;
        private FileItemStreamImpl currentItem;
        private String currentFieldName;
        private boolean skipPreamble;
        private boolean itemValid;
        private boolean eof;

        FileItemIteratorImpl(InputStream input, String contentType, String charEncoding) throws FileUploadException, IOException {
            if (null == contentType || !contentType.toLowerCase().startsWith(ApacheMultipartParser.MULTIPART)) {
                throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
            }
            if (ApacheMultipartParser.this.sizeMax >= 0L) {
                input = new LimitedInputStream(input, ApacheMultipartParser.this.sizeMax){

                    protected void raiseError(long pSizeMax, long pCount) throws IOException {
                        SizeLimitExceededException ex = new SizeLimitExceededException("the request was rejected because its size (" + pCount + ") exceeds the configured maximum (" + pSizeMax + ")", pCount, pSizeMax);
                        throw new FileUploadIOException(ex);
                    }
                };
            }
            this.boundary = ApacheMultipartParser.this.getBoundary(contentType);
            if (this.boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            this.multi = new MultipartStream(input, this.boundary, 4096, null);
            this.multi.setHeaderEncoding(charEncoding);
            this.skipPreamble = true;
            this.findNextItem();
        }

        private boolean findNextItem() throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.currentItem != null) {
                this.currentItem.close();
                this.currentItem = null;
            }
            while (true) {
                boolean nextPart;
                if (!(nextPart = this.skipPreamble ? this.multi.skipPreamble() : this.multi.readBoundary())) {
                    if (this.currentFieldName == null) {
                        this.eof = true;
                        return false;
                    }
                    this.multi.setBoundary(this.boundary);
                    this.currentFieldName = null;
                    continue;
                }
                Map headers = ApacheMultipartParser.this.parseHeaders(this.multi.readHeaders());
                if (this.currentFieldName == null) {
                    String fieldName = ApacheMultipartParser.this.getFieldName(headers);
                    if (fieldName != null) {
                        String subContentType = ApacheMultipartParser.this.getHeader(headers, ApacheMultipartParser.CONTENT_TYPE);
                        if (subContentType != null && subContentType.toLowerCase().startsWith(ApacheMultipartParser.MULTIPART_MIXED)) {
                            this.currentFieldName = fieldName;
                            byte[] subBoundary = ApacheMultipartParser.this.getBoundary(subContentType);
                            this.multi.setBoundary(subBoundary);
                            this.skipPreamble = true;
                            continue;
                        }
                        String fileName = ApacheMultipartParser.this.getFileName(headers);
                        this.currentItem = new FileItemStreamImpl(fileName, fieldName, ApacheMultipartParser.this.getHeader(headers, ApacheMultipartParser.CONTENT_TYPE), fileName == null);
                        this.itemValid = true;
                        return true;
                    }
                } else {
                    String fileName = ApacheMultipartParser.this.getFileName(headers);
                    if (fileName != null) {
                        this.currentItem = new FileItemStreamImpl(fileName, this.currentFieldName, ApacheMultipartParser.this.getHeader(headers, ApacheMultipartParser.CONTENT_TYPE), false);
                        this.itemValid = true;
                        return true;
                    }
                }
                this.multi.discardBodyData();
            }
        }

        public boolean hasNext() throws FileUploadException, IOException {
            return !this.eof && (this.itemValid || this.findNextItem());
        }

        public FileItemStream next() throws FileUploadException, IOException {
            if (this.eof || !this.itemValid && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.itemValid = false;
            return this.currentItem;
        }

        private class FileItemStreamImpl
        implements FileItemStream {
            private final String contentType;
            private final String fieldName;
            private final String name;
            private final boolean formField;
            private final InputStream stream;
            private boolean opened;
            private FileItemHeaders fileItemHeaders;

            FileItemStreamImpl(String pName, String pFieldName, String pContentType, boolean pFormField) {
                this.name = pName;
                this.fieldName = pFieldName;
                this.contentType = pContentType;
                this.formField = pFormField;
                MultipartStream.ItemInputStream istream = FileItemIteratorImpl.this.multi.newInputStream();
                if (ApacheMultipartParser.this.fileSizeMax != -1L) {
                    istream = new LimitedInputStream(istream, ApacheMultipartParser.this.fileSizeMax){

                        protected void raiseError(long pSizeMax, long pCount) throws IOException {
                            FileSizeLimitExceededException e = new FileSizeLimitExceededException("The field " + FileItemStreamImpl.this.fieldName + " exceeds its maximum permitted  size of " + pSizeMax + " characters.", pCount, pSizeMax);
                            throw new FileUploadIOException(e);
                        }
                    };
                }
                this.stream = istream;
            }

            public FileItemHeaders getHeaders() {
                return this.fileItemHeaders;
            }

            public void setHeaders(FileItemHeaders fileItemHeaders) {
                this.fileItemHeaders = fileItemHeaders;
            }

            public String getContentType() {
                return this.contentType;
            }

            public String getFieldName() {
                return this.fieldName;
            }

            public String getName() {
                return this.name;
            }

            public boolean isFormField() {
                return this.formField;
            }

            public InputStream openStream() throws IOException {
                if (this.opened) {
                    throw new IllegalStateException("The stream was already opened.");
                }
                if (((Closeable)this.stream).isClosed()) {
                    throw new FileItemStream.ItemSkippedException();
                }
                return this.stream;
            }

            void close() throws IOException {
                this.stream.close();
            }
        }
    }

    public static class AutoFileItem
    implements FileItem {
        private static FileCleaningTracker fileTracker = new FileCleaningTracker();
        private ActionContext context;
        public static final String DEFAULT_CHARSET = "ISO-8859-1";
        private static final int WRITE_BUFFER_SIZE = 2048;
        private static int counter = 0;
        private String fieldName;
        private String contentType;
        private boolean isFormField;
        private String fileName;
        private int sizeThreshold;
        private File repository;
        private byte[] cachedContent;
        private DeferredFileOutputStream dfos;
        private FileItemHeaders headers;

        public AutoFileItem(FileItemStream stream, ActionContext context) {
            this.fieldName = stream.getFieldName();
            this.contentType = stream.getContentType();
            this.isFormField = stream.isFormField();
            this.fileName = FilenameUtils.getName((String)stream.getName());
            this.sizeThreshold = 10240;
            this.repository = null;
            this.context = context;
        }

        public InputStream getInputStream() throws IOException {
            if (!this.dfos.isInMemory()) {
                return new FileInputStream(this.dfos.getFile());
            }
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return new ByteArrayInputStream(this.cachedContent);
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getCharSet() {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map params = parser.parse(this.getContentType(), ';');
            return (String)params.get("charset");
        }

        public String getName() {
            return this.fileName;
        }

        public boolean isInMemory() {
            return this.dfos.isInMemory();
        }

        public long getSize() {
            if (this.cachedContent != null) {
                return this.cachedContent.length;
            }
            if (this.dfos.isInMemory()) {
                return this.dfos.getData().length;
            }
            return this.dfos.getFile().length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] get() {
            if (this.dfos.isInMemory()) {
                if (this.cachedContent == null) {
                    this.cachedContent = this.dfos.getData();
                }
                return this.cachedContent;
            }
            byte[] fileData = new byte[(int)this.getSize()];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.dfos.getFile());
                fis.read(fileData);
            }
            catch (IOException e) {
                fileData = null;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return fileData;
        }

        public String getString(String charset) throws UnsupportedEncodingException {
            return new String(this.get(), charset);
        }

        public String getString() {
            byte[] rawdata = this.get();
            String charset = this.getCharSet();
            if (charset == null) {
                charset = DEFAULT_CHARSET;
            }
            try {
                return new String(rawdata, charset);
            }
            catch (UnsupportedEncodingException e) {
                return new String(rawdata);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(File file) throws Exception {
            if (this.isInMemory()) {
                try (FileOutputStream fout = null;){
                    fout = new FileOutputStream(file);
                    fout.write(this.get());
                }
            }
            File outputFile = this.getStoreLocation();
            if (outputFile != null) {
                if (!outputFile.renameTo(file)) {
                    BufferedInputStream in = null;
                    FilterOutputStream out = null;
                    try {
                        in = new BufferedInputStream(new FileInputStream(outputFile));
                        out = new BufferedOutputStream(new FileOutputStream(file));
                        byte[] bytes = new byte[2048];
                        int s = 0;
                        while ((s = in.read(bytes)) != -1) {
                            ((BufferedOutputStream)out).write(bytes, 0, s);
                        }
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            } else {
                throw new FileUploadException("Cannot write uploaded file to disk!");
            }
        }

        public void delete() {
            this.cachedContent = null;
            File outputFile = this.getStoreLocation();
            if (outputFile != null && outputFile.exists()) {
                outputFile.delete();
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public boolean isFormField() {
            return this.isFormField;
        }

        public void setFormField(boolean state) {
            this.isFormField = state;
        }

        public OutputStream getOutputStream() throws IOException {
            if (this.dfos == null) {
                File outputFile = null;
                if (this.sizeThreshold != Integer.MAX_VALUE) {
                    outputFile = this.getTempFile(this.context);
                }
                this.dfos = new DeferredFileOutputStream(this.sizeThreshold, outputFile);
            }
            return this.dfos;
        }

        public File getStoreLocation() {
            return this.dfos.getFile();
        }

        protected void finalize() {
            File outputFile = this.dfos.getFile();
            if (outputFile != null && outputFile.exists()) {
                outputFile.delete();
            }
        }

        protected File getTempFile(ActionContext context) {
            File tempDir = this.repository;
            if (tempDir == null) {
                tempDir = context.app().tmpDir();
            }
            String fileName = "upload_" + AutoFileItem.getUniqueId() + ".tmp";
            File f2 = new File(tempDir, fileName);
            fileTracker.track(f2, (Object)this);
            return f2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getUniqueId() {
            Class<DiskFileItem> clazz = DiskFileItem.class;
            synchronized (DiskFileItem.class) {
                int current = counter++;
                // ** MonitorExit[var1] (shouldn't be in output)
                String id = Integer.toString(current);
                if (current < 100000000) {
                    id = ("00000000" + id).substring(id.length());
                }
                return id;
            }
        }

        public String toString() {
            return "name=" + this.getName() + ", StoreLocation=" + String.valueOf(this.getStoreLocation()) + ", size=" + this.getSize() + "bytes, isFormField=" + this.isFormField() + ", FieldName=" + this.getFieldName();
        }

        public FileItemHeaders getHeaders() {
            return this.headers;
        }

        public void setHeaders(FileItemHeaders pHeaders) {
            this.headers = pHeaders;
        }
    }
}

