/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

@Singleton
public class DateResolver
extends StringValueResolver<Date> {
    static Logger logger = L.get(DateResolver.class);
    private DateFormat dateFormat;

    @Inject
    public DateResolver(AppConfig config) {
        String pattern = config.dateTimeFormat();
        this.dateFormat = null == pattern || pattern.contains("8601") || pattern.contains("iso") ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX") : new SimpleDateFormat(pattern);
    }

    public DateResolver(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public Date resolve(String value) {
        if (S.blank((String)value)) {
            return null;
        }
        try {
            return this.dateFormat.parse(value);
        }
        catch (ParseException e) {
            logger.error("error parsing date value from: %s", new Object[]{value});
            return null;
        }
    }
}

