/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.annotation.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.osgl.$;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

@Singleton
public class JodaDateTimeCodec
extends JodaDateTimeCodecBase<DateTime> {
    private DateTimeFormatter dateFormat;

    public JodaDateTimeCodec(DateTimeFormatter dateFormat) {
        this.dateFormat = (DateTimeFormatter)$.notNull((Object)dateFormat);
        this.verify();
    }

    public JodaDateTimeCodec(String pattern) {
        this.dateFormat = JodaDateTimeCodec.isIsoStandard(pattern) ? ISODateTimeFormat.dateTime() : DateTimeFormat.forPattern((String)pattern);
        this.verify();
    }

    @Inject
    public JodaDateTimeCodec(AppConfig config) {
        this(config.dateTimeFormat());
    }

    public DateTime resolve(String value) {
        return S.blank((String)value) ? null : this.dateFormat.parseDateTime(value);
    }

    @Override
    public Class targetClass() {
        return DateTime.class;
    }

    public DateTime parse(String s) {
        return this.resolve(s);
    }

    public String toString(DateTime o) {
        return this.dateFormat.print((ReadableInstant)o);
    }

    public String toJSONString(DateTime o) {
        String s = this.toString(o);
        return S.newSizedBuffer((int)(s.length() + 2)).append("\"").append(s).append("\"").toString();
    }

    public StringValueResolver<DateTime> amended(AnnotationAware beanSpec) {
        Pattern pattern = (Pattern)beanSpec.getAnnotation(Pattern.class);
        return null == pattern ? this : new JodaDateTimeCodec(pattern.value());
    }

    private void verify() {
        DateTime now = DateTime.now();
        String s = this.toString(now);
        if (!s.equals(this.toString(this.parse(s)))) {
            throw new IllegalArgumentException("Invalid date time pattern");
        }
    }
}

