/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.annotation.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.osgl.$;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

@Singleton
public class JodaLocalDateCodec
extends JodaDateTimeCodecBase<LocalDate> {
    private DateTimeFormatter dateFormat;

    public JodaLocalDateCodec(DateTimeFormatter dateFormat) {
        this.dateFormat = (DateTimeFormatter)$.notNull((Object)dateFormat);
        this.verify();
    }

    public JodaLocalDateCodec(String pattern) {
        this.dateFormat = JodaLocalDateCodec.isIsoStandard(pattern) ? ISODateTimeFormat.date() : DateTimeFormat.forPattern((String)pattern);
        this.verify();
    }

    @Inject
    public JodaLocalDateCodec(AppConfig config) {
        this(config.dateFormat());
    }

    public LocalDate resolve(String value) {
        return S.blank((String)value) ? null : this.dateFormat.parseLocalDate(value);
    }

    public LocalDate parse(String s) {
        return this.resolve(s);
    }

    public String toString(LocalDate localDate) {
        return this.dateFormat.print((ReadablePartial)localDate);
    }

    public String toJSONString(LocalDate localDate) {
        return null;
    }

    public StringValueResolver<LocalDate> amended(AnnotationAware beanSpec) {
        Pattern pattern = (Pattern)beanSpec.getAnnotation(Pattern.class);
        return null == pattern ? this : new JodaLocalDateCodec(pattern.value());
    }

    private void verify() {
        LocalDate now = LocalDate.now();
        String s = this.toString(now);
        if (!s.equals(this.toString(this.parse(s)))) {
            throw new IllegalArgumentException("Invalid date time pattern");
        }
    }
}

