/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.annotation.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.osgl.$;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

@Singleton
public class JodaLocalDateTimeCodec
extends JodaDateTimeCodecBase<LocalDateTime> {
    private DateTimeFormatter dateFormat;
    private boolean isIso;

    public JodaLocalDateTimeCodec(DateTimeFormatter dateFormat) {
        this.dateFormat = (DateTimeFormatter)$.notNull((Object)dateFormat);
        this.verify();
    }

    public JodaLocalDateTimeCodec(String pattern) {
        if (JodaLocalDateTimeCodec.isIsoStandard(pattern)) {
            this.dateFormat = ISODateTimeFormat.dateTimeNoMillis();
            this.isIso = true;
        } else {
            this.dateFormat = DateTimeFormat.forPattern((String)pattern);
        }
        this.verify();
    }

    @Inject
    public JodaLocalDateTimeCodec(AppConfig config) {
        this(config.dateTimeFormat());
    }

    public LocalDateTime resolve(String value) {
        if (S.notBlank((String)value)) {
            if (this.isIso && !value.contains("Z")) {
                value = value + "Z";
            }
            return this.dateFormat.parseLocalDateTime(value);
        }
        return null;
    }

    public LocalDateTime parse(String s) {
        return this.resolve(s);
    }

    public String toString(LocalDateTime localDateTime) {
        return this.dateFormat.print((ReadablePartial)localDateTime);
    }

    public String toJSONString(LocalDateTime localDateTime) {
        return null;
    }

    public StringValueResolver<LocalDateTime> amended(AnnotationAware beanSpec) {
        Pattern pattern = (Pattern)beanSpec.getAnnotation(Pattern.class);
        return null == pattern ? this : new JodaLocalDateTimeCodec(pattern.value());
    }

    private void verify() {
        LocalDateTime now = LocalDateTime.now();
        String s = this.toString(now);
        if (!s.equals(this.toString(this.parse(s)))) {
            throw new IllegalArgumentException("Invalid date time pattern");
        }
    }
}

