/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.conf.AppConfig;
import act.data.JodaDateTimeCodecBase;
import act.data.annotation.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.osgl.$;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

@Singleton
public class JodaLocalTimeCodec
extends JodaDateTimeCodecBase<LocalTime> {
    private DateTimeFormatter dateFormat;
    private boolean isIso;

    public JodaLocalTimeCodec(DateTimeFormatter dateFormat) {
        this.dateFormat = (DateTimeFormatter)$.notNull((Object)dateFormat);
        this.verify();
    }

    public JodaLocalTimeCodec(String pattern) {
        if (JodaLocalTimeCodec.isIsoStandard(pattern)) {
            this.dateFormat = ISODateTimeFormat.timeNoMillis();
            this.isIso = true;
        } else {
            this.dateFormat = DateTimeFormat.forPattern((String)pattern);
        }
        this.verify();
    }

    @Inject
    public JodaLocalTimeCodec(AppConfig config) {
        this(config.timeFormat());
    }

    public LocalTime resolve(String value) {
        if (S.notBlank((String)value)) {
            if (this.isIso && !value.contains("Z")) {
                value = value + "Z";
            }
            return this.dateFormat.parseLocalTime(value);
        }
        return null;
    }

    public LocalTime parse(String s) {
        return this.resolve(s);
    }

    public String toString(LocalTime localTime) {
        return this.dateFormat.print((ReadablePartial)localTime);
    }

    public String toJSONString(LocalTime localTime) {
        return null;
    }

    public StringValueResolver<LocalTime> amended(AnnotationAware beanSpec) {
        Pattern pattern = (Pattern)beanSpec.getAnnotation(Pattern.class);
        return null == pattern ? this : new JodaLocalTimeCodec(pattern.value());
    }

    private void verify() {
        LocalTime now = LocalTime.now();
        String s = this.toString(now);
        if (!s.equals(this.toString(this.parse(s)))) {
            throw new IllegalArgumentException("Invalid date time pattern");
        }
    }
}

