/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.Act;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.osgl.$;
import org.osgl.util.ValueObject;

public abstract class MapCodec<T extends Map<String, Object>>
implements ValueObject.Codec<T> {
    private Class<T> targetClass;

    public MapCodec(Class<T> targetClass) {
        this.targetClass = (Class)$.notNull(targetClass);
    }

    public Class<T> targetClass() {
        return this.targetClass;
    }

    public T parse(String s) {
        JSONObject json = JSON.parseObject((String)s);
        Map map = (Map)Act.app().getInstance(this.targetClass);
        for (Map.Entry entry : json.entrySet()) {
            map.put(entry.getKey(), ValueObject.of(entry.getValue()));
        }
        return (T)map;
    }

    public String toString(T o) {
        return JSON.toJSONString(o);
    }

    public String toJSONString(T o) {
        return this.toString(o);
    }

    public static class GenericMapCodec
    extends MapCodec<Map<String, Object>> {
        public GenericMapCodec() {
            super(GenericMapCodec.target());
        }

        private static Class<Map<String, Object>> target() {
            return (Class)$.cast(Map.class);
        }
    }

    public static class JsonObjectCodec
    extends MapCodec<JSONObject> {
        public JsonObjectCodec() {
            super(JSONObject.class);
        }
    }
}

