/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.ActionContext;
import act.data.ApacheMultipartParser;
import act.data.TextParser;
import act.data.UrlEncodedParser;
import java.util.Map;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;

public abstract class RequestBodyParser {
    protected static final Logger logger = L.get(RequestBodyParser.class);
    private static Map<H.Format, RequestBodyParser> parsers = C.newMap((Object[])new Object[]{H.Format.FORM_MULTIPART_DATA, new ApacheMultipartParser(), H.Format.FORM_URL_ENCODED, new UrlEncodedParser(), H.Format.JSON, TextParser.INSTANCE, H.Format.XML, TextParser.INSTANCE, H.Format.CSV, TextParser.INSTANCE});

    public static RequestBodyParser get(H.Request req) {
        H.Format contentType = req.contentType();
        RequestBodyParser parser = parsers.get(contentType);
        if (null == parser) {
            parser = TextParser.INSTANCE;
        }
        return parser;
    }

    public abstract Map<String, String[]> parse(ActionContext var1);
}

