/*
 * Decompiled with CFR 0.152.
 */
package act.data;

import act.app.ActionContext;
import act.cli.CliContext;
import act.data.StringValueResolverPlugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.Codec;
import org.osgl.util.E;

public class SObjectResolver
extends StringValueResolverPlugin<SObject> {
    public static final SObjectResolver INSTANCE = new SObjectResolver();
    private volatile transient OkHttpClient http;

    public SObject resolve(String value) {
        if (value.startsWith("http://") || value.startsWith("https://")) {
            return this.resolveFromURL(value);
        }
        if (value.startsWith("data:")) {
            int pos = value.indexOf("base64,");
            if (pos < 0) {
                return null;
            }
            String encoded = value.substring(pos + "base64,".length());
            return this.resolveFromBase64(encoded);
        }
        CliContext cli = CliContext.current();
        if (null != cli) {
            File file = cli.getFile(value);
            if (file.exists() && file.canRead()) {
                return SObject.of((File)file);
            }
        } else {
            ISObject sobj;
            ActionContext act = ActionContext.current();
            if (null != act && null != (sobj = act.upload(value))) {
                return (SObject)sobj;
            }
        }
        try {
            return this.resolveFromBase64(value);
        }
        catch (Exception e) {
            throw E.unexpected((String)"Cannot resolve SObject from value: %s", (Object[])new Object[]{value});
        }
    }

    private SObject resolveFromURL(String url) {
        try {
            Response resp = this.http().newCall(new Request.Builder().url(url).build()).execute();
            return SObject.of((InputStream)resp.body().byteStream());
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private SObject resolveFromBase64(String encoded) {
        return SObject.of((byte[])Codec.decodeBase64((String)encoded));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient http() {
        if (null == this.http) {
            SObjectResolver sObjectResolver = this;
            synchronized (sObjectResolver) {
                if (null == this.http) {
                    this.http = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(5L, TimeUnit.SECONDS).build();
                }
            }
        }
        return this.http;
    }
}

