/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.Destroyable;
import act.app.AppContextAware;
import act.app.security.SecurityContextAware;
import java.util.Collection;
import java.util.List;

public interface Dao<ID_TYPE, MODEL_TYPE, QUERY_TYPE extends Query<MODEL_TYPE, QUERY_TYPE>>
extends AppContextAware,
SecurityContextAware,
Destroyable {
    public Class<ID_TYPE> idType();

    public Class<MODEL_TYPE> modelType();

    public Class<QUERY_TYPE> queryType();

    public MODEL_TYPE findById(ID_TYPE var1);

    public Iterable<MODEL_TYPE> findBy(String var1, Object ... var2) throws IllegalArgumentException;

    public MODEL_TYPE findOneBy(String var1, Object ... var2) throws IllegalArgumentException;

    public Iterable<MODEL_TYPE> findByIdList(Collection<ID_TYPE> var1);

    public Iterable<MODEL_TYPE> findAll();

    public List<MODEL_TYPE> findAllAsList();

    public MODEL_TYPE reload(MODEL_TYPE var1);

    public ID_TYPE getId(MODEL_TYPE var1);

    public long count();

    public long countBy(String var1, Object ... var2) throws IllegalArgumentException;

    public MODEL_TYPE save(MODEL_TYPE var1);

    public void save(MODEL_TYPE var1, String var2, Object ... var3);

    public List<MODEL_TYPE> save(Iterable<MODEL_TYPE> var1);

    public void delete(MODEL_TYPE var1);

    public void delete(QUERY_TYPE var1);

    public void deleteById(ID_TYPE var1);

    public void deleteBy(String var1, Object ... var2) throws IllegalArgumentException;

    public void deleteAll();

    public void drop();

    public QUERY_TYPE q();

    public QUERY_TYPE createQuery();

    public QUERY_TYPE q(String var1, Object ... var2);

    public QUERY_TYPE createQuery(String var1, Object ... var2);

    public static interface Query<MODEL_TYPE, QUERY_TYPE extends Query<MODEL_TYPE, QUERY_TYPE>> {
        public QUERY_TYPE offset(int var1);

        public QUERY_TYPE limit(int var1);

        public QUERY_TYPE orderBy(String ... var1);

        public MODEL_TYPE first();

        public Iterable<MODEL_TYPE> fetch();

        public long count();
    }
}

