/*
 * Decompiled with CFR 0.152.
 */
package act.db;

import act.app.security.SecurityContext;
import act.db.Dao;
import act.inject.param.NoBind;
import act.util.ActContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.$;
import org.osgl.util.Generics;

@NoBind
public abstract class DaoBase<ID_TYPE, MODEL_TYPE, QUERY_TYPE extends Dao.Query<MODEL_TYPE, QUERY_TYPE>>
implements Dao<ID_TYPE, MODEL_TYPE, QUERY_TYPE> {
    private ActContext appCtx;
    private SecurityContext secCtx;
    private boolean destroyed;
    protected Type modelType;
    protected Type idType;
    protected Type queryType;

    public DaoBase() {
        this.exploreTypes();
    }

    public DaoBase(Class<ID_TYPE> idType, Class<MODEL_TYPE> modelType) {
        this.idType = (Type)$.notNull(idType);
        this.modelType = (Type)$.notNull(modelType);
    }

    @Override
    public void setAppContext(ActContext context) {
        this.appCtx = context;
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.releaseResources();
        this.appCtx = null;
        this.secCtx = null;
    }

    @Override
    public Class<ID_TYPE> idType() {
        return Generics.classOf((Type)this.idType);
    }

    @Override
    public Class<MODEL_TYPE> modelType() {
        return Generics.classOf((Type)this.modelType);
    }

    @Override
    public Class<QUERY_TYPE> queryType() {
        return Generics.classOf((Type)this.queryType);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        this.secCtx = context;
    }

    protected void releaseResources() {
    }

    @Override
    public Class<? extends Annotation> scope() {
        return ApplicationScoped.class;
    }

    protected final ActContext appContext() {
        return this.appCtx;
    }

    protected final SecurityContext securityContext() {
        return this.secCtx;
    }

    private void exploreTypes() {
        List types = Generics.typeParamImplementations(this.getClass(), DaoBase.class);
        int sz = types.size();
        if (sz < 1) {
            return;
        }
        if (sz > 2) {
            this.queryType = (Type)types.get(2);
        }
        if (sz > 1) {
            this.modelType = (Type)types.get(1);
        }
        this.idType = (Type)types.get(0);
    }
}

