/*
 * Decompiled with CFR 0.152.
 */
package act.db.di;

import act.app.App;
import act.db.Dao;
import act.inject.param.ParamValueLoaderService;
import act.util.ActContext;
import java.util.Collection;
import org.osgl.inject.ValueLoader;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class FindBy
extends ValueLoader.Base {
    private String bindName;
    private Dao dao;
    private StringValueResolver resolver;
    private boolean findOne;
    private boolean byId;
    private String querySpec;
    private Class<?> rawType;

    protected void initialized() {
        App app = App.instance();
        this.rawType = this.spec.rawType();
        this.findOne = !Collection.class.isAssignableFrom(this.rawType);
        this.dao = app.dbServiceManager().dao(this.findOne ? this.rawType : (Class)this.spec.typeParams().get(0));
        this.byId = (Boolean)this.options.get("byId");
        this.resolver = app.resolverManager().resolver(this.byId ? this.dao.idType() : (Class)this.options.get("fieldType"));
        if (null == this.resolver) {
            throw new IllegalArgumentException("Cannot find String value resolver for type: " + this.dao.idType());
        }
        this.bindName = S.string((Object)this.value());
        if (S.blank((String)this.bindName)) {
            this.bindName = ParamValueLoaderService.bindName(this.spec);
        }
        if (!this.byId) {
            this.querySpec = S.string(this.options.get("value"));
            if (S.blank((String)this.querySpec)) {
                this.querySpec = this.bindName;
            }
        }
    }

    public Object get() {
        Collection col;
        ActContext ctx = ActContext.Base.currentContext();
        E.illegalStateIf((null == ctx ? 1 : 0) != 0);
        String value = FindBy.resolve(this.bindName, ctx);
        if (null == value) {
            return null;
        }
        Object by = this.resolver.resolve(value);
        if (null == by) {
            return null;
        }
        Collection collection = col = this.findOne ? null : (Collection)App.instance().getInstance(this.rawType);
        if (this.byId) {
            Object bean = this.dao.findById(by);
            if (this.findOne) {
                return bean;
            }
            col.add(bean);
            return col;
        }
        if (this.findOne) {
            return this.dao.findOneBy(Keyword.of((CharSequence)this.querySpec).javaVariable(), by);
        }
        col.addAll(C.list(this.dao.findBy(Keyword.of((CharSequence)this.querySpec).javaVariable(), by)));
        return col;
    }

    private static String resolve(String bindName, ActContext ctx) {
        String value = ctx.paramVal(bindName);
        if (S.notBlank((String)value)) {
            return value;
        }
        Keyword keyword = Keyword.of((CharSequence)bindName);
        if (keyword.tokens().size() > 1) {
            return FindBy.resolve(keyword, ctx);
        }
        keyword = Keyword.of((CharSequence)(bindName + " id"));
        return FindBy.resolve(keyword, ctx);
    }

    private static String resolve(Keyword keyword, ActContext ctx) {
        String value = ctx.paramVal(keyword.underscore());
        if (S.notBlank((String)value)) {
            return value;
        }
        value = ctx.paramVal(keyword.javaVariable());
        if (S.notBlank((String)value)) {
            return value;
        }
        return null;
    }
}

