/*
 * Decompiled with CFR 0.152.
 */
package act.db.util;

import act.app.DbServiceManager;
import act.conf.AppConfig;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public interface _SequenceNumberGenerator {
    public long next(String var1);

    public long get(String var1);

    public void configure(AppConfig var1, DbServiceManager var2);

    public static class InMemorySequenceNumberGenerator
    implements _SequenceNumberGenerator {
        private ConcurrentMap<String, AtomicLong> seqs = new ConcurrentHashMap<String, AtomicLong>();

        @Override
        public long next(String name) {
            return this.getSeq(name).getAndIncrement();
        }

        @Override
        public long get(String name) {
            return this.getSeq(name).get();
        }

        private AtomicLong getSeq(String name) {
            AtomicLong al0;
            AtomicLong al = (AtomicLong)this.seqs.get(name);
            if (null == al && null == (al = this.seqs.putIfAbsent(name, al0 = new AtomicLong(0L)))) {
                al = al0;
            }
            return al;
        }

        @Override
        public void configure(AppConfig config, DbServiceManager dbManager) {
        }
    }
}

