/*
 * Decompiled with CFR 0.152.
 */
package act.event;

import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.event.AppEvent;
import act.app.event.AppEventId;
import act.app.event.AppEventListener;
import act.event.ActEvent;
import act.event.ActEventListener;
import act.event.ActEventListenerBase;
import act.event.OnceEventListener;
import act.event.OnceEventListenerBase;
import act.event.SimpleEventListener;
import act.event.SystemEvent;
import act.event.bytecode.ReflectedSimpleEventListener;
import act.inject.DependencyInjectionBinder;
import act.job.AppJobManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;

@ApplicationScoped
public class EventBus
extends AppServiceBase<EventBus> {
    private boolean once;
    private final List[] appEventListeners = this.initAppListenerArray();
    private final List[] asyncAppEventListeners = this.initAppListenerArray();
    private final ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> actEventListeners = new ConcurrentHashMap<Class<? extends EventObject>, List<ActEventListener>>();
    private final ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> asyncActEventListeners = new ConcurrentHashMap<Class<? extends EventObject>, List<ActEventListener>>();
    private final ConcurrentMap<AppEventId, AppEvent> appEventLookup;
    private final ConcurrentMap<Object, List<SimpleEventListener>> adhocEventListeners;
    private final ConcurrentMap<Object, List<SimpleEventListener>> asyncAdhocEventListeners;
    private EventBus onceBus;

    private EventBus(App app, boolean once) {
        super(app, true);
        this.appEventLookup = this.initAppEventLookup(app);
        this.adhocEventListeners = new ConcurrentHashMap<Object, List<SimpleEventListener>>();
        this.asyncAdhocEventListeners = new ConcurrentHashMap<Object, List<SimpleEventListener>>();
        this.loadDefaultEventListeners();
        if (!once) {
            this.onceBus = new EventBus(app, true);
            this.onceBus.once = true;
        }
    }

    @Inject
    public EventBus(App app) {
        this(app, false);
    }

    @Override
    protected void releaseResources() {
        if (null != this.onceBus) {
            this.onceBus.releaseResources();
        }
        this.releaseAppEventListeners(this.appEventListeners);
        this.releaseAppEventListeners(this.asyncAppEventListeners);
        this.releaseActEventListeners(this.actEventListeners);
        this.releaseActEventListeners(this.asyncActEventListeners);
        this.releaseAdhocEventListeners(this.adhocEventListeners);
        this.releaseAdhocEventListeners(this.asyncAdhocEventListeners);
        this.appEventLookup.clear();
    }

    private boolean callNowIfEmitted(AppEventId appEventId, AppEventListener l) {
        if (this.app().eventEmitted(appEventId)) {
            try {
                l.on((EventObject)this.appEventLookup.get((Object)appEventId));
            }
            catch (Exception e) {
                App.LOGGER.warn((Throwable)e, "error calling event handler");
            }
            return true;
        }
        return false;
    }

    private EventBus _bind(List[] listeners, AppEventId appEventId, AppEventListener l) {
        if (this.callNowIfEmitted(appEventId, l)) {
            return this;
        }
        List list = listeners[appEventId.ordinal()];
        if (!list.contains(l)) {
            list.add(l);
        }
        return this;
    }

    public synchronized EventBus bind(AppEventId appEventId, AppEventListener l) {
        return this._bind(this.appEventListeners, appEventId, l);
    }

    public synchronized EventBus bindAsync(AppEventId appEventId, AppEventListener l) {
        return this._bind(this.asyncAppEventListeners, appEventId, l);
    }

    public synchronized EventBus bindSync(AppEventId appEventId, AppEventListener l) {
        return this.bind(appEventId, l);
    }

    public static boolean isAsync(AnnotatedElement c) {
        Annotation[] aa;
        for (Annotation a : aa = c.getAnnotations()) {
            if (!a.annotationType().getName().contains("Async")) continue;
            return true;
        }
        return false;
    }

    private synchronized EventBus _bind(final ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> listeners, final Class<? extends EventObject> c, final ActEventListener l, int ttl) {
        List list = (List)listeners.get(c);
        if (null == list) {
            list = C.newList();
            listeners.putIfAbsent(c, list);
        }
        if (!list.contains(l)) {
            list.add(l);
            E.illegalArgumentIf((ttl < 0 ? 1 : 0) != 0);
            if (ttl > 0) {
                this.app().jobManager().delay(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        EventBus eventBus = EventBus.this;
                        synchronized (eventBus) {
                            EventBus.this._unbind(listeners, c, l);
                        }
                    }
                }, (long)ttl, TimeUnit.SECONDS);
            }
        }
        return this;
    }

    private synchronized EventBus _unbind(Map<Class<? extends EventObject>, List<ActEventListener>> listeners, Class<? extends EventObject> c, ActEventListener l) {
        List<ActEventListener> list = listeners.get(c);
        if (null != list) {
            list.remove(l);
        }
        return this;
    }

    public EventBus bind(Class<? extends EventObject> c, ActEventListener l) {
        boolean async = EventBus.isAsync(l.getClass()) || EventBus.isAsync(c);
        ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> listeners = async ? this.asyncActEventListeners : this.actEventListeners;
        return this._bind(listeners, c, l, 0);
    }

    public synchronized EventBus once(Class<? extends EventObject> c, OnceEventListenerBase l) {
        if (null != this.onceBus) {
            this.onceBus.bind(c, l);
        } else {
            this.bind(c, l);
        }
        return this;
    }

    public EventBus bind(Class<? extends EventObject> c, ActEventListener l, int ttl) {
        boolean async = EventBus.isAsync(l.getClass()) || EventBus.isAsync(c);
        ConcurrentMap<Class<? extends EventObject>, List<ActEventListener>> listeners = async ? this.asyncActEventListeners : this.actEventListeners;
        return this._bind(listeners, c, l, ttl);
    }

    public EventBus bindSync(Class<? extends EventObject> c, ActEventListener l) {
        return this._bind(this.actEventListeners, c, l, 0);
    }

    public EventBus bindSync(Class<? extends EventObject> c, ActEventListener l, int ttl) {
        return this._bind(this.actEventListeners, c, l, ttl);
    }

    public EventBus bindAsync(Class<? extends EventObject> c, ActEventListener l) {
        return this._bind(this.asyncActEventListeners, c, l, 0);
    }

    public EventBus bindAsync(Class<? extends EventObject> c, ActEventListener l, int ttl) {
        return this._bind(this.asyncActEventListeners, c, l, ttl);
    }

    private boolean callOn(ActEvent e, ActEventListener l) {
        try {
            if (l instanceof OnceEventListener) {
                return ((OnceEventListener)((Object)l)).tryHandle(e);
            }
            l.on(e);
            return true;
        }
        catch (Result r) {
            throw r;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw E.unexpected((Throwable)x, (String)x.getMessage(), (Object[])new Object[0]);
        }
    }

    private <T extends ActEvent> void callOn(final T event, List<? extends ActEventListener> listeners, boolean async) {
        if (null == listeners) {
            return;
        }
        AppJobManager jobManager = null;
        if (async) {
            jobManager = this.app().jobManager();
        }
        C.Set toBeRemoved = C.newSet();
        for (final ActEventListener actEventListener : listeners) {
            if (!async) {
                boolean result = this.callOn(event, actEventListener);
                if (!result || !this.once) continue;
                toBeRemoved.add(actEventListener);
                continue;
            }
            jobManager.now(new Runnable(){

                @Override
                public void run() {
                    EventBus.this.callOn(event, actEventListener);
                }
            });
        }
        if (this.once && !toBeRemoved.isEmpty()) {
            listeners.removeAll((Collection<?>)toBeRemoved);
        }
    }

    private void callOn(AppEvent event, List[] appEventListeners, boolean async) {
        List ll = appEventListeners[event.id()];
        this.callOn(event, ll, async);
    }

    private void callOn(ActEvent event, Map<Class<? extends EventObject>, List<ActEventListener>> listeners, boolean async) {
        List<ActEventListener> list = listeners.get(event.eventType());
        this.callOn(event, list, async);
    }

    public synchronized EventBus emit(AppEventId eventId) {
        return this.emit((AppEvent)this.appEventLookup.get((Object)eventId));
    }

    public synchronized EventBus trigger(AppEventId eventId) {
        return this.emit(eventId);
    }

    public synchronized EventBus emit(AppEvent event) {
        if (this.isDestroyed()) {
            return this;
        }
        this.callOn(event, this.asyncAppEventListeners, true);
        this.callOn(event, this.appEventListeners, false);
        return this;
    }

    public synchronized EventBus trigger(AppEvent event) {
        return this.emit(event);
    }

    public synchronized EventBus emitAsync(AppEventId eventId) {
        return this.emitAsync((AppEvent)this.appEventLookup.get((Object)eventId));
    }

    public synchronized EventBus emitAsync(AppEvent event) {
        if (this.isDestroyed()) {
            return this;
        }
        this.callOn(event, this.asyncAppEventListeners, true);
        this.callOn(event, this.appEventListeners, true);
        return this;
    }

    public synchronized EventBus triggerAsync(AppEvent event) {
        return this.emitAsync(event);
    }

    public synchronized EventBus emitSync(AppEventId eventId) {
        return this.emitSync((AppEvent)this.appEventLookup.get((Object)eventId));
    }

    public synchronized EventBus triggerSync(AppEventId eventId) {
        return this.emitSync(eventId);
    }

    public synchronized EventBus emitSync(AppEvent event) {
        if (this.isDestroyed()) {
            return this;
        }
        this.callOn(event, this.asyncAppEventListeners, false);
        this.callOn(event, this.appEventListeners, false);
        return this;
    }

    public synchronized EventBus triggerSync(AppEvent event) {
        return this.emitSync(event);
    }

    public synchronized EventBus emitSync(ActEvent event) {
        if (this.isDestroyed()) {
            return this;
        }
        this.callOn(event, this.asyncActEventListeners, false);
        this.callOn(event, this.actEventListeners, false);
        boolean isSystemEvent = event instanceof SystemEvent;
        if (!isSystemEvent) {
            Object payload = event.source();
            if (null != payload) {
                this.emitSync(payload.getClass(), payload);
            }
            this.emitSync(event.getClass(), event);
        }
        if (null != this.onceBus) {
            this.onceBus.triggerSync(event);
        }
        return this;
    }

    public EventBus triggerSync(ActEvent event) {
        return this.emitSync(event);
    }

    public EventBus emit(ActEvent event) {
        if (this.isDestroyed()) {
            return this;
        }
        this.callOn(event, this.asyncActEventListeners, true);
        this.callOn(event, this.actEventListeners, false);
        boolean isSystemEvent = event instanceof SystemEvent;
        if (!isSystemEvent) {
            Object payload = event.source();
            if (null != payload) {
                this.emit(payload.getClass(), payload);
            }
            this.emit(event.getClass(), event);
        }
        if (null != this.onceBus) {
            this.onceBus.trigger(event);
        }
        return this;
    }

    public EventBus trigger(ActEvent event) {
        return this.emit(event);
    }

    public EventBus emitAsync(ActEvent event) {
        if (this.isDestroyed()) {
            return this;
        }
        this.callOn(event, this.asyncActEventListeners, true);
        this.callOn(event, this.actEventListeners, true);
        boolean isSystemEvent = event instanceof SystemEvent;
        if (!isSystemEvent) {
            Object payload = event.source();
            if (null != payload) {
                this.emitAsync(payload.getClass(), payload);
            }
            this.emitAsync(event.getClass(), event);
        }
        if (null != this.onceBus) {
            this.onceBus.triggerAsync(event);
        }
        return this;
    }

    public EventBus triggerAsync(ActEvent event) {
        return this.emitAsync(event);
    }

    private EventBus _bind(ConcurrentMap<Object, List<SimpleEventListener>> listeners, Object event, SimpleEventListener l) {
        ArrayList<SimpleEventListener> list = (ArrayList<SimpleEventListener>)listeners.get(event);
        if (null == list) {
            list = new ArrayList<SimpleEventListener>();
            listeners.putIfAbsent(event, list);
        }
        if (!list.contains(l)) {
            list.add(l);
        }
        return this;
    }

    public EventBus bind(Object event, SimpleEventListener l) {
        boolean async = event instanceof Class && EventBus.isAsync((Class)event);
        async = async || l instanceof ReflectedSimpleEventListener && ((ReflectedSimpleEventListener)l).isAsync();
        return this._bind(async ? this.asyncAdhocEventListeners : this.adhocEventListeners, event, l);
    }

    public EventBus bindAsync(Object event, SimpleEventListener l) {
        return this._bind(this.asyncAdhocEventListeners, event, l);
    }

    private void callOn(Object e, SimpleEventListener l, Object ... args) {
        try {
            l.invoke(args);
        }
        catch (Result r) {
            throw r;
        }
        catch (Exception x) {
            App.LOGGER.error((Throwable)x, "Error executing event listener");
        }
    }

    private boolean callOn(Object event, List<? extends SimpleEventListener> listeners, boolean async, final Object ... args) {
        boolean hasListener;
        if (null == listeners) {
            return false;
        }
        AppJobManager jobManager = null;
        if (async) {
            jobManager = this.app().jobManager();
        }
        boolean bl = hasListener = !listeners.isEmpty();
        if (!hasListener) {
            return false;
        }
        listeners = C.list(listeners);
        for (final SimpleEventListener l : listeners) {
            if (!async) {
                this.callOn(event, l, args);
                continue;
            }
            jobManager.now(new Runnable(){

                @Override
                public void run() {
                    l.invoke(args);
                }
            });
        }
        return true;
    }

    public void emit(Enum<?> event, Object ... args) {
        this.emit(event.name(), args);
    }

    public void emit(Object event, Object ... args) {
        this._emit(false, true, event, args);
    }

    public void emitSync(Object event, Object ... args) {
        this._emit(false, false, event, args);
    }

    public void emitAsync(Object event, Object ... args) {
        this._emit(true, true, event, args);
    }

    private void _emit(boolean async1, boolean async2, Object event, Object ... args) {
        boolean hit = this.callOn(event, (List)this.adhocEventListeners.get(event), async1, args);
        boolean bl = hit = this.callOn(event, (List)this.asyncAdhocEventListeners.get(event), async2, args) || hit;
        if (!hit && 0 == args.length) {
            this._emit(async1, async2, event.getClass(), event);
        }
        if (null != this.onceBus) {
            this.onceBus._emit(async1, async2, event, args);
        }
    }

    public void trigger(Object event, Object ... args) {
        this.emit(event, args);
    }

    public void triggerAsync(Object event, Object ... args) {
        this.emitAsync(event, args);
    }

    private ConcurrentMap<AppEventId, AppEvent> initAppEventLookup(App app) {
        ConcurrentHashMap<AppEventId, AppEvent> map = new ConcurrentHashMap<AppEventId, AppEvent>();
        for (AppEventId id : AppEventId.values()) {
            map.put(id, id.of(app));
        }
        return map;
    }

    private List[] initAppListenerArray() {
        AppEventId[] ids = AppEventId.values();
        int len = ids.length;
        List[] l = new List[len];
        for (int i = 0; i < len; ++i) {
            l[i] = C.newList();
        }
        return l;
    }

    private void releaseAppEventListeners(List[] array) {
        for (List l : array) {
            Destroyable.Util.destroyAll(l, ApplicationScoped.class);
            l.clear();
        }
    }

    private void releaseActEventListeners(Map<?, List<ActEventListener>> listeners) {
        for (List<ActEventListener> l : listeners.values()) {
            Destroyable.Util.destroyAll(l, ApplicationScoped.class);
            l.clear();
        }
        listeners.clear();
    }

    private void releaseAdhocEventListeners(Map<Object, List<SimpleEventListener>> listeners) {
        for (List<SimpleEventListener> l : listeners.values()) {
            Destroyable.Util.tryDestroyAll(l, ApplicationScoped.class);
            l.clear();
        }
        listeners.clear();
    }

    public void loadDefaultEventListeners() {
        this.loadDiBinderListener();
    }

    private void loadDiBinderListener() {
        this.bind(DependencyInjectionBinder.class, new ActEventListenerBase<DependencyInjectionBinder>(){

            @Override
            public void on(DependencyInjectionBinder event) throws Exception {
                Object injector = EventBus.this.app().injector();
                if (null == injector) {
                    App.LOGGER.warn("Dependency injector not found");
                } else {
                    injector.registerDiBinder(event);
                }
            }
        });
    }
}

