/*
 * Decompiled with CFR 0.152.
 */
package act.event.bytecode;

import act.app.AppByteCodeScannerBase;
import act.app.event.AppEventId;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.event.EventBus;
import act.event.On;
import act.event.OnClass;
import act.event.OnEvent;
import act.event.SimpleEventListener;
import act.event.bytecode.ReflectedSimpleEventListener;
import act.event.meta.SimpleEventListenerMetaInfo;
import act.job.AppJobManager;
import act.util.AsmTypes;
import act.util.Async;
import act.util.ByteCodeVisitor;
import java.lang.annotation.Annotation;
import java.util.List;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.S;

public class SimpleEventListenerByteCodeScanner
extends AppByteCodeScannerBase {
    private List<SimpleEventListenerMetaInfo> metaInfoList = C.newList();

    @Override
    protected void reset(String className) {
        this.metaInfoList.clear();
    }

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
        if (!this.metaInfoList.isEmpty()) {
            final EventBus eventBus = this.app().eventBus();
            AppJobManager jobManager = this.app().jobManager();
            for (final SimpleEventListenerMetaInfo metaInfo : this.metaInfoList) {
                jobManager.on(AppEventId.PRE_START, new Runnable(){

                    @Override
                    public void run() {
                        for (Object event : metaInfo.events()) {
                            boolean isStatic = metaInfo.isStatic();
                            if (metaInfo.isAsync()) {
                                eventBus.bindAsync(event, new ReflectedSimpleEventListener(metaInfo.className(), metaInfo.methodName(), metaInfo.paramTypes(), isStatic));
                                continue;
                            }
                            eventBus.bind(event, new ReflectedSimpleEventListener(metaInfo.className(), metaInfo.methodName(), metaInfo.paramTypes(), isStatic));
                        }
                    }
                });
            }
        }
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private String className;

        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = Type.getObjectType((String)name).getClassName();
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            Type returnType = Type.getReturnType((String)desc);
            final boolean isVoid = "V".equals(returnType.toString());
            final boolean isPublicNotAbstract = AsmTypes.isPublicNotAbstract(access);
            Type[] arguments = Type.getArgumentTypes((String)desc);
            C.List paramTypes = C.newList();
            if (null != arguments) {
                for (Type type : arguments) {
                    paramTypes.add(type.getClassName());
                }
            }
            final String methodName = name;
            boolean isStatic = AsmTypes.isStatic(access);
            return new MethodVisitor(327680, mv, (List)paramTypes, isStatic){
                private List<Object> events;
                private List<Osgl.Func0> delayedEvents;
                private boolean isOnEvent;
                private boolean isAsync;
                private String asyncMethodName;
                final /* synthetic */ List val$paramTypes;
                final /* synthetic */ boolean val$isStatic;
                {
                    this.val$paramTypes = list;
                    this.val$isStatic = bl3;
                    super(x0, x1);
                    this.events = C.newList();
                    this.delayedEvents = C.newList();
                    this.isOnEvent = false;
                    this.asyncMethodName = null;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor av = super.visitAnnotation(desc, visible);
                    String className = Type.getType((String)desc).getClassName();
                    final boolean isOn = On.class.getName().equals(className);
                    boolean isOnC = OnClass.class.getName().equals(className);
                    boolean isOnE = OnEvent.class.getName().equals(className);
                    if (isOnE) {
                        this.isOnEvent = true;
                    }
                    boolean isCustomMarker = false;
                    if (!(isOn || isOnC || isOnE)) {
                        Annotation[] annotations;
                        Class clz = $.classForName((String)className);
                        for (Annotation annotation : annotations = clz.getAnnotations()) {
                            if (!SimpleEventListener.Marker.class.getCanonicalName().equals(annotation.annotationType().getCanonicalName())) continue;
                            isCustomMarker = true;
                            break;
                        }
                    }
                    if (isOnE || isOn || isOnC || isCustomMarker) {
                        return new AnnotationVisitor(327680, av){

                            public AnnotationVisitor visitArray(String name) {
                                AnnotationVisitor av0 = super.visitArray(name);
                                if ("value".equals(name)) {
                                    return new AnnotationVisitor(327680, av0){

                                        public void visit(String name, Object value) {
                                            super.visit(name, value);
                                            if (isOn) {
                                                events.add(S.string((Object)value).intern());
                                            } else {
                                                Type type = (Type)value;
                                                Class c = $.classForName((String)type.getClassName(), (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader());
                                                events.add(c);
                                            }
                                        }

                                        public void visitEnum(String name, String desc, final String value) {
                                            final String enumClassName = Type.getType((String)desc).getClassName();
                                            delayedEvents.add(new Osgl.Func0(){

                                                public Object apply() throws NotAppliedException, Osgl.Break {
                                                    Class enumClass = $.classForName((String)enumClassName, (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader());
                                                    return Enum.valueOf(enumClass, value);
                                                }
                                            });
                                            super.visitEnum(name, desc, value);
                                        }
                                    };
                                }
                                return av0;
                            }

                            public void visit(String name, Object value) {
                                if ("async".equals(name)) {
                                    isAsync = Boolean.parseBoolean(S.string((Object)value));
                                }
                            }

                            public void visitEnum(String name, String desc, final String value) {
                                if ("value".equals(name)) {
                                    final String enumClassName = Type.getType((String)desc).getClassName();
                                    delayedEvents.add(new Osgl.Func0(){

                                        public Object apply() throws NotAppliedException, Osgl.Break {
                                            Class enumClass = $.classForName((String)enumClassName, (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader());
                                            return Enum.valueOf(enumClass, value);
                                        }
                                    });
                                }
                                super.visitEnum(name, desc, value);
                            }
                        };
                    }
                    if (Async.class.getName().equals(className)) {
                        if (!isVoid) {
                            logger.warn("Error found in method %s.%s: @Async annotation cannot be used with method that has return type", new Object[]{className, methodName});
                        } else if (!isPublicNotAbstract) {
                            logger.warn("Error found in method %s.%s: @Async annotation cannot be used with method that are not public or abstract method", new Object[]{className, methodName});
                        } else {
                            this.asyncMethodName = Async.MethodNameTransformer.transform(methodName);
                        }
                        return av;
                    }
                    return av;
                }

                public void visitEnd() {
                    if (this.isOnEvent) {
                        if (this.val$paramTypes.isEmpty()) {
                            logger.warn("@OnEvent annotation shall be put on a method with exactly one event object (optionally with other injectable arguments");
                        } else {
                            String type = (String)this.val$paramTypes.get(0);
                            this.events.add($.classForName((String)type, (ClassLoader)SimpleEventListenerByteCodeScanner.this.app().classLoader()));
                        }
                    }
                    if (!this.events.isEmpty() || !this.delayedEvents.isEmpty()) {
                        SimpleEventListenerMetaInfo metaInfo = new SimpleEventListenerMetaInfo(this.events, this.delayedEvents, _ByteCodeVisitor.this.className, methodName, this.asyncMethodName, this.val$paramTypes, this.isAsync, this.val$isStatic, SimpleEventListenerByteCodeScanner.this.app());
                        SimpleEventListenerByteCodeScanner.this.metaInfoList.add(metaInfo);
                    }
                    super.visitEnd();
                }
            };
        }
    }
}

