/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.app.ActionContext;
import act.handler.ExpressHandler;
import act.handler.builtin.controller.FastRequestHandler;
import java.nio.ByteBuffer;
import org.osgl.http.H;
import org.osgl.util.Charsets;
import org.osgl.util.S;

public class Echo
extends FastRequestHandler
implements ExpressHandler {
    private ByteBuffer buffer;
    private String toString;
    private String contentType;

    public Echo(String msg) {
        this(msg, H.Format.TXT.contentType());
    }

    public Echo(String msg, String contentType) {
        this.buffer = this.wrap(msg);
        this.contentType = contentType;
        this.toString = "echo: " + msg;
    }

    @Override
    public void handle(ActionContext context) {
        H.Response resp = context.resp();
        if (S.notBlank((String)this.contentType)) {
            resp.contentType(this.contentType);
        }
        resp.writeContent(this.buffer.duplicate());
    }

    public String readContent() {
        ByteBuffer copy = this.buffer.duplicate();
        byte[] bytes = new byte[copy.remaining()];
        copy.get(bytes);
        return new String(bytes);
    }

    public String toString() {
        return this.toString;
    }

    private ByteBuffer wrap(String content) {
        byte[] ba = content.getBytes(Charsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocateDirect(ba.length);
        buffer.put(ba);
        buffer.flip();
        return buffer;
    }
}

