/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.app.ActionContext;
import act.app.App;
import act.handler.builtin.AlwaysForbidden;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.controller.FastRequestHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.osgl.http.H;
import org.osgl.util.E;
import org.osgl.util.FastStr;
import org.osgl.util.IO;
import org.osgl.util.S;

public class StaticFileGetter
extends FastRequestHandler {
    private File base;

    public StaticFileGetter(String base, App app) {
        E.NPE((Object)base);
        this.base = app.file(base);
    }

    public StaticFileGetter(File base) {
        E.NPE((Object)base);
        this.base = base;
    }

    @Override
    protected void releaseResources() {
        this.base = null;
    }

    @Override
    public void handle(ActionContext context) {
        context.handler(this);
        File file = this.base;
        if (!file.exists()) {
            AlwaysNotFound.INSTANCE.handle(context);
            return;
        }
        if (this.base.isDirectory()) {
            String path = context.paramVal("__path");
            if (S.blank((String)path)) {
                AlwaysForbidden.INSTANCE.handle(context);
                return;
            }
            file = new File(this.base, path);
            if (!file.exists()) {
                AlwaysNotFound.INSTANCE.handle(context);
                return;
            }
            if (file.isDirectory() || !file.canRead()) {
                AlwaysForbidden.INSTANCE.handle(context);
                return;
            }
        }
        H.Response resp = context.resp();
        H.Format fmt = StaticFileGetter.contentType(file.getPath());
        resp.contentType(fmt.contentType());
        BufferedInputStream is = new BufferedInputStream(IO.is((File)file));
        IO.copy((InputStream)is, (OutputStream)context.resp().outputStream());
    }

    public File base() {
        return this.base;
    }

    static H.Format contentType(String path) {
        H.Format retVal = null;
        if (path.contains(".")) {
            FastStr s = FastStr.unsafeOf((String)path).afterLast('.');
            retVal = H.Format.of((String)s.toString());
        }
        return null == retVal ? H.Format.BINARY : retVal;
    }

    @Override
    public boolean supportPartialPath() {
        return this.base.isDirectory();
    }

    public String toString() {
        boolean dir = this.supportPartialPath();
        return "file: " + (dir ? this.base().getPath() + "/**" : this.base().getPath());
    }
}

