/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.handler.builtin.AlwaysForbidden;
import act.handler.builtin.AlwaysNotFound;
import act.handler.builtin.AlwaysNotModified;
import act.handler.builtin.StaticFileGetter;
import act.handler.builtin.controller.FastRequestHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.mvc.result.NotFound;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class StaticResourceGetter
extends FastRequestHandler {
    private static final char SEP = '/';
    private String base;
    private URL baseUrl;
    private int preloadSizeLimit;
    private boolean isFolder;
    private ByteBuffer buffer;
    private H.Format contentType;
    private boolean preloadFailure;
    private boolean preloaded;
    private String etag;
    private Set<URL> folders = new HashSet<URL>();
    private Map<String, String> etags = new HashMap<String, String>();
    private Map<String, ByteBuffer> cachedBuffers = new HashMap<String, ByteBuffer>();
    private Map<String, String> cachedContentType = new HashMap<String, String>();
    private Map<String, Boolean> cachedFailures = new HashMap<String, Boolean>();

    public StaticResourceGetter(String base) {
        String path;
        this.base = path = S.ensureStartsWith((String)base, (char)'/');
        this.baseUrl = StaticFileGetter.class.getResource(path);
        E.illegalArgumentIf((null == this.baseUrl ? 1 : 0) != 0, (String)"Cannot find base URL: %s", (Object[])new Object[]{base});
        this.isFolder = this.isFolder(this.baseUrl, path);
        if (!this.isFolder && "file".equals(this.baseUrl.getProtocol())) {
            Act.jobManager().beforeAppStart(new Runnable(){

                @Override
                public void run() {
                    StaticResourceGetter.this.preloadCache();
                }
            });
        }
        this.preloadSizeLimit = Act.appConfig().resourcePreloadSizeLimit();
    }

    @Override
    protected void releaseResources() {
    }

    @Override
    public boolean express(ActionContext context) {
        if (this.preloaded) {
            return true;
        }
        String path = context.paramVal("__path");
        return Act.isProd() && (this.cachedBuffers.containsKey(path) || this.cachedFailures.containsKey(path) || null != context.req().etag() && context.req().etagMatches(this.etags.get(path)));
    }

    @Override
    public void handle(ActionContext context) {
        context.handler(this);
        String path = context.paramVal("__path");
        this.handle(path, context);
    }

    protected void handle(String path, ActionContext context) {
        block18: {
            ByteBuffer buffer;
            H.Request req = context.req();
            if (Act.isProd()) {
                if (this.preloaded) {
                    if (this.preloadFailure) {
                        AlwaysNotFound.INSTANCE.handle(context);
                    } else if (req.etagMatches(this.etag)) {
                        AlwaysNotModified.INSTANCE.handle(context);
                    } else {
                        H.Response resp = context.resp();
                        resp.contentType(this.contentType.contentType()).etag(this.etag).writeContent(this.buffer.duplicate());
                    }
                    return;
                }
                if (this.cachedFailures.containsKey(path)) {
                    AlwaysNotFound.INSTANCE.handle(context);
                    return;
                }
                if (null != req.etag() && req.etagMatches(this.etags.get(path))) {
                    AlwaysNotModified.INSTANCE.handle(context);
                    return;
                }
            }
            if (null != (buffer = this.cachedBuffers.get(path))) {
                context.resp().contentType(this.cachedContentType.get(path)).etag(this.etags.get(path)).writeContent(buffer.duplicate());
                return;
            }
            try {
                URL target;
                String loadPath = path;
                if (S.blank((String)path)) {
                    target = this.baseUrl;
                    loadPath = this.base;
                } else {
                    loadPath = S.pathConcat((String)this.base, (char)'/', (String)path);
                    target = StaticFileGetter.class.getResource(loadPath);
                    if (null == target) {
                        throw NotFound.get();
                    }
                }
                if (this.preventFolderAccess(target, loadPath, context)) {
                    return;
                }
                H.Format fmt = StaticFileGetter.contentType(target.getPath());
                H.Response resp = context.resp();
                resp.contentType(fmt.contentType());
                try {
                    int n = IO.copy((InputStream)target.openStream(), (OutputStream)resp.outputStream());
                    if (!Act.isProd()) break block18;
                    this.etags.put(path, String.valueOf(n));
                    if (n >= context.config().resourcePreloadSizeLimit()) break block18;
                    Osgl.Var etagBag = $.var();
                    buffer = this.doPreload(target, (Osgl.Var<String>)etagBag);
                    if (null == buffer) {
                        this.cachedFailures.put(path, true);
                        break block18;
                    }
                    this.cachedBuffers.put(path, buffer);
                    this.cachedContentType.put(path, fmt.contentType());
                }
                catch (NullPointerException e) {
                    this.folders.add(target);
                    AlwaysForbidden.INSTANCE.handle(context);
                }
            }
            catch (IOException e) {
                App.logger.warn((Throwable)e, "Error servicing static resource request");
                throw NotFound.get();
            }
        }
    }

    private boolean preventFolderAccess(URL target, String path, ActionContext context) {
        if (this.folders.contains(target)) {
            AlwaysForbidden.INSTANCE.handle(context);
            return true;
        }
        if (this.isFolder(target, path)) {
            this.folders.add(target);
            AlwaysForbidden.INSTANCE.handle(context);
            return true;
        }
        return false;
    }

    private boolean isFolder(URL target, String path) {
        if ("file".equals(target.getProtocol())) {
            File file = new File(target.getFile());
            return file.isDirectory();
        }
        if ("jar".equals(target.getProtocol())) {
            if (path.endsWith("/")) {
                return true;
            }
            URL url = StaticFileGetter.class.getResource(S.ensureEndsWith((String)path, (String)"/"));
            return null != url;
        }
        return false;
    }

    private void preloadCache() {
        if (Act.isDev()) {
            return;
        }
        this.contentType = StaticFileGetter.contentType(this.baseUrl.getPath());
        if (H.Format.HTML == this.contentType || H.Format.CSS == this.contentType || H.Format.JAVASCRIPT == this.contentType || H.Format.TXT == this.contentType || H.Format.CSV == this.contentType || H.Format.JSON == this.contentType || H.Format.XML == this.contentType || this.resourceSizeIsOkay()) {
            Osgl.Var etagBag = $.var();
            this.buffer = this.doPreload(this.baseUrl, (Osgl.Var<String>)etagBag);
            if (null == this.buffer) {
                this.preloadFailure = true;
            } else {
                this.etag = (String)etagBag.get();
            }
            this.preloaded = true;
        }
    }

    private ByteBuffer doPreload(URL target, Osgl.Var<String> etagBag) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IO.copy((InputStream)target.openStream(), (OutputStream)baos);
            byte[] ba = baos.toByteArray();
            this.buffer = ByteBuffer.wrap(ba);
            etagBag.set((Object)String.valueOf(Arrays.hashCode(ba)));
            return this.buffer;
        }
        catch (IOException e) {
            Act.LOGGER.warn((Throwable)e, "Error loading resource: %s", new Object[]{this.baseUrl.getPath()});
            return null;
        }
    }

    private boolean resourceSizeIsOkay() {
        if (this.preloadSizeLimit <= 0) {
            return false;
        }
        if ("file".equals(this.baseUrl.getProtocol())) {
            File file = new File(this.baseUrl.getFile());
            return file.length() < (long)this.preloadSizeLimit;
        }
        return false;
    }

    @Override
    public boolean supportPartialPath() {
        return this.isFolder;
    }

    public String toString() {
        return this.baseUrl.toString();
    }
}

