/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin;

import act.Act;
import act.app.ActionContext;
import act.conf.AppConfig;
import act.handler.ExpressHandler;
import act.handler.UnknownHttpMethodProcessor;
import act.handler.builtin.controller.FastRequestHandler;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.view.ActErrorResult;
import java.io.Serializable;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;

public class UnknownHttpMethodHandler
extends FastRequestHandler
implements Serializable {
    private static Logger logger = LogManager.get(UnknownHttpMethodHandler.class);
    public static final UnknownHttpMethodHandler INSTANCE = new UnknownHttpMethodHandler();
    private volatile UnknownHttpMethodProcessor configured;

    @Override
    public void handle(ActionContext context) {
        H.Method method = context.req().method();
        Result result = this.configured(context.config()).handle(method);
        try {
            result = RequestHandlerProxy.GLOBAL_AFTER_INTERCEPTOR.apply(result, context);
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Error calling global after interceptor");
            result = ActErrorResult.of(e);
        }
        result.apply(context.req(), context.resp());
    }

    @Override
    public boolean express(ActionContext context) {
        return this.configured(null) instanceof ExpressHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnknownHttpMethodProcessor configured(AppConfig config) {
        if (null == this.configured) {
            UnknownHttpMethodHandler unknownHttpMethodHandler = this;
            synchronized (unknownHttpMethodHandler) {
                if (null == this.configured) {
                    if (null == config) {
                        config = Act.appConfig();
                    }
                    this.configured = config.unknownHttpMethodProcessor();
                }
            }
        }
        return this.configured;
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

