/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin.cli;

import act.Act;
import act.app.App;
import act.cli.CliContext;
import act.cli.CliException;
import act.cli.CommandExecutor;
import act.cli.bytecode.ReflectedCommandExecutor;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.meta.CommanderClassMetaInfo;
import act.handler.CliHandlerBase;
import act.util.PropertySpec;
import java.util.List;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public final class CliHandlerProxy
extends CliHandlerBase {
    private static Logger logger = L.get(CliHandlerProxy.class);
    private App app;
    private CommandMethodMetaInfo methodMetaInfo;
    private CommanderClassMetaInfo classMetaInfo;
    private volatile CommandExecutor executor = null;

    public CliHandlerProxy(CommanderClassMetaInfo classMetaInfo, CommandMethodMetaInfo metaInfo, App app) {
        this.methodMetaInfo = (CommandMethodMetaInfo)$.notNull((Object)metaInfo);
        this.classMetaInfo = (CommanderClassMetaInfo)$.notNull((Object)classMetaInfo);
        this.app = (App)$.notNull((Object)app);
    }

    @Override
    protected void releaseResources() {
        if (null != this.executor) {
            this.executor.destroy();
            this.executor = null;
        }
    }

    public CommandMethodMetaInfo methodMetaInfo() {
        return this.methodMetaInfo;
    }

    public CommanderClassMetaInfo classMetaInfo() {
        return this.classMetaInfo;
    }

    @Override
    public boolean appliedIn(Act.Mode mode) {
        return mode == Act.Mode.DEV || mode == this.methodMetaInfo.mode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(CliContext context) {
        try {
            this.ensureAgentsReady();
            this.saveCommandPath(context);
            Object result = this._handle(context);
            this.onResult(result, context);
        }
        catch (Osgl.Break b) {
            throw b;
        }
        catch (CliException error) {
            context.println(error.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (S.blank((String)msg)) {
                msg = S.fmt((String)"Error processing command: %s", (Object[])new Object[]{e});
            }
            context.println(msg, new Object[0]);
            logger.error((Throwable)e, "Error handling request");
        }
        finally {
            PropertySpec.current.remove();
        }
    }

    @Override
    public Osgl.T2<String, String> commandLine() {
        return this.methodMetaInfo.commandLine(this.classMetaInfo, this.app.classLoader());
    }

    @Override
    public List<Osgl.T2<String, String>> options() {
        return this.methodMetaInfo.options(this.classMetaInfo, this.app.classLoader());
    }

    private void onResult(Object result, CliContext context) {
        if (null == result) {
            return;
        }
        PropertySpec.MetaInfo filter = this.methodMetaInfo.propertySpec();
        this.methodMetaInfo.view().print(result, filter, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAgentsReady() {
        if (null == this.executor) {
            CliHandlerProxy cliHandlerProxy = this;
            synchronized (cliHandlerProxy) {
                if (null == this.executor) {
                    this.generateExecutor();
                }
            }
        }
    }

    private void saveCommandPath(CliContext context) {
        context.commandPath(this.methodMetaInfo.fullName());
    }

    private void generateExecutor() {
        this.executor = new ReflectedCommandExecutor(this.methodMetaInfo, this.app);
    }

    private Object _handle(CliContext context) {
        return this.executor.execute(context);
    }

    public String toString() {
        return this.methodMetaInfo.fullName();
    }

    public int hashCode() {
        return $.hc((Object)this.methodMetaInfo);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CliHandlerProxy) {
            CliHandlerProxy that = (CliHandlerProxy)obj;
            return $.eq((Object)that.methodMetaInfo, (Object)this.methodMetaInfo);
        }
        return false;
    }
}

