/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin.controller;

import act.Act;
import act.Destroyable;
import act.app.ActionContext;
import act.app.App;
import act.app.AppInterceptorManager;
import act.app.event.AppEventId;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.handler.RequestHandlerBase;
import act.handler.builtin.controller.ActionHandler;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.Handler;
import act.security.CORS;
import act.security.CSRF;
import act.util.AnnotatedClassFinder;
import act.util.Global;
import act.view.ActErrorResult;
import act.view.RenderAny;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.cache.CacheService;
import org.osgl.http.H;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@ApplicationScoped
public final class RequestHandlerProxy
extends RequestHandlerBase {
    private static Logger logger = L.get(RequestHandlerProxy.class);
    private static final C.List<BeforeInterceptor> globalBeforeInterceptors = C.newList();
    private static final C.List<AfterInterceptor> globalAfterInterceptors = C.newList();
    private static final C.List<FinallyInterceptor> globalFinallyInterceptors = C.newList();
    private static final C.List<ExceptionInterceptor> globalExceptionInterceptors = C.newList();
    public static final GroupInterceptorWithResult GLOBAL_BEFORE_INTERCEPTOR = new GroupInterceptorWithResult(globalBeforeInterceptors);
    public static final GroupAfterInterceptor GLOBAL_AFTER_INTERCEPTOR = new GroupAfterInterceptor(globalAfterInterceptors);
    public static final GroupFinallyInterceptor GLOBAL_FINALLY_INTERCEPTOR = new GroupFinallyInterceptor(globalFinallyInterceptors);
    public static final GroupExceptionInterceptor GLOBAL_EXCEPTION_INTERCEPTOR = new GroupExceptionInterceptor(globalExceptionInterceptors);
    private App app;
    private AppInterceptorManager appInterceptor;
    private CacheService cache;
    private CacheStrategy cacheStrategy = CacheStrategy.NO_CACHE;
    private String controllerClassName;
    private String actionMethodName;
    private String actionPath;
    private volatile ControllerAction actionHandler = null;
    private C.List<BeforeInterceptor> beforeInterceptors = C.newList();
    private C.List<AfterInterceptor> afterInterceptors = C.newList();
    private C.List<ExceptionInterceptor> exceptionInterceptors = C.newList();
    private C.List<FinallyInterceptor> finallyInterceptors = C.newList();
    private boolean sessionFree;
    private boolean express;
    final GroupInterceptorWithResult BEFORE_INTERCEPTOR = new GroupInterceptorWithResult(this.beforeInterceptors);
    final GroupAfterInterceptor AFTER_INTERCEPTOR = new GroupAfterInterceptor(this.afterInterceptors);
    final GroupFinallyInterceptor FINALLY_INTERCEPTOR = new GroupFinallyInterceptor(this.finallyInterceptors);
    final GroupExceptionInterceptor EXCEPTION_INTERCEPTOR = new GroupExceptionInterceptor(this.exceptionInterceptors);

    @Inject
    public RequestHandlerProxy(String actionMethodName, App app) {
        int pos = actionMethodName.lastIndexOf(46);
        String ERR = "Invalid controller action: %s";
        E.illegalArgumentIf((pos < 0 ? 1 : 0) != 0, (String)"Invalid controller action: %s", (Object[])new Object[]{actionMethodName});
        this.controllerClassName = actionMethodName.substring(0, pos);
        E.illegalArgumentIf((boolean)S.isEmpty((String)this.controllerClassName), (String)"Invalid controller action: %s", (Object[])new Object[]{actionMethodName});
        this.actionMethodName = actionMethodName.substring(pos + 1);
        E.illegalArgumentIf((boolean)S.isEmpty((String)this.actionMethodName), (String)"Invalid controller action: %s", (Object[])new Object[]{actionMethodName});
        this.actionPath = actionMethodName;
        this.cache = app.config().cacheService("action_proxy");
        this.app = app;
        this.appInterceptor = app.interceptorManager();
    }

    @Override
    protected void releaseResources() {
        RequestHandlerProxy._releaseResourceCollections(this.afterInterceptors);
        RequestHandlerProxy._releaseResourceCollections(this.beforeInterceptors);
        RequestHandlerProxy._releaseResourceCollections(this.exceptionInterceptors);
        RequestHandlerProxy._releaseResourceCollections(this.finallyInterceptors);
        if (null != this.actionHandler) {
            this.actionHandler.destroy();
            this.actionHandler = null;
        }
        RequestHandlerProxy.releaseGlobalResources();
    }

    public static void releaseGlobalResources() {
        RequestHandlerProxy._releaseResourceCollections(globalAfterInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalBeforeInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalExceptionInterceptors);
        RequestHandlerProxy._releaseResourceCollections(globalFinallyInterceptors);
    }

    private static void _releaseResourceCollections(Collection<? extends Destroyable> col) {
        Destroyable.Util.destroyAll(col, null);
        col.clear();
    }

    public String controller() {
        return this.controllerClassName;
    }

    public String action() {
        return this.actionMethodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(ActionContext context) {
        Result result = this.cacheStrategy.cached(context, this.cache);
        try {
            if (null != result) {
                this.onResult(result, context);
                return;
            }
            this.ensureAgentsReady();
            this.saveActionPath(context);
            context.startIntercepting();
            result = this.handleBefore(context);
            if (null == result) {
                context.startHandling();
                result = this._handle(context);
            }
            context.startIntercepting();
            Result afterResult = this.handleAfter(result, context);
            if (null != afterResult) {
                result = afterResult;
            }
            if (null == result) {
                result = context.nullValueResult();
            }
            this.onResult(result, context);
            return;
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Error handling request");
            try {
                result = this.handleException(e, context);
            }
            catch (Exception e0) {
                logger.error((Throwable)e0, "Error invoking exception handler");
            }
            if (null == result) {
                result = ActErrorResult.of(e);
            }
            try {
                this.onResult(result, context);
                return;
            }
            catch (Exception e2) {
                logger.error((Throwable)e2, "error rendering exception handle  result");
                this.onResult(ActErrorResult.of(e2), context);
                return;
            }
        }
        finally {
            try {
                this.handleFinally(context);
            }
            catch (Exception e) {
                logger.error((Throwable)e, "Error invoking final handler");
            }
            finally {
                context.destroy();
            }
        }
    }

    @Override
    public boolean sessionFree() {
        this.ensureAgentsReady();
        return this.sessionFree;
    }

    @Override
    public boolean express(ActionContext context) {
        return this.express;
    }

    protected final void useSessionCache() {
        this.cacheStrategy = CacheStrategy.SESSION_SCOPED;
    }

    protected final void useGlobalCache() {
        this.cacheStrategy = CacheStrategy.GLOBAL_SCOPED;
    }

    protected final void registerBeforeInterceptor(BeforeInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.beforeInterceptors, interceptor);
    }

    protected final void registerAfterInterceptor(AfterInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.afterInterceptors, interceptor);
    }

    protected final void registerExceptionInterceptor(ExceptionInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.exceptionInterceptors, interceptor);
    }

    protected final void registerFinallyInterceptor(FinallyInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(this.finallyInterceptors, interceptor);
    }

    private void onResult(Result result, ActionContext context) {
        context.dissolve();
        boolean isRenderAny = false;
        try {
            if (result instanceof RenderAny) {
                RenderAny any = (RenderAny)result;
                isRenderAny = true;
                any.apply(context);
            } else {
                H.Request req = context.req();
                H.Response resp = context.resp();
                result.apply(req, resp);
            }
        }
        catch (RuntimeException e) {
            context.cacheTemplate(null);
            throw e;
        }
        finally {
            if (isRenderAny) {
                RenderAny.clearThreadLocals();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAgentsReady() {
        if (null == this.actionHandler) {
            RequestHandlerProxy requestHandlerProxy = this;
            synchronized (requestHandlerProxy) {
                if (null == this.actionHandler) {
                    this.generateHandlers();
                }
            }
        }
    }

    private void saveActionPath(ActionContext context) {
        context.actionPath(this.actionPath);
    }

    private boolean matches(String actionMethodName, Set<String> patterns) {
        if (patterns.contains(actionMethodName)) {
            return true;
        }
        for (String s : patterns) {
            if (!Pattern.compile(s).matcher(actionMethodName).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean applied(InterceptorMethodMetaInfo interceptor) {
        Set<String> blackList = interceptor.blackList();
        if (!blackList.isEmpty()) {
            return !this.matches(this.actionMethodName, blackList);
        }
        Set<String> whiteList = interceptor.whiteList();
        if (!whiteList.isEmpty()) {
            return this.matches(this.actionMethodName, whiteList);
        }
        return true;
    }

    private ActionMethodMetaInfo findActionInfoFromParent(ControllerClassMetaInfo ctrlInfo, String methodName) {
        ActionMethodMetaInfo actionInfo = null;
        ControllerClassMetaInfo parent = ctrlInfo.parent(true);
        while (null == (actionInfo = parent.action(methodName)) && null != (parent = parent.parent(true))) {
        }
        return new ActionMethodMetaInfo((ActionMethodMetaInfo)$.notNull((Object)actionInfo), ctrlInfo);
    }

    private void generateHandlers() {
        Handler interceptor;
        ControllerClassMetaInfo ctrlInfo = this.app.classLoader().controllerClassMetaInfo(this.controllerClassName);
        ActionMethodMetaInfo actionInfo = ctrlInfo.action(this.actionMethodName);
        if (null == actionInfo) {
            actionInfo = this.findActionInfoFromParent(ctrlInfo, this.actionMethodName);
        }
        Act.Mode mode = Act.mode();
        this.actionHandler = mode.createRequestHandler(actionInfo, this.app);
        this.sessionFree = this.actionHandler.sessionFree();
        this.express = this.actionHandler.express();
        App app = this.app;
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : ctrlInfo.beforeInterceptors()) {
            if (!this.applied(interceptorMethodMetaInfo)) continue;
            interceptor = mode.createBeforeInterceptor(interceptorMethodMetaInfo, app);
            this.beforeInterceptors.add((Object)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : ctrlInfo.afterInterceptors()) {
            if (!this.applied(interceptorMethodMetaInfo)) continue;
            interceptor = mode.createAfterInterceptor(interceptorMethodMetaInfo, app);
            this.afterInterceptors.add((Object)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
        for (CatchMethodMetaInfo catchMethodMetaInfo : ctrlInfo.exceptionInterceptors()) {
            if (!this.applied(catchMethodMetaInfo)) continue;
            interceptor = mode.createExceptionInterceptor(catchMethodMetaInfo, app);
            this.exceptionInterceptors.add((Object)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
        Collections.sort(this.exceptionInterceptors);
        for (InterceptorMethodMetaInfo interceptorMethodMetaInfo : ctrlInfo.finallyInterceptors()) {
            if (!this.applied(interceptorMethodMetaInfo)) continue;
            interceptor = mode.createFinallyInterceptor(interceptorMethodMetaInfo, app);
            this.finallyInterceptors.add((Object)interceptor);
            this.sessionFree = this.sessionFree && interceptor.sessionFree();
            this.express = this.express && interceptor.express();
        }
    }

    public void accept(Handler.Visitor visitor) {
        this.ensureAgentsReady();
        for (Handler i : globalBeforeInterceptors) {
            i.accept(visitor);
        }
        for (Handler i : this.beforeInterceptors) {
            i.accept(visitor);
        }
        this.actionHandler.accept(visitor);
        for (Handler i : this.afterInterceptors) {
            i.accept(visitor);
        }
        for (Handler i : globalAfterInterceptors) {
            i.accept(visitor);
        }
        for (Handler i : this.finallyInterceptors) {
            i.accept(visitor);
        }
        for (Handler i : globalFinallyInterceptors) {
            i.accept(visitor);
        }
        for (Handler i : this.exceptionInterceptors) {
            i.accept(visitor);
        }
        for (Handler i : globalExceptionInterceptors) {
            i.accept(visitor);
        }
    }

    @Override
    public CSRF.Spec csrfSpec() {
        this.ensureAgentsReady();
        return this.actionHandler.csrfSpec();
    }

    @Override
    public CORS.Spec corsSpec() {
        this.ensureAgentsReady();
        return this.actionHandler.corsSpec();
    }

    private Result handleBefore(ActionContext actionContext) throws Exception {
        Result r = GLOBAL_BEFORE_INTERCEPTOR.apply(actionContext);
        if (null == r) {
            r = this.appInterceptor.handleBefore(actionContext);
        }
        if (null == r) {
            r = this.BEFORE_INTERCEPTOR.apply(actionContext);
        }
        return r;
    }

    private Result _handle(ActionContext actionContext) throws Exception {
        try {
            return this.actionHandler.handle(actionContext);
        }
        catch (Result r) {
            return r;
        }
    }

    private Result handleAfter(Result result, ActionContext actionContext) throws Exception {
        result = this.AFTER_INTERCEPTOR.apply(result, actionContext);
        result = this.appInterceptor.handleAfter(result, actionContext);
        result = GLOBAL_AFTER_INTERCEPTOR.apply(result, actionContext);
        return result;
    }

    private void handleFinally(ActionContext actionContext) throws Exception {
        this.FINALLY_INTERCEPTOR.apply(actionContext);
        this.appInterceptor.handleFinally(actionContext);
        GLOBAL_FINALLY_INTERCEPTOR.apply(actionContext);
    }

    private Result handleException(Exception ex, ActionContext actionContext) throws Exception {
        Result r = this.EXCEPTION_INTERCEPTOR.apply(ex, actionContext);
        if (null == r) {
            r = this.appInterceptor.handleException(ex, actionContext);
        }
        if (null == r) {
            r = GLOBAL_EXCEPTION_INTERCEPTOR.apply(ex, actionContext);
        }
        return r;
    }

    public String toString() {
        return this.actionPath;
    }

    public static void registerGlobalInterceptor(BeforeInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalBeforeInterceptors, interceptor);
    }

    public static void registerGlobalInterceptor(AfterInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalAfterInterceptors, interceptor);
    }

    public static void registerGlobalInterceptor(FinallyInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalFinallyInterceptors, interceptor);
    }

    public static void registerGlobalInterceptor(ExceptionInterceptor interceptor) {
        RequestHandlerProxy.insertInterceptor(globalExceptionInterceptors, interceptor);
        Collections.sort(globalExceptionInterceptors);
    }

    @AnnotatedClassFinder(value=Global.class, callOn=AppEventId.PRE_START)
    public static void registerGlobalInterceptors(Class<?> interceptorClass) {
        App app = Act.app();
        if (BeforeInterceptor.class.isAssignableFrom(interceptorClass)) {
            BeforeInterceptor interceptor = (BeforeInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else if (AfterInterceptor.class.isAssignableFrom(interceptorClass)) {
            AfterInterceptor interceptor = (AfterInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else if (ExceptionInterceptor.class.isAssignableFrom(interceptorClass)) {
            ExceptionInterceptor interceptor = (ExceptionInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        } else if (FinallyInterceptor.class.isAssignableFrom(interceptorClass)) {
            FinallyInterceptor interceptor = (FinallyInterceptor)app.getInstance(interceptorClass);
            RequestHandlerProxy.registerGlobalInterceptor(interceptor);
        }
    }

    public static <T extends Handler> void insertInterceptor(C.List<T> list, T i) {
        int sz = list.size();
        if (0 == sz) {
            list.add(i);
        }
        ListIterator itr = list.listIterator();
        while (itr.hasNext()) {
            Handler t = (Handler)itr.next();
            int n = i.compareTo((Handler)t);
            if (n < 0) {
                itr.add(i);
                return;
            }
            if (n != 0) continue;
            if (i.equals(t)) {
                return;
            }
            itr.add(i);
            return;
        }
        list.add(i);
    }

    public static class GroupExceptionInterceptor {
        private C.List<? extends ExceptionInterceptor> interceptors;

        public GroupExceptionInterceptor(C.List<? extends ExceptionInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        public Result apply(Exception e, ActionContext actionContext) throws Exception {
            try {
                if (this.interceptors.isEmpty()) {
                    return null;
                }
                for (ExceptionInterceptor i : this.interceptors) {
                    Result r = i.handle(e, actionContext);
                    if (null == r) continue;
                    return r;
                }
                return null;
            }
            catch (Result r) {
                return r;
            }
        }
    }

    public static class GroupFinallyInterceptor {
        private C.List<? extends FinallyInterceptor> interceptors;

        public GroupFinallyInterceptor(C.List<FinallyInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        public Void apply(ActionContext actionContext) throws Exception {
            if (this.interceptors.isEmpty()) {
                return null;
            }
            for (FinallyInterceptor i : this.interceptors) {
                i.handle(actionContext);
            }
            return null;
        }
    }

    public static class GroupAfterInterceptor {
        private C.List<? extends AfterInterceptor> interceptors;

        public GroupAfterInterceptor(C.List<? extends AfterInterceptor> interceptors) {
            this.interceptors = interceptors;
        }

        public Result apply(Result result, ActionContext actionContext) throws Exception {
            for (AfterInterceptor i : this.interceptors) {
                result = i.handle(result, actionContext);
            }
            return result;
        }
    }

    public static class GroupInterceptorWithResult {
        private C.List<? extends ActionHandler> interceptors;

        public GroupInterceptorWithResult(C.List<? extends ActionHandler> interceptors) {
            this.interceptors = interceptors;
        }

        public Result apply(ActionContext actionContext) throws Exception {
            try {
                if (this.interceptors.isEmpty()) {
                    return null;
                }
                for (ActionHandler i : this.interceptors) {
                    Result r = i.handle(actionContext);
                    if (null == r) continue;
                    return r;
                }
                return null;
            }
            catch (Result r) {
                return r;
            }
        }
    }

    protected static enum CacheStrategy {
        NO_CACHE{

            @Override
            public Result cached(ActionContext actionContext, CacheService cache) {
                return null;
            }
        }
        ,
        SESSION_SCOPED{

            @Override
            protected String cacheKey(ActionContext actionContext) {
                H.Session session = actionContext.session();
                return null == session ? null : super.cacheKey(actionContext, session.id());
            }
        }
        ,
        GLOBAL_SCOPED;


        public Result cached(ActionContext actionContext, CacheService cache) {
            return (Result)((Object)cache.get(this.cacheKey(actionContext)));
        }

        protected String cacheKey(ActionContext actionContext) {
            return this.cacheKey(actionContext, "");
        }

        protected String cacheKey(ActionContext actionContext, String seed) {
            H.Request request = actionContext.req();
            return actionContext.strBuf().append("urlcache:").append(seed).append(request.url()).append(request.query()).append((Object)request.accept()).toString();
        }
    }
}

