/*
 * Decompiled with CFR 0.152.
 */
package act.handler.builtin.controller.impl;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.AppClassLoader;
import act.controller.Controller;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.ControllerClassMetaInfo;
import act.controller.meta.HandlerMethodMetaInfo;
import act.controller.meta.HandlerParamMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.handler.NonBlock;
import act.handler.PreventDoubleSubmission;
import act.handler.builtin.controller.ActionHandlerInvoker;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.AfterInterceptorInvoker;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.ExceptionInterceptorInvoker;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.Handler;
import act.inject.param.JsonDTO;
import act.inject.param.JsonDTOClassManager;
import act.inject.param.ParamValueLoaderManager;
import act.inject.param.ParamValueLoaderService;
import act.security.CORS;
import act.security.CSRF;
import act.sys.Env;
import act.util.ActContext;
import act.util.DestroyableBase;
import act.view.ActNotFound;
import act.view.RenderAny;
import act.view.RenderTemplate;
import act.view.Template;
import act.view.TemplatePathResolver;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.http.H;
import org.osgl.inject.BeanSpec;
import org.osgl.mvc.annotation.ResponseContentType;
import org.osgl.mvc.annotation.ResponseStatus;
import org.osgl.mvc.annotation.SessionFree;
import org.osgl.mvc.result.BadRequest;
import org.osgl.mvc.result.Conflict;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class ReflectedHandlerInvoker<M extends HandlerMethodMetaInfo>
extends DestroyableBase
implements ActionHandlerInvoker,
AfterInterceptorInvoker,
ExceptionInterceptorInvoker {
    private static final Object[] DUMP_PARAMS = new Object[0];
    private ClassLoader cl;
    private ControllerClassMetaInfo controller;
    private Class<?> controllerClass;
    private MethodAccess methodAccess;
    private M handler;
    private int handlerIndex;
    private Map<H.Format, Boolean> templateCache = C.newMap((Object[])new Object[0]);
    protected Method method;
    private ParamValueLoaderService paramLoaderService;
    private JsonDTOClassManager jsonDTOClassManager;
    private final int paramCount;
    private final int fieldsAndParamsCount;
    private String singleJsonFieldName;
    private final boolean sessionFree;
    private final boolean express;
    private List<BeanSpec> paramSpecs;
    private Set<String> pathVariables;
    private CORS.Spec corsSpec;
    private CSRF.Spec csrfSpec;
    private String jsonDTOKey;
    private boolean isStatic;
    private Object singleton;
    private H.Format forceResponseContentType;
    private H.Status forceResponseStatus;
    private boolean disabled;
    private String dspToken;

    private ReflectedHandlerInvoker(M handlerMetaInfo, App app) {
        PreventDoubleSubmission dsp;
        CSRF.Spec csrfSpec;
        CORS.Spec corsSpec;
        this.cl = app.classLoader();
        this.handler = handlerMetaInfo;
        this.controller = ((HandlerMethodMetaInfo)handlerMetaInfo).classInfo();
        this.controllerClass = $.classForName((String)this.controller.className(), (ClassLoader)this.cl);
        this.disabled = !Env.matches(this.controllerClass);
        this.paramLoaderService = app.service(ParamValueLoaderManager.class).get(ActionContext.class);
        this.jsonDTOClassManager = app.service(JsonDTOClassManager.class);
        Class[] paramTypes = this.paramTypes(this.cl);
        try {
            this.method = this.controllerClass.getMethod(((HandlerMethodMetaInfo)handlerMetaInfo).name(), paramTypes);
            this.disabled = this.disabled || !Env.matches(this.method);
        }
        catch (NoSuchMethodException e) {
            throw E.unexpected((Throwable)e);
        }
        this.isStatic = ((HandlerMethodMetaInfo)handlerMetaInfo).isStatic();
        if (!this.isStatic) {
            this.methodAccess = MethodAccess.get(this.controllerClass);
            this.handlerIndex = this.methodAccess.getIndex(((HandlerMethodMetaInfo)handlerMetaInfo).name(), paramTypes);
        } else {
            this.method.setAccessible(true);
        }
        this.sessionFree = this.method.isAnnotationPresent(SessionFree.class);
        this.express = this.method.isAnnotationPresent(NonBlock.class);
        this.paramCount = ((HandlerMethodMetaInfo)this.handler).paramCount();
        this.paramSpecs = this.jsonDTOClassManager.beanSpecs(this.controllerClass, this.method);
        this.fieldsAndParamsCount = this.paramSpecs.size();
        if (this.fieldsAndParamsCount == 1) {
            this.singleJsonFieldName = this.paramSpecs.get(0).name();
        }
        this.corsSpec = corsSpec = CORS.spec(this.method).chain(CORS.spec(this.controllerClass));
        this.csrfSpec = csrfSpec = CSRF.spec(this.method).chain(CSRF.spec(this.controllerClass));
        this.jsonDTOKey = app.cuid();
        this.singleton = this.singleton(app);
        ResponseContentType contentType = this.method.getAnnotation(ResponseContentType.class);
        if (null != contentType) {
            this.forceResponseContentType = contentType.value().format();
        } else {
            contentType = this.controllerClass.getAnnotation(ResponseContentType.class);
            if (null != contentType) {
                this.forceResponseContentType = contentType.value().format();
            }
        }
        ResponseStatus status = this.method.getAnnotation(ResponseStatus.class);
        if (null != status) {
            this.forceResponseStatus = H.Status.of((int)status.value());
        }
        if (null != (dsp = this.method.getAnnotation(PreventDoubleSubmission.class))) {
            this.dspToken = dsp.value();
            if ("--configured--".equals(this.dspToken)) {
                this.dspToken = app.config().dspToken();
            }
        }
    }

    @Override
    protected void releaseResources() {
        this.cl = null;
        this.controller = null;
        this.controllerClass = null;
        this.method = null;
        this.methodAccess = null;
        ((DestroyableBase)this.handler).destroy();
        this.handler = null;
        super.releaseResources();
    }

    @Override
    public int priority() {
        return ((HandlerMethodMetaInfo)this.handler).priority();
    }

    @Override
    public void accept(ActionHandlerInvoker.Visitor visitor) {
        ReflectedHandlerInvokerVisitor rv = (ReflectedHandlerInvokerVisitor)visitor;
        rv.apply(this.controllerClass, this.method);
    }

    @Override
    public Result handle(ActionContext actionContext) throws Exception {
        if (this.disabled) {
            return ActNotFound.get();
        }
        actionContext.attribute("reflected_handler", this);
        this.preventDoubleSubmission(actionContext);
        this.processForceResponse(actionContext);
        this.ensureJsonDTOGenerated(actionContext);
        Object controller = this.controllerInstance(actionContext);
        boolean failOnViolation = actionContext.acceptJson() || this.checkTemplate(actionContext);
        Object[] params = this.params(controller, actionContext);
        if (failOnViolation && actionContext.hasViolation()) {
            String msg = actionContext.violationMessage(";");
            return new BadRequest(msg, new Object[0]);
        }
        return this.invoke(this.handler, actionContext, controller, params);
    }

    @Override
    public Result handle(Result result, ActionContext actionContext) throws Exception {
        actionContext.attribute("__result__", (Object)result);
        return this.handle(actionContext);
    }

    @Override
    public Result handle(Exception e, ActionContext actionContext) throws Exception {
        actionContext.attribute("__exception__", e);
        return this.handle(actionContext);
    }

    @Override
    public boolean sessionFree() {
        return this.sessionFree;
    }

    @Override
    public boolean express() {
        return this.express;
    }

    @Override
    public CORS.Spec corsSpec() {
        return this.corsSpec;
    }

    @Override
    public CSRF.Spec csrfSpec() {
        return this.csrfSpec;
    }

    public JsonDTO cachedJsonDTO(ActContext<?> context) {
        return (JsonDTO)context.attribute(this.jsonDTOKey);
    }

    private void ensureJsonDTOGenerated(ActionContext context) {
        if (0 == this.fieldsAndParamsCount || !context.jsonEncoded() || null != context.attribute(this.jsonDTOKey)) {
            return;
        }
        Class<? extends JsonDTO> dtoClass = this.jsonDTOClassManager.get(this.controllerClass, this.method);
        if (null == dtoClass) {
            return;
        }
        try {
            JsonDTO dto = (JsonDTO)JSON.parseObject((String)this.patchedJsonBody(context), dtoClass);
            context.attribute(this.jsonDTOKey, dto);
        }
        catch (JSONException e) {
            if (e.getCause() != null) {
                App.LOGGER.warn(e.getCause(), "error parsing JSON data");
            } else {
                App.LOGGER.warn((Throwable)e, "error parsing JSON data");
            }
            throw new BadRequest(e.getCause());
        }
    }

    private int fieldsAndParamsCount(ActionContext context) {
        if (this.fieldsAndParamsCount < 2) {
            return this.fieldsAndParamsCount;
        }
        return this.fieldsAndParamsCount - this.pathVariables(context).size();
    }

    private Set<String> pathVariables(ActionContext context) {
        if (null == this.pathVariables) {
            this.pathVariables = (Set)context.attribute("__path_vars__");
        }
        return this.pathVariables;
    }

    private String singleJsonFieldName(ActionContext context) {
        if (null != this.singleJsonFieldName) {
            return this.singleJsonFieldName;
        }
        Set<String> set = context.paramKeys();
        for (BeanSpec spec : this.paramSpecs) {
            String name = spec.name();
            if (set.contains(name)) continue;
            return name;
        }
        return null;
    }

    private String patchedJsonBody(ActionContext context) {
        boolean needPatch;
        String body = context.body();
        if (S.blank((String)body) || 1 < this.fieldsAndParamsCount(context)) {
            return body;
        }
        String theName = this.singleJsonFieldName(context);
        int theNameLen = theName.length();
        if (null == theName) {
            return body;
        }
        boolean bl = needPatch = (body = body.trim()).charAt(0) == '[';
        if (!needPatch) {
            if (body.charAt(0) != '{') {
                throw new IllegalArgumentException("Cannot parse JSON string: " + body);
            }
            boolean startCheckName = false;
            int nameStart = -1;
            for (int i = 1; i < body.length(); ++i) {
                char c = body.charAt(i);
                if (c == ' ') continue;
                if (startCheckName) {
                    if (c == '\"') break;
                    int id = i - nameStart - 1;
                    if (id < theNameLen && theName.charAt(i - nameStart - 1) == c) continue;
                    needPatch = true;
                    break;
                }
                if (c != '\"') continue;
                startCheckName = true;
                nameStart = i;
            }
        }
        return needPatch ? S.fmt((String)"{\"%s\": %s}", (Object[])new Object[]{theName, body}) : body;
    }

    private Class[] paramTypes(ClassLoader cl) {
        int sz = ((HandlerMethodMetaInfo)this.handler).paramCount();
        Class[] ca = new Class[sz];
        for (int i = 0; i < sz; ++i) {
            HandlerParamMetaInfo param = ((HandlerMethodMetaInfo)this.handler).param(i);
            ca[i] = $.classForName((String)param.type().getClassName(), (ClassLoader)cl);
        }
        return ca;
    }

    private void processForceResponse(ActionContext actionContext) {
        if (null != this.forceResponseContentType) {
            actionContext.accept(this.forceResponseContentType);
        }
        if (null != this.forceResponseStatus) {
            actionContext.forceResponseStatus(this.forceResponseStatus);
        }
    }

    private void preventDoubleSubmission(ActionContext context) {
        String cacheKey;
        if (null == this.dspToken) {
            return;
        }
        H.Request req = context.req();
        if (req.method().safe()) {
            return;
        }
        String tokenValue = context.paramVal(this.dspToken);
        if (S.blank((String)tokenValue)) {
            return;
        }
        H.Session session = context.session();
        String cached = (String)session.cached(cacheKey = S.concat((String)"DSP-", (String)this.dspToken));
        if (S.eq((String)tokenValue, (String)cached)) {
            throw Conflict.get();
        }
        session.cacheFor1Min(cacheKey, (Object)tokenValue);
    }

    private Object controllerInstance(ActionContext context) {
        if (this.isStatic) {
            return null;
        }
        if (null != this.singleton) {
            return this.singleton;
        }
        String controllerName = this.controllerClass.getName();
        Object inst = context.__controllerInstance(controllerName);
        if (null == inst) {
            inst = this.paramLoaderService.loadHostBean(this.controllerClass, context);
            context.__controllerInstance(controllerName, inst);
        }
        return inst;
    }

    private Result invoke(M handlerMetaInfo, ActionContext context, Object controller, Object[] params) throws Exception {
        Object result;
        if (null != this.methodAccess) {
            try {
                result = this.methodAccess.invoke(controller, this.handlerIndex, params);
            }
            catch (Result r) {
                return r;
            }
        }
        try {
            result = this.method.invoke(null, params);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Result) {
                return (Result)cause;
            }
            throw (Exception)cause;
        }
        if (null == result && ((HandlerMethodMetaInfo)this.handler).hasReturn() && !((HandlerMethodMetaInfo)this.handler).returnTypeInfo().isResult()) {
            return ActNotFound.create(this.method);
        }
        boolean hasTemplate = this.checkTemplate(context);
        if (hasTemplate && result instanceof RenderAny) {
            result = RenderTemplate.INSTANCE;
        }
        return Controller.Util.inferResult(handlerMetaInfo, result, context, hasTemplate);
    }

    private synchronized boolean checkTemplate(ActionContext context) {
        if (!context.state().isHandling()) {
            return false;
        }
        Boolean hasTemplate = context.hasTemplate();
        if (null != hasTemplate) {
            return hasTemplate;
        }
        H.Format fmt = context.accept();
        hasTemplate = this.templateCache.get(fmt);
        if (null == hasTemplate || Act.isDev()) {
            Template t;
            hasTemplate = !TemplatePathResolver.isAcceptFormatSupported(fmt) ? Boolean.valueOf(false) : Boolean.valueOf((t = Act.viewManager().load(context)) != null);
            this.templateCache.put(fmt, hasTemplate);
        }
        context.hasTemplate(hasTemplate);
        return hasTemplate;
    }

    private Object[] params(Object controller, ActionContext context) {
        if (0 == this.paramCount) {
            return DUMP_PARAMS;
        }
        return this.paramLoaderService.loadMethodParams(controller, this.method, context);
    }

    private Object singleton(App app) {
        List fields;
        Object singleton = app.singleton(this.controllerClass);
        if (null == singleton && (fields = $.fieldsOf(this.controllerClass, JsonDTOClassManager.CLASS_FILTER, JsonDTOClassManager.FIELD_FILTER)).isEmpty()) {
            singleton = app.getInstance(this.controllerClass);
        }
        return singleton;
    }

    public static ControllerAction createControllerAction(ActionMethodMetaInfo meta, App app) {
        return new ControllerAction(new ReflectedHandlerInvoker<ActionMethodMetaInfo>(meta, app));
    }

    public static BeforeInterceptor createBeforeInterceptor(InterceptorMethodMetaInfo meta, App app) {
        return new _Before(new ReflectedHandlerInvoker<InterceptorMethodMetaInfo>(meta, app));
    }

    public static AfterInterceptor createAfterInterceptor(InterceptorMethodMetaInfo meta, App app) {
        return new _After(new ReflectedHandlerInvoker<InterceptorMethodMetaInfo>(meta, app));
    }

    public static ExceptionInterceptor createExceptionInterceptor(CatchMethodMetaInfo meta, App app) {
        return new _Exception(new ReflectedHandlerInvoker<CatchMethodMetaInfo>(meta, app), meta);
    }

    public static FinallyInterceptor createFinannyInterceptor(InterceptorMethodMetaInfo meta, App app) {
        return new _Finally(new ReflectedHandlerInvoker<InterceptorMethodMetaInfo>(meta, app));
    }

    private static class _Finally
    extends FinallyInterceptor {
        private ActionHandlerInvoker invoker;

        _Finally(ActionHandlerInvoker invoker) {
            super(invoker.priority());
            this.invoker = invoker;
        }

        @Override
        public void handle(ActionContext actionContext) throws Exception {
            this.invoker.handle(actionContext);
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private static class _Exception
    extends ExceptionInterceptor {
        private ExceptionInterceptorInvoker invoker;

        _Exception(ExceptionInterceptorInvoker invoker, CatchMethodMetaInfo metaInfo) {
            super(invoker.priority(), _Exception.exceptionClassesOf(metaInfo));
            this.invoker = invoker;
        }

        private static List<Class<? extends Exception>> exceptionClassesOf(CatchMethodMetaInfo metaInfo) {
            List<String> classNames = metaInfo.exceptionClasses();
            C.List clsList = C.newSizedList((int)classNames.size());
            AppClassLoader cl = App.instance().classLoader();
            for (String cn : classNames) {
                clsList.add($.classForName((String)cn, (ClassLoader)cl));
            }
            return clsList;
        }

        @Override
        protected Result internalHandle(Exception e, ActionContext actionContext) throws Exception {
            return this.invoker.handle(e, actionContext);
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(ActionHandlerInvoker.Visitor visitor) {
            this.invoker.accept(visitor);
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private static class _After
    extends AfterInterceptor {
        private AfterInterceptorInvoker invoker;

        _After(AfterInterceptorInvoker invoker) {
            super(invoker.priority());
            this.invoker = invoker;
        }

        @Override
        public Result handle(Result result, ActionContext actionContext) throws Exception {
            return this.invoker.handle(result, actionContext);
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        public void accept(ActionHandlerInvoker.Visitor visitor) {
            this.invoker.accept(visitor);
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    private static class _Before
    extends BeforeInterceptor {
        private ActionHandlerInvoker invoker;

        _Before(ActionHandlerInvoker invoker) {
            super(invoker.priority());
            this.invoker = invoker;
        }

        @Override
        public Result handle(ActionContext actionContext) throws Exception {
            return this.invoker.handle(actionContext);
        }

        @Override
        public boolean sessionFree() {
            return this.invoker.sessionFree();
        }

        @Override
        public boolean express() {
            return this.invoker.express();
        }

        @Override
        public void accept(Handler.Visitor visitor) {
            this.invoker.accept(visitor.invokerVisitor());
        }

        @Override
        public CORS.Spec corsSpec() {
            return this.invoker.corsSpec();
        }

        @Override
        protected void releaseResources() {
            this.invoker.destroy();
            this.invoker = null;
        }
    }

    public static interface ReflectedHandlerInvokerVisitor
    extends ActionHandlerInvoker.Visitor,
    Osgl.Func2<Class<?>, Method, Void> {
    }
}

