/*
 * Decompiled with CFR 0.152.
 */
package act.handler.event;

import act.app.ActionContext;
import act.event.ActEvent;
import act.event.SystemEvent;
import act.handler.event.AfterResultCommit;
import act.handler.event.BeforeResultCommit;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;

public abstract class ResultEvent
extends ActEvent<Result>
implements SystemEvent {
    private final H.Request req;
    private final H.Response resp;
    public static final Osgl.Func3<Result, H.Request<?>, H.Response<?>, Void> BEFORE_COMMIT_HANDLER = new Osgl.F3<Result, H.Request<?>, H.Response<?>, Void>(){

        public Void apply(Result result, H.Request<?> request, H.Response<?> response) throws NotAppliedException, Osgl.Break {
            ActionContext context = (ActionContext)request.context();
            context.applyCorsSpec().applyContentType();
            context.app().eventBus().trigger(new BeforeResultCommit(result, request, response));
            return null;
        }
    };
    public static final Osgl.Func3<Result, H.Request<?>, H.Response<?>, Void> AFTER_COMMIT_HANDLER = new Osgl.F3<Result, H.Request<?>, H.Response<?>, Void>(){

        public Void apply(Result result, H.Request<?> request, H.Response<?> response) throws NotAppliedException, Osgl.Break {
            ActionContext context = (ActionContext)request.context();
            context.app().eventBus().trigger(new AfterResultCommit(result, request, response));
            return null;
        }
    };

    public ResultEvent(Result result, H.Request req, H.Response resp) {
        super(result);
        this.req = (H.Request)$.notNull((Object)req);
        this.resp = (H.Response)$.notNull((Object)resp);
    }

    public Result result() {
        return (Result)((Object)this.source());
    }

    public H.Request request() {
        return this.req;
    }

    public H.Response response() {
        return this.resp;
    }
}

