/*
 * Decompiled with CFR 0.152.
 */
package act.i18n;

import act.app.ActionContext;
import act.conf.AppConfig;
import act.controller.Controller;
import java.util.Locale;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.osgl.http.H;
import org.osgl.mvc.annotation.PostAction;
import org.osgl.util.S;

public class LocaleResolver {
    private static final String KEY = "__locale__";
    private static final int COOKIE_TTL = 604800;
    private ActionContext context;
    private AppConfig config;
    private boolean enabled;
    private Locale locale;
    private boolean reset;
    private boolean resolvedFromParam;

    @PostAction(value={"i18n/locale"})
    public static void updateLocale(H.Request request) {
        String s = request.header("Referer");
        if (S.notBlank((String)s)) {
            throw Controller.Util.redirect(s, new Object[0]);
        }
    }

    @Inject
    public LocaleResolver(ActionContext context) {
        AppConfig config = context.config();
        this.enabled = config.i18nEnabled();
        if (!this.enabled) {
            return;
        }
        this.context = context;
        this.config = config;
    }

    public void resolve() {
        if (!this.enabled) {
            return;
        }
        Locale locale = this.resolveFromParam();
        if (!this.reset && null == locale) {
            locale = this.resolveFromSessionOrCookie();
        }
        if (null == locale) {
            locale = this.resolveFromHeader();
        }
        if (null == locale) {
            locale = this.resolveFromServer();
        }
        this.context.locale(locale);
        this.locale = locale;
    }

    public void dissolve() {
        if (!this.shouldWriteLocaleCookie()) {
            return;
        }
        String cookieName = this.config.localeCookieName();
        Locale locale = this.context.locale();
        if (null == locale) {
            locale = this.locale;
        }
        String localeStr = locale.toString();
        H.Session session = this.context.session();
        if (null != session) {
            if (this.reset) {
                session.remove(KEY);
            } else {
                session.put(KEY, localeStr);
            }
        }
        H.Cookie cookie = new H.Cookie(cookieName, localeStr);
        cookie.domain(this.config.cookieDomain());
        cookie.path("/");
        cookie.maxAge(this.reset ? -1 : 604800);
        if (this.reset) {
            cookie.expires(DateTime.now().minusDays(1).toDate());
        }
        this.context.resp().addCookie(cookie);
    }

    private boolean shouldWriteLocaleCookie() {
        return this.enabled && (this.reset || this.resolvedFromParam || this.locale != this.context.locale());
    }

    private Locale resolveFromSessionOrCookie() {
        Locale locale = null;
        H.Session session = this.context.session();
        if (null != session) {
            locale = this.parseStr(session.get(KEY));
        }
        if (null == locale) {
            H.Cookie cookie = this.context.cookie(this.config.localeCookieName());
            locale = null == cookie ? null : this.parseStr(cookie.value());
        }
        return locale;
    }

    private Locale resolveFromParam() {
        String s = this.context.paramVal(this.config.localeParamName());
        Locale locale = this.parseStr(s);
        if (null != locale) {
            this.resolvedFromParam = true;
        }
        return locale;
    }

    private Locale resolveFromHeader() {
        return this.context.req().locale();
    }

    private Locale resolveFromServer() {
        return this.config.locale();
    }

    private Locale parseStr(String val) {
        if (null == val) {
            return null;
        }
        if ("default".equals(val)) {
            this.reset = true;
            return null;
        }
        String[] sa = val.trim().split("[-_]");
        int len = sa.length;
        switch (len) {
            case 3: {
                return new Locale(sa[0], sa[1], sa[2]);
            }
            case 2: {
                return new Locale(sa[0], sa[1]);
            }
        }
        return new Locale(sa[0]);
    }

    public static void main(String[] args) {
        System.out.println(Locale.US.toLanguageTag());
    }
}

