/*
 * Decompiled with CFR 0.152.
 */
package act.inject;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.util.AppCrypto;
import act.cli.CliContext;
import act.cli.CliSession;
import act.conf.AppConfig;
import act.db.Dao;
import act.event.EventBus;
import act.mail.MailerContext;
import act.util.ActContext;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Set;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.cache.CacheService;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.web.util.UserAgent;

public final class ActProviders {
    private static Set<Class> providedTypes = C.newSet();
    public static final Provider<App> APP;
    public static final Provider<ActionContext> ACTION_CONTEXT;
    public static final Provider<H.Session> SESSION;
    public static final Provider<H.Flash> FLASH;
    public static final Provider<H.Request> REQUEST;
    public static final Provider<H.Response> RESPONSE;
    public static final Provider<CliContext> CLI_CONTEXT;
    public static final Provider<CliSession> CLI_SESSION;
    public static final Provider<MailerContext> MAILER_CONTEXT;
    public static final Provider<ActContext> ACT_CONTEXT;
    public static final Provider<Logger> LOGGER;
    public static final Provider<UserAgent> USER_AGENT;
    public static final Provider<AppConfig> APP_CONFIG;
    public static final Provider<AppCrypto> APP_CRYPTO;
    public static final Provider<CacheService> APP_CACHE_SERVICE;
    public static final Provider<EventBus> EVENT_BUS;
    public static final Provider<Locale> LOCALE;

    private ActProviders() {
    }

    public static void registerBuiltInProviders(Class<?> providersClass, Osgl.Func2<Class, Provider, ?> register) {
        for (Field field : providersClass.getDeclaredFields()) {
            try {
                if (!Provider.class.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                Type type = field.getGenericType();
                if (!(type instanceof ParameterizedType)) continue;
                ParameterizedType ptype = (ParameterizedType)$.cast((Object)field.getGenericType());
                Provider provider = (Provider)$.cast((Object)field.get(null));
                register.apply((Object)((Class)ptype.getActualTypeArguments()[0]), (Object)provider);
            }
            catch (Exception e) {
                throw E.unexpected((Throwable)e);
            }
        }
    }

    public static boolean isProvided(Class<?> aClass) {
        return providedTypes.contains(aClass) || Dao.class.isAssignableFrom(aClass);
    }

    private static App app() {
        return App.instance();
    }

    public static void addProvidedType(Class<?> aClass) {
        providedTypes.add(aClass);
    }

    static {
        ActProviders.registerBuiltInProviders(ActProviders.class, new Osgl.F2<Class, Provider, Void>(){

            public Void apply(Class aClass, Provider provider) throws NotAppliedException, Osgl.Break {
                providedTypes.add(aClass);
                return null;
            }
        });
        APP = new Provider<App>(){

            public App get() {
                return ActProviders.app();
            }
        };
        ACTION_CONTEXT = new Provider<ActionContext>(){

            public ActionContext get() {
                return ActionContext.current();
            }
        };
        SESSION = new Provider<H.Session>(){

            public H.Session get() {
                return ActionContext.current().session();
            }
        };
        FLASH = new Provider<H.Flash>(){

            public H.Flash get() {
                return ActionContext.current().flash();
            }
        };
        REQUEST = new Provider<H.Request>(){

            public H.Request get() {
                return ActionContext.current().req();
            }
        };
        RESPONSE = new Provider<H.Response>(){

            public H.Response get() {
                return ActionContext.current().resp();
            }
        };
        CLI_CONTEXT = new Provider<CliContext>(){

            public CliContext get() {
                return CliContext.current();
            }
        };
        CLI_SESSION = new Provider<CliSession>(){

            public CliSession get() {
                CliContext context = CliContext.current();
                return null == context ? null : context.session();
            }
        };
        MAILER_CONTEXT = new Provider<MailerContext>(){

            public MailerContext get() {
                return MailerContext.current();
            }
        };
        ACT_CONTEXT = new Provider<ActContext>(){

            public ActContext get() {
                ActContext.Base ctx = MailerContext.current();
                if (null != ctx) {
                    return ctx;
                }
                ctx = ActionContext.current();
                if (null != ctx) {
                    return ctx;
                }
                return CliContext.current();
            }
        };
        LOGGER = new Provider<Logger>(){

            public Logger get() {
                return Act.LOGGER;
            }
        };
        USER_AGENT = new Provider<UserAgent>(){

            public UserAgent get() {
                ActionContext actionContext = ActionContext.current();
                if (null == actionContext) {
                    throw new IllegalStateException();
                }
                return actionContext.userAgent();
            }
        };
        APP_CONFIG = new Provider<AppConfig>(){

            public AppConfig get() {
                return ActProviders.app().config();
            }
        };
        APP_CRYPTO = new Provider<AppCrypto>(){

            public AppCrypto get() {
                return ActProviders.app().crypto();
            }
        };
        APP_CACHE_SERVICE = new Provider<CacheService>(){

            public CacheService get() {
                return ActProviders.app().cache();
            }
        };
        EVENT_BUS = new Provider<EventBus>(){

            public EventBus get() {
                return ActProviders.app().eventBus();
            }
        };
        LOCALE = new Provider<Locale>(){

            public Locale get() {
                ActContext context = ActContext.Base.currentContext();
                return null != context ? context.locale(true) : ActProviders.app().config().locale();
            }
        };
    }
}

