/*
 * Decompiled with CFR 0.152.
 */
package act.inject.genie;

import act.Act;
import act.app.App;
import act.app.AppClassLoader;
import act.app.conf.AppConfigurator;
import act.app.event.AppEventId;
import act.controller.ActionMethodParamAnnotationHandler;
import act.inject.ActProvider;
import act.inject.ActProviders;
import act.inject.AutoBind;
import act.inject.DependencyInjectionBinder;
import act.inject.DependencyInjectorBase;
import act.inject.ModuleTag;
import act.inject.genie.GenieFactoryFinder;
import act.inject.genie.GenieListener;
import act.inject.genie.GenieProviders;
import act.inject.genie.RequestScope;
import act.inject.genie.SessionScope;
import act.inject.genie.SingletonScope;
import act.sys.Env;
import act.util.AnnotatedClassFinder;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.SubClassFinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.GenericTypedBeanLoader;
import org.osgl.inject.Genie;
import org.osgl.inject.InjectListener;
import org.osgl.inject.Injector;
import org.osgl.inject.Module;
import org.osgl.inject.ScopeCache;
import org.osgl.inject.annotation.LoadValue;
import org.osgl.inject.annotation.Provided;
import org.osgl.mvc.annotation.Bind;
import org.osgl.mvc.annotation.Param;
import org.osgl.util.C;
import org.osgl.util.E;

public class GenieInjector
extends DependencyInjectorBase<GenieInjector> {
    private static final Module SCOPE_MODULE = new Module(){

        protected void configure() {
            this.bind(ScopeCache.SessionScope.class).to((Object)new SessionScope());
            this.bind(ScopeCache.RequestScope.class).to((Object)new RequestScope());
            this.bind(ScopeCache.SingletonScope.class).to((Object)new SingletonScope());
        }
    };
    private volatile Genie genie;
    private Set<Object> modules;
    private Set<Class<? extends Annotation>> injectTags = new HashSet<Class<? extends Annotation>>();

    public GenieInjector(App app) {
        super(app);
        this.modules = this.factories();
        this.modules.add(SCOPE_MODULE);
    }

    @Override
    public <T> T get(Class<T> clazz) {
        return (T)this.genie().get(clazz);
    }

    public <T> Provider<T> getProvider(Class<T> aClass) {
        return this.genie().getProvider(aClass);
    }

    public <T> T get(BeanSpec spec) {
        return (T)this.genie().get(spec);
    }

    @Override
    public synchronized void registerDiBinder(DependencyInjectionBinder binder) {
        super.registerDiBinder(binder);
        if (null != this.genie) {
            this.genie.registerProvider(binder.targetClass(), (Provider)binder);
        }
    }

    @Override
    public boolean isProvided(Class<?> type) {
        return ActProviders.isProvided(type) || type.isAnnotationPresent(Provided.class) || type.isAnnotationPresent(Inject.class);
    }

    public boolean isQualifier(Class<? extends Annotation> aClass) {
        return this.genie().isQualifier(aClass);
    }

    public boolean isPostConstructProcessor(Class<? extends Annotation> aClass) {
        return this.genie().isPostConstructProcessor(aClass);
    }

    public boolean isScope(Class<? extends Annotation> aClass) {
        return this.genie().isScope(aClass);
    }

    public void addModule(Object module) {
        E.illegalStateIf((null != this.genie ? 1 : 0) != 0);
        this.modules.add(module);
    }

    public boolean subjectToInject(BeanSpec spec) {
        return this.genie().subjectToInject(spec);
    }

    private C.Set<Object> factories() {
        Set<String> factories = GenieFactoryFinder.factories();
        int len = factories.size();
        C.Set set = C.newSet();
        if (0 == len) {
            return set;
        }
        AppClassLoader cl = App.instance().classLoader();
        for (String className : factories) {
            set.add((Object)$.classForName((String)className, (ClassLoader)cl));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Genie genie() {
        if (null == this.genie) {
            GenieInjector genieInjector = this;
            synchronized (genieInjector) {
                if (null == this.genie) {
                    GenieListener listener = new GenieListener(this);
                    this.genie = Genie.create((InjectListener)listener, (Object[])this.modules.toArray(new Object[this.modules.size()]));
                    for (Map.Entry entry : this.binders.entrySet()) {
                        this.genie.registerProvider((Class)entry.getKey(), (Provider)entry.getValue());
                    }
                    Osgl.F2<Class, Provider, Void> register = new Osgl.F2<Class, Provider, Void>(){

                        public Void apply(Class aClass, Provider provider) throws NotAppliedException, Osgl.Break {
                            GenieInjector.this.genie.registerProvider(aClass, provider);
                            return null;
                        }
                    };
                    this.genie.registerQualifiers(new Class[]{Bind.class, Param.class});
                    List<ActionMethodParamAnnotationHandler> list = Act.pluginManager().pluginList(ActionMethodParamAnnotationHandler.class);
                    for (ActionMethodParamAnnotationHandler actionMethodParamAnnotationHandler : list) {
                        Set<Class<? extends Annotation>> set = actionMethodParamAnnotationHandler.listenTo();
                        for (Class<? extends Annotation> c : set) {
                            this.genie.registerQualifiers(new Class[]{c});
                        }
                    }
                    ActProviders.registerBuiltInProviders(ActProviders.class, register);
                    ActProviders.registerBuiltInProviders(GenieProviders.class, register);
                    for (Class clazz : this.injectTags) {
                        this.genie.registerInjectTag(new Class[]{clazz});
                    }
                }
            }
        }
        return this.genie;
    }

    @SubClassFinder(callOn=AppEventId.DEPENDENCY_INJECTOR_LOADED)
    public static void foundModule(Class<? extends Module> moduleClass) {
        GenieInjector.addModuleClass(moduleClass);
    }

    @SubClassFinder(callOn=AppEventId.DEPENDENCY_INJECTOR_LOADED)
    public static void foundConfigurator(Class<? extends AppConfigurator> configurator) {
        GenieInjector.addModuleClass(configurator);
    }

    private static boolean hasBinding(Class<?> clazz) {
        GenieInjector gi = (GenieInjector)Act.injector();
        Genie genie = gi.genie();
        return genie.hasProvider(clazz);
    }

    @AnnotatedClassFinder(value=AutoBind.class, callOn=AppEventId.DEPENDENCY_INJECTOR_PROVISIONED, noAbstract=false)
    public static void foundAutoBinding(final Class<?> autoBinding) {
        if (GenieInjector.hasBinding(autoBinding)) {
            return;
        }
        final AppClassLoader cl = Act.app().classLoader();
        ClassInfoRepository repo = cl.classInfoRepository();
        ClassNode root = repo.node(autoBinding.getName());
        E.invalidConfigurationIf((null == root ? 1 : 0) != 0, (String)"Cannot find AutoBind root: %s", (Object[])new Object[]{autoBinding.getName()});
        final LinkedHashSet candidates = new LinkedHashSet();
        root.visitPublicNotAbstractSubTreeNodes((Osgl.Function<ClassNode, ?>)new Osgl.Visitor<ClassNode>(){

            public void visit(ClassNode classNode) throws Osgl.Break {
                try {
                    Class clazz = $.classForName((String)classNode.name(), (ClassLoader)cl);
                    if (Env.matches(clazz)) {
                        candidates.add(clazz);
                    }
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new ConfigurationException((Throwable)e, "Unable to auto bind on %s", new Object[]{autoBinding.getName()});
                }
            }
        });
        if (!candidates.isEmpty()) {
            GenieInjector injector = (GenieInjector)Act.app().injector();
            HashMap<Osgl.T2, Class> multiCandidatesMap = new HashMap<Osgl.T2, Class>();
            for (Class clazz : candidates) {
                String name;
                BeanSpec spec = BeanSpec.of((Class)clazz, (Injector)injector);
                Set qualifiers = spec.qualifiers();
                Osgl.T2 key = $.T2((Object)qualifiers, (Object)(name = spec.name()));
                if (multiCandidatesMap.containsKey(key)) {
                    throw new ConfigurationException("Unable to auto bind on %s: multiple same qualified candidates found", new Object[]{autoBinding});
                }
                multiCandidatesMap.put(key, clazz);
            }
            for (Map.Entry entry : multiCandidatesMap.entrySet()) {
                Genie.Binder binder = new Genie.Binder(autoBinding).to((Class)entry.getValue());
                Osgl.T2 key = (Osgl.T2)entry.getKey();
                Set qualifiers = (Set)key._1;
                String name = (String)key._2;
                if (!qualifiers.isEmpty()) {
                    binder = binder.withAnnotation(qualifiers.toArray(new Annotation[qualifiers.size()]));
                }
                if (null != name) {
                    binder.named(name);
                }
                binder.register(injector.genie());
            }
        } else {
            App.LOGGER.warn("Unable to auto bind on %s: implementation not found", new Object[]{autoBinding});
        }
    }

    @AnnotatedClassFinder(value=ModuleTag.class, callOn=AppEventId.DEPENDENCY_INJECTOR_LOADED, noAbstract=false)
    public static void foundTaggedModule(Class<?> taggedModuleClass) {
        GenieInjector.addModuleClass(taggedModuleClass);
    }

    public static void addModuleClass(Class<?> moduleClass) {
        if (!GenieInjector.isModuleAllowed(moduleClass)) {
            return;
        }
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        genieInjector.addModule(moduleClass);
    }

    @AnnotatedClassFinder(value=LoadValue.class, noAbstract=false, callOn=AppEventId.DEPENDENCY_INJECTOR_LOADED)
    public static void foundValueLoader(Class<? extends Annotation> valueLoader) {
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        genieInjector.injectTags.add(valueLoader);
    }

    @SubClassFinder
    public static void foundGenericTypedBeanLoader(Class<? extends GenericTypedBeanLoader> loaderClass) {
        Type[] ta;
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        for (Type t : ta = loaderClass.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(t instanceof ParameterizedType) || GenericTypedBeanLoader.class != (pt = (ParameterizedType)t).getRawType()) continue;
            Type compoentType = pt.getActualTypeArguments()[0];
            genieInjector.genie().registerGenericTypedBeanLoader((Class)compoentType, app.getInstance(loaderClass));
        }
    }

    @SubClassFinder
    public static void foundProviderBase(Class<? extends ActProvider> providerClass) {
        App app = App.instance();
        GenieInjector genieInjector = (GenieInjector)app.injector();
        ActProvider provider = app.getInstance(providerClass);
        genieInjector.genie().registerProvider(provider.targetType(), (Provider)provider);
    }

    private static boolean isModuleAllowed(Class<?> moduleClass) {
        Env.Profile profile = moduleClass.getAnnotation(Env.Profile.class);
        if (null != profile) {
            return Env.matches(profile);
        }
        Env.Mode mode = moduleClass.getAnnotation(Env.Mode.class);
        if (null != mode) {
            return Env.matches(mode);
        }
        Env.Group group = moduleClass.getAnnotation(Env.Group.class);
        if (null != group) {
            return Env.matches(group);
        }
        return true;
    }
}

