/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.app.App;
import act.cli.CliContext;
import act.cli.Optional;
import act.cli.Required;
import act.cli.meta.CommandMethodMetaInfo;
import act.cli.util.CommandLineParser;
import act.inject.param.CliArgumentLoader;
import act.inject.param.CliVarArgumentLoader;
import act.inject.param.OptionLoader;
import act.inject.param.ParamValueLoader;
import act.inject.param.ParamValueLoaderService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.mvc.annotation.Resolve;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public class CliContextParamLoader
extends ParamValueLoaderService {
    private static final transient ThreadLocal<CommandMethodMetaInfo> methodMetaInfoHolder = new ThreadLocal();
    private ConcurrentMap<Method, List<OptionLoader>> optionLoaderRegistry = new ConcurrentHashMap<Method, List<OptionLoader>>();

    CliContextParamLoader(App app) {
        super(app);
    }

    public CliContext.ParsingContext buildParsingContext(Class commander, Method method, CommandMethodMetaInfo methodMetaInfo) {
        CliContext.ParsingContextBuilder.start();
        this.ensureOptionLoaders(method, methodMetaInfo);
        methodMetaInfoHolder.set(methodMetaInfo);
        ParamValueLoader loader = this.findBeanLoader(commander);
        this.classRegistry.putIfAbsent(commander, loader);
        Osgl.Var boolBag = $.var();
        ParamValueLoader[] loaders = this.findMethodParamLoaders(method, commander, (Osgl.Var<Boolean>)boolBag);
        this.methodRegistry.putIfAbsent(method, loaders);
        this.methodValidationConstraintLookup.put(method, boolBag.get());
        return CliContext.ParsingContextBuilder.finish();
    }

    public void preParseOptions(Method method, CommandMethodMetaInfo methodMetaInfo, CliContext context) {
        List<OptionLoader> optionLoaders = this.ensureOptionLoaders(method, methodMetaInfo);
        CommandLineParser commandLineParser = context.commandLine();
        boolean argumentAsOption = false;
        if (1 == optionLoaders.size()) {
            String theOptionVal;
            OptionLoader loader = optionLoaders.get(0);
            if (loader.required && null != (theOptionVal = commandLineParser.argumentAsOption())) {
                argumentAsOption = true;
                context.parsingContext().foundRequired(loader.requiredGroup);
                context.param(loader.bindName, theOptionVal);
            }
        }
        if (!argumentAsOption) {
            for (OptionLoader loader : optionLoaders) {
                String bindName = loader.bindName;
                String value = commandLineParser.getString(loader.lead1, loader.lead2);
                if (!S.notBlank((String)value)) continue;
                if (loader.required) {
                    context.parsingContext().foundRequired(loader.requiredGroup);
                }
                context.param(bindName, value);
            }
        }
        context.parsingContext().raiseExceptionIfThereAreMissingOptions(context);
    }

    @Override
    protected ParamValueLoader findContextSpecificLoader(String bindName, Class rawType, BeanSpec spec, Type type, Annotation[] annotations) {
        Optional optional;
        boolean isArray = rawType.isArray();
        StringValueResolver resolver = this.findResolver(spec, rawType, isArray);
        Required required = CliContextParamLoader.filter(annotations, Required.class);
        Optional optional2 = optional = null == required ? CliContextParamLoader.filter(annotations, Optional.class) : null;
        if (null != required) {
            return new OptionLoader(bindName, required, resolver, spec);
        }
        if (null != optional) {
            return new OptionLoader(bindName, optional, resolver, spec);
        }
        return isArray ? new CliVarArgumentLoader(rawType.getComponentType(), resolver) : new CliArgumentLoader(resolver);
    }

    private StringValueResolver findResolver(BeanSpec spec, Class rawType, boolean isArray) {
        StringValueResolver resolver = this.findAnnotatedResolver(spec, rawType);
        return null == resolver ? this.findImplictResolver(spec, rawType, isArray) : resolver;
    }

    private StringValueResolver findAnnotatedResolver(BeanSpec spec, Class rawType) {
        StringValueResolver resolver = this.findDirectAnnotatedResolver(spec, rawType);
        return null == resolver ? this.findIndirectAnnotatedResolver(spec, rawType) : resolver;
    }

    private StringValueResolver findDirectAnnotatedResolver(BeanSpec spec, Class rawType) {
        Resolve resolve = (Resolve)spec.getAnnotation(Resolve.class);
        if (null != resolve) {
            Class[] resolvers;
            for (Class resolverClass : resolvers = resolve.value()) {
                StringValueResolver resolver = (StringValueResolver)this.injector.get(resolverClass);
                if (!rawType.isAssignableFrom(resolver.targetType())) continue;
                return resolver;
            }
        }
        return null;
    }

    private StringValueResolver findIndirectAnnotatedResolver(BeanSpec spec, Class rawType) {
        Annotation[] aa;
        for (Annotation a : aa = spec.allAnnotations()) {
            Class[] resolvers;
            Resolve resolve = (Resolve)AnnotationUtil.tagAnnotation((Annotation)a, Resolve.class);
            if (null == resolve) continue;
            for (Class resolverClass : resolvers = resolve.value()) {
                StringValueResolver resolver = (StringValueResolver)this.injector.get(resolverClass);
                resolver.attributes($.evaluate((Annotation)a));
                if (!rawType.isAssignableFrom(resolver.targetType())) continue;
                return resolver;
            }
        }
        return null;
    }

    private StringValueResolver findImplictResolver(BeanSpec spec, Class rawType, boolean isArray) {
        return isArray ? this.resolverManager.resolver(rawType.getComponentType(), (AnnotationAware)spec) : this.resolverManager.resolver(rawType, (AnnotationAware)spec);
    }

    @Override
    protected String paramName(int i) {
        return methodMetaInfoHolder.get().param(i).name();
    }

    private List<OptionLoader> ensureOptionLoaders(Method method, CommandMethodMetaInfo methodMetaInfo) {
        List<OptionLoader> optionLoaders = (List<OptionLoader>)this.optionLoaderRegistry.get(method);
        if (null == optionLoaders) {
            optionLoaders = this.findOptionLoaders(method, methodMetaInfo);
            this.optionLoaderRegistry.put(method, optionLoaders);
        }
        return optionLoaders;
    }

    private List<OptionLoader> findOptionLoaders(Method method, CommandMethodMetaInfo methodMetaInfo) {
        ArrayList<OptionLoader> optionLoaders = new ArrayList<OptionLoader>();
        this.findFieldOptionLoaders(method.getDeclaringClass(), optionLoaders);
        this.findParamOptionLoaders(method, methodMetaInfo, optionLoaders);
        return optionLoaders;
    }

    private void findFieldOptionLoaders(Class c, List<OptionLoader> optionLoaders) {
        for (Field field : $.fieldsOf((Class)c, (boolean)true)) {
            Type type = field.getGenericType();
            Annotation[] annotations = field.getAnnotations();
            String bindName = CliContextParamLoader.bindName(annotations, field.getName());
            BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])annotations, (String)bindName, (Injector)this.injector);
            ParamValueLoader loader = this.findContextSpecificLoader(bindName, field.getDeclaringClass(), spec, type, annotations);
            if (!(loader instanceof OptionLoader)) continue;
            optionLoaders.add((OptionLoader)loader);
        }
    }

    private void findParamOptionLoaders(Method m, CommandMethodMetaInfo methodMetaInfo, List<OptionLoader> optionLoaders) {
        Type[] types = m.getGenericParameterTypes();
        int len = types.length;
        if (len == 0) {
            return;
        }
        Annotation[][] allAnnotations = m.getParameterAnnotations();
        for (int i = len - 1; i >= 0; --i) {
            ParamValueLoader loader;
            Annotation[] annotations = allAnnotations[i];
            Type type = types[i];
            BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])annotations, null, (Injector)this.injector);
            String bindName = CliContextParamLoader.tryFindBindName(annotations, spec.name());
            if (null == bindName) {
                bindName = methodMetaInfo.param(i).name();
            }
            if ((loader = this.findContextSpecificLoader(bindName, spec.rawType(), spec, type, annotations)) instanceof OptionLoader) {
                optionLoaders.add((OptionLoader)loader);
                continue;
            }
            if ($.isSimpleType((Class)spec.rawType())) continue;
        }
    }
}

