/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.Act;
import act.app.App;
import act.inject.DependencyInjector;
import act.inject.param.ParamKey;
import act.inject.param.ParamTree;
import act.inject.param.ParamTreeNode;
import act.inject.param.ParamValueLoader;
import act.inject.param.ParamValueLoaderService;
import act.util.ActContext;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.inject.BeanSpec;
import org.osgl.mvc.result.BadRequest;
import org.osgl.mvc.util.Binder;
import org.osgl.mvc.util.ParamValueProvider;
import org.osgl.util.AnnotationAware;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

class CollectionLoader
implements ParamValueLoader {
    private final ParamKey key;
    private final Class<? extends Collection> collectionClass;
    private final Type elementType;
    private final DependencyInjector<?> injector;
    private final StringValueResolver resolver;
    private final Binder binder;
    private final Map<ParamKey, ParamValueLoader> childLoaders = new HashMap<ParamKey, ParamValueLoader>();
    private final ParamValueLoaderService manager;
    private final boolean isChar;
    private final BeanSpec targetSpec;

    CollectionLoader(ParamKey key, Class<? extends Collection> collection, Type elementType, BeanSpec targetSpec, DependencyInjector<?> injector, ParamValueLoaderService manager) {
        this.key = key;
        this.collectionClass = collection;
        this.elementType = elementType;
        this.isChar = Character.TYPE == elementType || Character.class == elementType;
        this.injector = injector;
        this.manager = manager;
        App app = Act.app();
        Class rawType = BeanSpec.rawTypeOf((Type)elementType);
        this.binder = app.binderManager().binder(rawType);
        this.targetSpec = targetSpec;
        this.resolver = null == this.binder ? App.instance().resolverManager().resolver(rawType, (AnnotationAware)targetSpec) : null;
    }

    @Override
    public String bindName() {
        return this.key.toString();
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        Collection collection;
        ParamTree tree = ParamValueLoaderService.ensureParamTree(context);
        ParamTreeNode node = tree.node(this.key);
        if (null == node) {
            return noDefaultValue ? null : this.injector.get(this.collectionClass);
        }
        Collection collection2 = collection = null == bean ? this.injector.get(this.collectionClass) : (Collection)bean;
        if (node.isList()) {
            List<ParamTreeNode> nodes = node.list();
            if (nodes.size() > 0) {
                String value = nodes.get(0).value();
                for (int i = 0; i < nodes.size(); ++i) {
                    ParamTreeNode elementNode = nodes.get(i);
                    if (!elementNode.isLeaf()) {
                        throw new BadRequest("cannot parse param: expect leaf node, found: \n%s", new Object[]{node.debug()});
                    }
                    context.attribute("__file_id__", i);
                    if (null != this.binder) {
                        collection.add(this.binder.resolve(null, elementNode.value(), context));
                        continue;
                    }
                    collection.add(this.resolver.resolve(elementNode.value()));
                }
            }
        } else if (node.isMap()) {
            Set<String> childrenKeys = node.mapKeys();
            for (String s : childrenKeys) {
                int id;
                try {
                    id = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    throw new BadRequest("cannot parse param: list index is not a number: %s", new Object[]{s});
                }
                ParamTreeNode child = node.child(s);
                if (child.isLeaf()) {
                    if (null == child.value()) continue;
                    if (null != this.binder) {
                        CollectionLoader.addToCollection(collection, id, this.binder.resolve(null, child.value(), context));
                        continue;
                    }
                    CollectionLoader.addToCollection(collection, id, this.resolver.resolve(child.value()));
                    continue;
                }
                ParamValueLoader childLoader = this.childLoader(child.key());
                CollectionLoader.addToCollection(collection, id, childLoader.load(null, context, false));
            }
        } else {
            this.resolveInto(collection, node.value(), context);
        }
        return collection;
    }

    private ParamValueLoader childLoader(ParamKey key) {
        ParamValueLoader loader = this.childLoaders.get(key);
        if (null == loader) {
            loader = this.buildChildLoader(key);
            this.childLoaders.put(key, loader);
        }
        return loader;
    }

    private ParamValueLoader buildChildLoader(ParamKey key) {
        return this.manager.buildLoader(key, this.elementType, this.targetSpec);
    }

    private static void addToCollection(Collection collection, int index, Object bean) {
        if (collection instanceof List) {
            CollectionLoader.addToList((List)collection, index, bean);
        } else {
            collection.add(bean);
        }
    }

    private static void addToList(List list, int index, Object bean) {
        while (list.size() < index + 1) {
            list.add(null);
        }
        list.set(index, bean);
    }

    private void resolveInto(Collection collection, String value, ActContext context) {
        if (S.blank((String)value)) {
            return;
        }
        String[] sa = value.split("[,;]+");
        boolean isChar = this.isChar;
        for (String s : sa) {
            if (isChar) {
                char[] ca;
                for (char c : ca = s.toCharArray()) {
                    collection.add(Character.valueOf(c));
                }
                continue;
            }
            if (null != this.binder) {
                collection.add(this.binder.resolve(null, s, (ParamValueProvider)context));
                continue;
            }
            collection.add(this.resolver.resolve(s));
        }
    }
}

