/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.app.App;
import act.app.AppClassLoader;
import act.app.AppServiceBase;
import act.inject.DependencyInjector;
import act.inject.param.JsonDTO;
import act.inject.param.JsonDTOClassGenerator;
import act.inject.param.NoBind;
import act.inject.param.ParamValueLoaderService;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.UnexpectedException;
import org.osgl.inject.BeanSpec;
import org.osgl.util.E;
import org.osgl.util.Generics;
import org.osgl.util.S;

public class JsonDTOClassManager
extends AppServiceBase<JsonDTOClassManager> {
    private ConcurrentMap<String, Class<? extends JsonDTO>> dtoClasses = new ConcurrentHashMap<String, Class<? extends JsonDTO>>();
    private DependencyInjector<?> injector;
    private DynamicClassLoader dynamicClassLoader;
    public static final Osgl.Predicate<Class<?>> CLASS_FILTER = new Osgl.Predicate<Class<?>>(){

        public boolean test(Class<?> aClass) {
            if (null == aClass || Object.class == aClass) {
                return false;
            }
            Annotation[] annotations = aClass.getDeclaredAnnotations();
            if (null == annotations) {
                return true;
            }
            for (Annotation a : annotations) {
                if (a.annotationType() != NoBind.class) continue;
                return false;
            }
            return true;
        }
    };
    public static final Osgl.Predicate<Field> FIELD_FILTER = new Osgl.Predicate<Field>(){

        public boolean test(Field field) {
            return !Modifier.isStatic(field.getModifiers());
        }
    };
    private static final Comparator<BeanSpec> CMP = new Comparator<BeanSpec>(){

        @Override
        public int compare(BeanSpec o1, BeanSpec o2) {
            return o1.name().compareTo(o2.name());
        }
    };

    public JsonDTOClassManager(App app) {
        super(app);
        this.injector = app.injector();
        this.dynamicClassLoader = new DynamicClassLoader(app.classLoader());
    }

    @Override
    protected void releaseResources() {
    }

    public Class<? extends JsonDTO> get(Class<?> host, Method method) {
        List<BeanSpec> beanSpecs = this.beanSpecs(host, method);
        String key = JsonDTOClassManager.key(beanSpecs);
        if (S.blank((String)key)) {
            return null;
        }
        Class<? extends JsonDTO> c = (Class<? extends JsonDTO>)this.dtoClasses.get(key);
        if (null == c) {
            block4: {
                try {
                    c = this.generate(key, beanSpecs);
                }
                catch (LinkageError e) {
                    if (!e.getMessage().contains("duplicate class definition")) break block4;
                    return (Class)this.dtoClasses.get(key);
                }
            }
            this.dtoClasses.putIfAbsent(key, c);
        }
        return c;
    }

    private Class<? extends JsonDTO> generate(String name, List<BeanSpec> beanSpecs) {
        return new JsonDTOClassGenerator(name, beanSpecs, this.dynamicClassLoader).generate();
    }

    public List<BeanSpec> beanSpecs(Class<?> host, Method method) {
        ArrayList<BeanSpec> list = new ArrayList<BeanSpec>();
        if (!Modifier.isStatic(method.getModifiers())) {
            this.extractBeanSpec(list, $.fieldsOf(host, CLASS_FILTER, FIELD_FILTER), host);
        }
        this.extractBeanSpec(list, method, host);
        Collections.sort(list, CMP);
        return list;
    }

    private void extractBeanSpec(List<BeanSpec> beanSpecs, List<Field> fields, Class<?> host) {
        for (Field field : fields) {
            Type bound;
            TypeVariable tv;
            Type[] bounds;
            BeanSpec spec = null;
            Type genericType = field.getGenericType();
            if (genericType instanceof Class || genericType instanceof ParameterizedType) {
                spec = BeanSpec.of((Type)field.getGenericType(), (Annotation[])field.getDeclaredAnnotations(), (String)field.getName(), this.injector);
            } else if (genericType instanceof TypeVariable && (bounds = (tv = (TypeVariable)genericType).getBounds()) != null && bounds.length == 1 && ((bound = bounds[0]) instanceof ParameterizedType || bound instanceof Class)) {
                Constructor<?>[] ca;
                Class boundClass = BeanSpec.rawTypeOf((Type)bound);
                block1: for (Constructor<?> c : ca = host.getConstructors()) {
                    Type[] constructorParams;
                    if (c.getAnnotation(Inject.class) == null) continue;
                    for (Type paramType : constructorParams = c.getGenericParameterTypes()) {
                        Class paramClass;
                        if (!(paramType instanceof ParameterizedType) && !(paramType instanceof Class) || !boundClass.isAssignableFrom(paramClass = BeanSpec.rawTypeOf((Type)paramType))) continue;
                        spec = BeanSpec.of((Type)paramType, (Annotation[])field.getDeclaredAnnotations(), (String)field.getName(), this.injector);
                        break block1;
                    }
                }
            }
            if (null == spec) {
                throw E.unexpected((String)"Cannot determine bean spec of field: %s", (Object[])new Object[]{field});
            }
            if (ParamValueLoaderService.noBindOrProvided(spec, this.injector)) continue;
            beanSpecs.add(spec);
        }
    }

    private void extractBeanSpec(List<BeanSpec> beanSpecs, Method method, Class host) {
        Type[] paramTypes = method.getGenericParameterTypes();
        int sz = paramTypes.length;
        if (0 == sz) {
            return;
        }
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < sz; ++i) {
            Annotation[] anno;
            BeanSpec spec;
            Type type = paramTypes[i];
            if (type instanceof TypeVariable && !Modifier.isStatic(method.getModifiers())) {
                TypeVariable typeVar = (TypeVariable)$.cast((Object)type);
                String typeVarName = typeVar.getName();
                Map typeVarLookup = Generics.buildTypeParamImplLookup((Class)host);
                type = (Type)typeVarLookup.get(typeVarName);
                if (null == type) {
                    throw new UnexpectedException("Cannot determine concrete type of method parameter %s", new Object[]{typeVarName});
                }
            }
            if (ParamValueLoaderService.noBindOrProvided(spec = BeanSpec.of((Type)type, (Annotation[])(anno = annotations[i]), this.injector), this.injector)) continue;
            beanSpecs.add(spec);
        }
    }

    private static String key(List<BeanSpec> beanSpecs) {
        S.Buffer sb = S.buffer();
        for (BeanSpec beanSpec : beanSpecs) {
            sb.append(beanSpec.name()).append(beanSpec.type().hashCode());
        }
        return sb.toString();
    }

    static class DynamicClassLoader
    extends ClassLoader {
        private DynamicClassLoader(AppClassLoader parent) {
            super(parent);
        }

        Class<?> defineClass(String name, byte[] b) {
            AppClassLoader loader = (AppClassLoader)this.getParent();
            return loader.defineClass(name, b, 0, b.length, true);
        }
    }
}

