/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.app.App;
import act.app.data.StringValueResolverManager;
import act.inject.DependencyInjector;
import act.inject.param.ParamKey;
import act.inject.param.ParamTree;
import act.inject.param.ParamTreeNode;
import act.inject.param.ParamValueLoader;
import act.inject.param.ParamValueLoaderService;
import act.util.ActContext;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.inject.BeanSpec;
import org.osgl.mvc.result.BadRequest;
import org.osgl.util.AnnotationAware;
import org.osgl.util.E;
import org.osgl.util.StringValueResolver;

class MapLoader
implements ParamValueLoader {
    private final ParamKey key;
    private final Class<? extends Map> mapClass;
    private final Class keyClass;
    private final Type valType;
    private final DependencyInjector<?> injector;
    private final StringValueResolver keyResolver;
    private final StringValueResolver valueResolver;
    private final Map<ParamKey, ParamValueLoader> childLoaders = new HashMap<ParamKey, ParamValueLoader>();
    private final ParamValueLoaderService manager;
    private final BeanSpec targetSpec;

    MapLoader(ParamKey key, Class<? extends Map> mapClass, Type keyType, Type valType, BeanSpec targetSpec, DependencyInjector<?> injector, ParamValueLoaderService manager) {
        this.key = key;
        this.mapClass = mapClass;
        this.keyClass = BeanSpec.rawTypeOf((Type)keyType);
        this.valType = valType;
        this.injector = injector;
        this.manager = manager;
        this.targetSpec = targetSpec;
        StringValueResolverManager resolverManager = App.instance().resolverManager();
        Class valClass = BeanSpec.rawTypeOf((Type)valType);
        this.valueResolver = resolverManager.resolver(valClass, (AnnotationAware)BeanSpec.of((Class)valClass, injector));
        this.keyResolver = resolverManager.resolver(this.keyClass, (AnnotationAware)BeanSpec.of((Class)this.keyClass, injector));
        if (null == this.keyResolver) {
            throw new IllegalArgumentException("Map key type not resolvable: " + this.keyClass.getName());
        }
    }

    @Override
    public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
        Map map;
        ParamTree tree = ParamValueLoaderService.ensureParamTree(context);
        ParamTreeNode node = tree.node(this.key);
        if (null == node) {
            return noDefaultValue ? null : this.injector.get(this.mapClass);
        }
        Map map2 = map = null == bean ? this.injector.get(this.mapClass) : (Map)bean;
        if (node.isList()) {
            if (Integer.class != this.keyClass) {
                throw new BadRequest("cannot load list into map with key type: %s", new Object[]{this.keyClass});
            }
            List<ParamTreeNode> list = node.list();
            for (int i = 0; i < list.size(); ++i) {
                ParamTreeNode elementNode = list.get(i);
                if (!elementNode.isLeaf()) {
                    throw new BadRequest("cannot parse param: expect leaf node, found: \n%s", new Object[]{node.debug()});
                }
                if (null == this.valueResolver) {
                    throw E.unexpected((String)"Component type not resolvable: %s", (Object[])new Object[]{this.valType});
                }
                if (null == elementNode.value()) continue;
                map.put(i, this.valueResolver.resolve(elementNode.value()));
            }
        } else if (node.isMap()) {
            Set<String> childrenKeys = node.mapKeys();
            Class valClass = BeanSpec.rawTypeOf((Type)this.valType);
            for (String s : childrenKeys) {
                Object value;
                ParamTreeNode child = node.child(s);
                Object key = s;
                if (String.class != this.keyClass) {
                    key = this.keyResolver.resolve(s);
                }
                if (child.isLeaf()) {
                    if (null == this.valueResolver) {
                        throw E.unexpected((String)"Component type not resolvable: %s", (Object[])new Object[]{this.valType});
                    }
                    String sval = child.value();
                    if (null == sval) continue;
                    if (valClass != String.class) {
                        value = this.valueResolver.resolve(sval);
                        if (!valClass.isInstance(value)) {
                            throw new BadRequest("Cannot load parameter, expected type: %s, found: %s", new Object[]{valClass, value.getClass()});
                        }
                        map.put(key, value);
                        continue;
                    }
                    map.put(key, sval);
                    continue;
                }
                ParamValueLoader childLoader = this.childLoader(child.key());
                value = childLoader.load(null, context, false);
                if (null == value) continue;
                if (!valClass.isInstance(value)) {
                    throw new BadRequest("Cannot load parameter, expected type: %s, found: %s", new Object[]{valClass, value.getClass()});
                }
                map.put(key, value);
            }
        } else {
            throw new BadRequest("Cannot load parameter, expected map, found:%s", new Object[]{node.value()});
        }
        return map;
    }

    @Override
    public String bindName() {
        return this.key.toString();
    }

    private ParamValueLoader childLoader(ParamKey key) {
        ParamValueLoader loader = this.childLoaders.get(key);
        if (null == loader) {
            loader = this.buildChildLoader(key);
            this.childLoaders.put(key, loader);
        }
        return loader;
    }

    private ParamValueLoader buildChildLoader(ParamKey key) {
        return this.manager.buildLoader(key, this.valType, this.targetSpec);
    }
}

