/*
 * Decompiled with CFR 0.152.
 */
package act.inject.param;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.data.BinderManager;
import act.app.data.StringValueResolverManager;
import act.controller.ActionMethodParamAnnotationHandler;
import act.inject.ActProviders;
import act.inject.Context;
import act.inject.DefaultValue;
import act.inject.DependencyInjector;
import act.inject.SessionVariable;
import act.inject.genie.DependentScope;
import act.inject.genie.GenieInjector;
import act.inject.genie.RequestScope;
import act.inject.genie.SessionScope;
import act.inject.param.BoundedValueLoader;
import act.inject.param.CollectionLoader;
import act.inject.param.FieldLoader;
import act.inject.param.JsonParamValueLoader;
import act.inject.param.MapLoader;
import act.inject.param.NoBind;
import act.inject.param.ParamKey;
import act.inject.param.ParamTree;
import act.inject.param.ParamValueLoader;
import act.inject.param.ProvidedValueLoader;
import act.inject.param.ScopeCacheSupport;
import act.inject.param.ScopedParamValueLoader;
import act.inject.param.StringValueResolverValueLoader;
import act.util.ActContext;
import act.util.DestroyableBase;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.New;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.Constraint;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.UnexpectedException;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.InjectException;
import org.osgl.inject.annotation.Provided;
import org.osgl.inject.annotation.SessionScoped;
import org.osgl.inject.util.AnnotationUtil;
import org.osgl.inject.util.ArrayLoader;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.mvc.annotation.Bind;
import org.osgl.mvc.annotation.Param;
import org.osgl.mvc.result.Result;
import org.osgl.mvc.util.Binder;
import org.osgl.util.AnnotationAware;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.Generics;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public abstract class ParamValueLoaderService
extends DestroyableBase {
    protected Logger logger = LogManager.get(this.getClass());
    private static final ParamValueLoader[] DUMB = new ParamValueLoader[0];
    private static final ThreadLocal<ParamTree> PARAM_TREE = new ThreadLocal();
    private static final ParamValueLoader RESULT_LOADER = new ParamValueLoader(){

        @Override
        public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
            return context.attribute("__result__");
        }

        @Override
        public String bindName() {
            return null;
        }
    };
    private static final ParamValueLoader EXCEPTION_LOADED = new ParamValueLoader(){

        @Override
        public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
            return context.attribute("__exception__");
        }

        @Override
        public String bindName() {
            return null;
        }
    };
    private static final Set<String> fieldBlackList = new HashSet<String>();
    StringValueResolverManager resolverManager;
    BinderManager binderManager;
    DependencyInjector<?> injector;
    ConcurrentMap<Method, ParamValueLoader[]> methodRegistry = new ConcurrentHashMap<Method, ParamValueLoader[]>();
    Map<Method, Boolean> methodValidationConstraintLookup = new HashMap<Method, Boolean>();
    ConcurrentMap<Class, Map<Field, ParamValueLoader>> fieldRegistry = new ConcurrentHashMap<Class, Map<Field, ParamValueLoader>>();
    ConcurrentMap<Class, ParamValueLoader> classRegistry = new ConcurrentHashMap<Class, ParamValueLoader>();
    private ConcurrentMap<Osgl.T2<Type, Annotation[]>, ParamValueLoader> paramRegistry = new ConcurrentHashMap<Osgl.T2<Type, Annotation[]>, ParamValueLoader>();
    private ConcurrentMap<BeanSpec, Map<Class<? extends Annotation>, ActionMethodParamAnnotationHandler>> annoHandlers = new ConcurrentHashMap<BeanSpec, Map<Class<? extends Annotation>, ActionMethodParamAnnotationHandler>>();
    private Map<Class<? extends Annotation>, ActionMethodParamAnnotationHandler> allAnnotationHandlers;
    private Validator validator;
    private volatile ExecutableValidator executableValidator;

    public ParamValueLoaderService(App app) {
        this.resolverManager = app.resolverManager();
        this.binderManager = app.binderManager();
        this.injector = app.injector();
        this.allAnnotationHandlers = new HashMap<Class<? extends Annotation>, ActionMethodParamAnnotationHandler>();
        List<ActionMethodParamAnnotationHandler> list = Act.pluginManager().pluginList(ActionMethodParamAnnotationHandler.class);
        for (ActionMethodParamAnnotationHandler h : list) {
            Set<Class<? extends Annotation>> set = h.listenTo();
            for (Class<? extends Annotation> c : set) {
                this.allAnnotationHandlers.put(c, h);
            }
        }
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.classRegistry.values(), ApplicationScoped.class);
        Destroyable.Util.tryDestroyAll(this.paramRegistry.values(), ApplicationScoped.class);
    }

    public Object loadHostBean(Class beanClass, ActContext<?> ctx) {
        ParamValueLoader loader = (ParamValueLoader)this.classRegistry.get(beanClass);
        if (null == loader) {
            loader = this.findBeanLoader(beanClass);
            this.classRegistry.putIfAbsent(beanClass, loader);
        }
        return loader.load(null, ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] loadMethodParams(Object host, Method method, ActContext ctx) {
        try {
            Set violations;
            ParamValueLoader[] loaders = (ParamValueLoader[])this.methodRegistry.get(method);
            Boolean hasValidationConstraint = this.methodValidationConstraintLookup.get(method);
            if (null == loaders) {
                Osgl.Var boolBag = $.var((Object)Boolean.FALSE);
                Class<?> hostClass = null == host ? null : host.getClass();
                loaders = this.findMethodParamLoaders(method, hostClass, (Osgl.Var<Boolean>)boolBag);
                this.methodRegistry.putIfAbsent(method, loaders);
                hasValidationConstraint = (Boolean)boolBag.get();
                if (hasValidationConstraint.booleanValue() && null == host) {
                    this.logger.error("Cannot validate static method: %s", new Object[]{method});
                    hasValidationConstraint = false;
                }
                this.methodValidationConstraintLookup.put(method, hasValidationConstraint);
            }
            int sz = loaders.length;
            Object[] params = new Object[sz];
            for (int i = 0; i < sz; ++i) {
                params[i] = loaders[i].load(null, ctx, false);
            }
            if (null != hasValidationConstraint && hasValidationConstraint.booleanValue() && !(violations = (Set)$.cast((Object)this.executableValidator().validateParameters(host, method, params, new Class[0]))).isEmpty()) {
                HashMap<String, ConstraintViolation> map = new HashMap<String, ConstraintViolation>();
                for (ConstraintViolation v : violations) {
                    S.Buffer buf = ctx.strBuf();
                    for (Path.Node node : v.getPropertyPath()) {
                        if (node.getKind() == ElementKind.METHOD) continue;
                        if (node.getKind() == ElementKind.PARAMETER) {
                            Path.ParameterNode pnode = (Path.ParameterNode)node.as(Path.ParameterNode.class);
                            int paramIdx = pnode.getParameterIndex();
                            ParamValueLoader ploader = loaders[paramIdx];
                            buf.append(ploader.bindName());
                            continue;
                        }
                        if (node.getKind() != ElementKind.PROPERTY) continue;
                        buf.append(".").append(node.toString());
                    }
                    map.put(buf.toString(), v);
                }
                ctx.addViolations(map);
            }
            Object[] objectArray = params;
            return objectArray;
        }
        finally {
            PARAM_TREE.remove();
        }
    }

    protected <T> ParamValueLoader findBeanLoader(Class<T> beanClass) {
        final Provider provider = this.injector.getProvider(beanClass);
        final Map<Field, ParamValueLoader> loaders = this.fieldLoaders(beanClass);
        final boolean hasField = !loaders.isEmpty();
        final Osgl.Var hasValidateConstraint = $.var();
        ParamValueLoader loader = new ParamValueLoader(){

            @Override
            public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
                if (null == bean) {
                    bean = provider.get();
                }
                if (!hasField) {
                    return bean;
                }
                try {
                    for (Map.Entry entry : loaders.entrySet()) {
                        Field field = (Field)entry.getKey();
                        ParamValueLoader loader = (ParamValueLoader)entry.getValue();
                        Object fieldValue = loader.load(null, context, noDefaultValue);
                        if (null != fieldValue) {
                            field.set(bean, fieldValue);
                        } else {
                            fieldValue = field.get(bean);
                        }
                        if (null != fieldValue) {
                            context.renderArg(field.getName(), fieldValue);
                        }
                        if (!ParamValueLoaderService.this.hasValidationConstraint(BeanSpec.of((Field)field, ParamValueLoaderService.this.injector))) continue;
                        hasValidateConstraint.set((Object)true);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new InjectException((Throwable)e);
                }
                return bean;
            }

            @Override
            public String bindName() {
                return null;
            }
        };
        return this.decorate(loader, BeanSpec.of(beanClass, this.injector), beanClass.getDeclaredAnnotations(), false, true);
    }

    private boolean shouldWaive(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.isAnnotationPresent(NoBind.class) || fieldBlackList.contains(field.getName()) || Object.class.equals(field.getDeclaringClass());
    }

    private <T> Map<Field, ParamValueLoader> fieldLoaders(Class<T> beanClass) {
        HashMap<Field, ParamValueLoader> fieldLoaders = (HashMap<Field, ParamValueLoader>)this.fieldRegistry.get(beanClass);
        if (null == fieldLoaders) {
            fieldLoaders = new HashMap<Field, ParamValueLoader>();
            for (Field field : $.fieldsOf(beanClass, (boolean)true)) {
                if (this.shouldWaive(field)) continue;
                Type type = field.getGenericType();
                Annotation[] annotations = field.getAnnotations();
                BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])annotations, (String)field.getName(), this.injector);
                ParamValueLoader loader = this.paramValueLoaderOf(spec);
                boolean provided = loader instanceof ProvidedValueLoader;
                if (null == loader || provided) continue;
                fieldLoaders.put(field, loader);
            }
            this.fieldRegistry.putIfAbsent(beanClass, fieldLoaders);
        }
        return fieldLoaders;
    }

    protected ParamValueLoader[] findMethodParamLoaders(Method method, Class host, Osgl.Var<Boolean> hasValidationConstraint) {
        Type[] types = method.getGenericParameterTypes();
        int sz = types.length;
        if (0 == sz) {
            return DUMB;
        }
        ParamValueLoader[] loaders = new ParamValueLoader[sz];
        Annotation[][] annotations = method.getParameterAnnotations();
        for (int i = 0; i < sz; ++i) {
            ParamValueLoader loader;
            BeanSpec spec;
            String name = this.paramName(i);
            Type type = types[i];
            if (type instanceof TypeVariable) {
                TypeVariable var = (TypeVariable)$.cast((Object)type);
                if (null != host) {
                    type = (Type)Generics.buildTypeParamImplLookup((Class)host).get(var.getName());
                }
                if (null == type) {
                    throw new UnexpectedException("Cannot infer param type: %s", new Object[]{var.getName()});
                }
            }
            if (this.hasValidationConstraint(spec = BeanSpec.of((Type)type, (Annotation[])annotations[i], (String)name, this.injector))) {
                hasValidationConstraint.set((Object)true);
            }
            if (null == (loader = this.paramValueLoaderOf(spec))) {
                throw new UnexpectedException("Cannot find param value loader for param: " + spec);
            }
            loaders[i] = loader;
        }
        return loaders;
    }

    private ParamValueLoader paramValueLoaderOf(BeanSpec spec) {
        return this.paramValueLoaderOf(spec, null);
    }

    private ParamValueLoader paramValueLoaderOf(BeanSpec spec, String bindName) {
        Annotation[] annotations;
        Class rawType = spec.rawType();
        if (Result.class.isAssignableFrom(rawType)) {
            return RESULT_LOADER;
        }
        if (Exception.class.isAssignableFrom(rawType)) {
            return EXCEPTION_LOADED;
        }
        Type type = spec.type();
        Osgl.T2 key = $.T2((Object)type, (Object)(annotations = spec.allAnnotations()));
        ParamValueLoader loader = (ParamValueLoader)this.paramRegistry.get(key);
        if (null == loader && null != (loader = this.findLoader(spec, type, annotations, bindName))) {
            this.paramRegistry.putIfAbsent((Osgl.T2<Type, Annotation[]>)key, loader);
        }
        return loader;
    }

    protected abstract ParamValueLoader findContextSpecificLoader(String var1, Class var2, BeanSpec var3, Type var4, Annotation[] var5);

    protected final ParamValueLoader binder(BeanSpec spec, String bindName) {
        Binder binder;
        Class rawType = spec.rawType();
        BoundedValueLoader loader = null;
        Bind bind = (Bind)spec.getAnnotation(Bind.class);
        if (null != bind) {
            for (Class binderClass : bind.value()) {
                Binder binder2 = (Binder)this.injector.get(binderClass);
                if (!rawType.isAssignableFrom(binder2.targetType())) continue;
                loader = new BoundedValueLoader(binder2, bindName);
                break;
            }
        }
        if (null == loader) {
            Annotation[] aa = spec.allAnnotations();
            block1: for (Annotation a : aa) {
                Bind bind2 = (Bind)AnnotationUtil.tagAnnotation((Annotation)a, Bind.class);
                if (null == bind2) continue;
                for (Class binderClass : bind2.value()) {
                    Binder binder3 = (Binder)this.injector.get(binderClass);
                    binder3.attributes($.evaluate((Annotation)a));
                    if (!rawType.isAssignableFrom(binder3.targetType())) continue;
                    loader = new BoundedValueLoader(binder3, bindName);
                    continue block1;
                }
            }
        }
        if (null == loader && null != (binder = this.binderManager.binder(rawType))) {
            loader = new BoundedValueLoader(binder, bindName);
        }
        return loader;
    }

    protected String paramName(int i) {
        return null;
    }

    protected boolean supportJsonDecorator() {
        return false;
    }

    private ParamValueLoader findLoader(BeanSpec spec, Type type, Annotation[] annotations, String bindName) {
        Class rawType;
        ParamValueLoader loader;
        if (ParamValueLoaderService.provided(spec, this.injector)) {
            return ProvidedValueLoader.get(spec, this.injector);
        }
        if (null != ParamValueLoaderService.filter(annotations, NoBind.class)) {
            return null;
        }
        if (null == bindName) {
            bindName = ParamValueLoaderService.bindName(annotations, spec.name());
        }
        if (null == (loader = this.findContextSpecificLoader(bindName, rawType = spec.rawType(), spec, type, annotations))) {
            return null;
        }
        return this.decorate(loader, spec, annotations, this.supportJsonDecorator(), false);
    }

    ParamValueLoader buildLoader(ParamKey key, Type type, BeanSpec targetSpec) {
        Class rawType = BeanSpec.rawTypeOf((Type)type);
        if (rawType.isArray()) {
            return this.buildArrayLoader(key, rawType.getComponentType(), targetSpec);
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            Object elementType = Object.class;
            if (type instanceof ParameterizedType) {
                elementType = ((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return this.buildCollectionLoader(key, rawType, (Type)elementType, targetSpec);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Class mapClass = rawType;
            Type mapType = type;
            boolean canProceed = false;
            Type[] typeParams = null;
            do {
                if (mapType instanceof ParameterizedType && (typeParams = ((ParameterizedType)mapType).getActualTypeArguments()).length == 2) {
                    canProceed = true;
                    break;
                }
                boolean foundInInterfaces = false;
                Type[] ta = mapClass.getGenericInterfaces();
                if (ta.length > 0) {
                    mapType = null;
                    for (Type t : ta) {
                        if (!(t instanceof ParameterizedType) || !Map.class.isAssignableFrom((Class)((ParameterizedType)t).getRawType())) continue;
                        mapType = t;
                        mapClass = mapClass.getSuperclass();
                        foundInInterfaces = true;
                        break;
                    }
                }
                if (foundInInterfaces) continue;
                mapType = mapClass.getGenericSuperclass();
                mapClass = mapClass.getSuperclass();
            } while (mapClass != Object.class);
            E.unexpectedIf((!canProceed ? 1 : 0) != 0, (String)"Cannot load Map type parameter loader: no generic type info available", (Object[])new Object[0]);
            Type keyType = typeParams[0];
            Type valType = typeParams[1];
            return this.buildMapLoader(key, rawType, keyType, valType, targetSpec);
        }
        return this.buildPojoLoader(key, rawType);
    }

    private ParamValueLoader buildArrayLoader(final ParamKey key, final Type elementType, BeanSpec targetSpec) {
        final CollectionLoader collectionLoader = new CollectionLoader(key, ArrayList.class, elementType, targetSpec, this.injector, this);
        return new ParamValueLoader(){

            @Override
            public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
                List<Object> list = new ArrayList();
                if (null != bean) {
                    int len = Array.getLength(bean);
                    for (int i = 0; i < len; ++i) {
                        list.add(Array.get(bean, i));
                    }
                }
                return null == (list = (List)collectionLoader.load(list, context, false)) ? null : ArrayLoader.listToArray(list, (Class)BeanSpec.rawTypeOf((Type)elementType));
            }

            @Override
            public String bindName() {
                return key.toString();
            }
        };
    }

    private ParamValueLoader buildCollectionLoader(ParamKey key, Class<? extends Collection> collectionClass, Type elementType, BeanSpec targetSpec) {
        return new CollectionLoader(key, collectionClass, elementType, targetSpec, this.injector, this);
    }

    private ParamValueLoader buildMapLoader(ParamKey key, Class<? extends Map> mapClass, Type keyType, Type valType, BeanSpec targetSpec) {
        return new MapLoader(key, mapClass, keyType, valType, targetSpec, this.injector, this);
    }

    static ParamTree paramTree() {
        return PARAM_TREE.get();
    }

    static ParamTree ensureParamTree(ActContext context) {
        ParamTree tree = PARAM_TREE.get();
        if (null == tree) {
            tree = new ParamTree();
            tree.build(context);
            PARAM_TREE.set(tree);
        }
        return tree;
    }

    private ParamValueLoader buildPojoLoader(final ParamKey key, final Class type) {
        final List<FieldLoader> fieldLoaders = this.fieldLoaders(key, type);
        return new ParamValueLoader(){

            @Override
            public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
                final Osgl.Var beanBag = $.var((Object)bean);
                Osgl.Factory<Object> beanSource = new Osgl.Factory<Object>(){

                    public Object create() {
                        Object bean = beanBag.get();
                        if (null == bean) {
                            try {
                                bean = ParamValueLoaderService.this.injector.get(type);
                            }
                            catch (RuntimeException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new InjectException((Throwable)e, "cannot instantiate %s", new Object[]{type});
                            }
                        }
                        beanBag.set(bean);
                        return bean;
                    }
                };
                for (FieldLoader fl : fieldLoaders) {
                    fl.applyTo((Osgl.Func0<Object>)beanSource, context);
                }
                return beanBag.get();
            }

            @Override
            public String bindName() {
                return key.toString();
            }
        };
    }

    private ParamValueLoader findLoader(ParamKey paramKey, Field field) {
        BeanSpec spec = BeanSpec.of((Type)field.getGenericType(), (Annotation[])field.getDeclaredAnnotations(), this.injector);
        Annotation[] annotations = field.getDeclaredAnnotations();
        if (ParamValueLoaderService.provided(spec, this.injector)) {
            return ProvidedValueLoader.get(spec, this.injector);
        }
        String name = null;
        Named named = ParamValueLoaderService.filter(annotations, Named.class);
        if (null != named) {
            name = named.value();
        }
        if (S.blank(name)) {
            name = field.getName();
        }
        ParamKey key = paramKey.child(name);
        Class<?> fieldType = field.getType();
        StringValueResolver<?> resolver = this.resolverManager.resolver(fieldType, (AnnotationAware)spec);
        if (null != resolver) {
            DefaultValue def = field.getAnnotation(DefaultValue.class);
            return new StringValueResolverValueLoader(key, resolver, null, def, fieldType);
        }
        return this.buildLoader(key, field.getGenericType(), spec);
    }

    private List<FieldLoader> fieldLoaders(ParamKey key, Class type) {
        C.List fieldLoaders = C.newList();
        for (Class current = type; null != current && !current.equals(Object.class); current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                if (this.shouldWaive(field)) continue;
                field.setAccessible(true);
                fieldLoaders.add(this.fieldLoader(key, field));
            }
        }
        return fieldLoaders;
    }

    private FieldLoader fieldLoader(ParamKey key, Field field) {
        return new FieldLoader(field, this.findLoader(key, field));
    }

    static <T extends Annotation> T filter(Annotation[] annotations, Class<T> annoType) {
        for (Annotation annotation : annotations) {
            if (annoType != annotation.annotationType()) continue;
            return (T)annotation;
        }
        return null;
    }

    private ParamValueLoader decorate(ParamValueLoader loader, BeanSpec spec, Annotation[] annotations, boolean useJsonDecorator, boolean useValidationDecorator) {
        ParamValueLoader jsonDecorated;
        ParamValueLoader validationDecorated = jsonDecorated = useJsonDecorator ? new JsonParamValueLoader(loader, spec, this.injector) : loader;
        if (useValidationDecorator) {
            validationDecorated = new ParamValueLoader(){
                private Validator validator = Act.app().getInstance(Validator.class);

                @Override
                public Object load(Object bean, ActContext<?> context, boolean noDefaultValue) {
                    Object object = jsonDecorated.load(bean, context, noDefaultValue);
                    Set violations = (Set)$.cast((Object)this.validator.validate(object, new Class[0]));
                    if (!violations.isEmpty()) {
                        HashMap<String, ConstraintViolation> map = new HashMap<String, ConstraintViolation>();
                        for (ConstraintViolation v : violations) {
                            map.put(v.getPropertyPath().toString(), v);
                        }
                        context.addViolations(map);
                    }
                    return object;
                }

                @Override
                public String bindName() {
                    return jsonDecorated.bindName();
                }
            };
        }
        return new ScopedParamValueLoader(validationDecorated, spec, ParamValueLoaderService.scopeCacheSupport(annotations));
    }

    private boolean hasValidationConstraint(BeanSpec spec) {
        for (Annotation anno : spec.allAnnotations()) {
            Class<? extends Annotation> annoType = anno.annotationType();
            if (Valid.class != annoType && !annoType.isAnnotationPresent(Constraint.class)) continue;
            return true;
        }
        return false;
    }

    private Map<Class<? extends Annotation>, ActionMethodParamAnnotationHandler> paramAnnoHandlers(BeanSpec spec) {
        HashMap<Class<? extends Annotation>, ActionMethodParamAnnotationHandler> handlers = (HashMap<Class<? extends Annotation>, ActionMethodParamAnnotationHandler>)this.annoHandlers.get(spec);
        if (null != handlers) {
            return handlers;
        }
        handlers = new HashMap<Class<? extends Annotation>, ActionMethodParamAnnotationHandler>();
        for (Annotation annotation : spec.allAnnotations()) {
            Class<? extends Annotation> c = annotation.annotationType();
            ActionMethodParamAnnotationHandler h = this.allAnnotationHandlers.get(c);
            if (null == h) continue;
            handlers.put(c, h);
        }
        this.annoHandlers.putIfAbsent(spec, handlers);
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutableValidator executableValidator() {
        if (null == this.executableValidator) {
            ParamValueLoaderService paramValueLoaderService = this;
            synchronized (paramValueLoaderService) {
                if (null == this.executableValidator) {
                    this.validator = Act.getInstance(Validator.class);
                    this.executableValidator = this.validator.forExecutables();
                }
            }
        }
        return this.executableValidator;
    }

    private static ScopeCacheSupport scopeCacheSupport(Annotation[] annotations) {
        if (null != ParamValueLoaderService.filter(annotations, RequestScoped.class) || null != ParamValueLoaderService.filter(annotations, org.osgl.inject.annotation.RequestScoped.class)) {
            return RequestScope.INSTANCE;
        }
        if (ParamValueLoaderService.sessionScoped(annotations)) {
            return SessionScope.INSTANCE;
        }
        if (null != ParamValueLoaderService.filter(annotations, Dependent.class) || null != ParamValueLoaderService.filter(annotations, New.class)) {
            return DependentScope.INSTANCE;
        }
        return RequestScope.INSTANCE;
    }

    static boolean sessionScoped(Annotation[] annotations) {
        return null != ParamValueLoaderService.filter(annotations, javax.enterprise.context.SessionScoped.class) || null != ParamValueLoaderService.filter(annotations, SessionScoped.class) || null != ParamValueLoaderService.filter(annotations, SessionVariable.class);
    }

    public static void waiveFields(String ... fieldNames) {
        fieldBlackList.addAll((Collection<String>)C.listOf((Object[])fieldNames));
    }

    public static String bindName(Annotation[] annotations, String defVal) {
        String name = ParamValueLoaderService.tryFindBindName(annotations, defVal);
        E.illegalStateIf((null == name ? 1 : 0) != 0, (String)"Cannot find bind name");
        return name;
    }

    static String tryFindBindName(Annotation[] annotations, String defVal) {
        Param param = ParamValueLoaderService.filter(annotations, Param.class);
        if (null != param && S.notBlank((String)param.value())) {
            return param.value();
        }
        Bind bind = ParamValueLoaderService.filter(annotations, Bind.class);
        if (null != bind && S.notBlank((String)bind.model())) {
            return bind.model();
        }
        Named named = ParamValueLoaderService.filter(annotations, Named.class);
        if (null != named && S.notBlank((String)named.value())) {
            return named.value();
        }
        if (S.notBlank((String)defVal)) {
            return defVal;
        }
        return null;
    }

    public static String bindName(BeanSpec beanSpec) {
        return ParamValueLoaderService.bindName(beanSpec.allAnnotations(), beanSpec.name());
    }

    public static boolean provided(BeanSpec beanSpec, DependencyInjector<?> injector) {
        Class rawType = beanSpec.rawType();
        GenieInjector genieInjector = (GenieInjector)$.cast(injector);
        return ActProviders.isProvided(rawType) || null != beanSpec.getAnnotation(Inject.class) || null != beanSpec.getAnnotation(Provided.class) || null != beanSpec.getAnnotation(Context.class) || null != beanSpec.getAnnotation(Singleton.class) || null != beanSpec.getAnnotation(ApplicationScoped.class) || genieInjector.subjectToInject(beanSpec);
    }

    public static boolean noBindOrProvided(BeanSpec beanSpec, DependencyInjector<?> injector) {
        return null != beanSpec.getAnnotation(NoBind.class) || ParamValueLoaderService.provided(beanSpec, injector) || beanSpec.isInstanceOf(Throwable.class);
    }
}

