/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.app.AppServiceBase;
import act.app.AppThreadFactory;
import act.app.event.AppEventId;
import act.event.AppEventListenerBase;
import act.event.OnceEventListenerBase;
import act.job.JobContext;
import act.job.JobTrigger;
import act.job._Job;
import act.mail.MailerContext;
import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.utils.Time;

public class AppJobManager
extends AppServiceBase<AppJobManager> {
    private ScheduledThreadPoolExecutor executor;
    private ConcurrentMap<String, _Job> jobs = new ConcurrentHashMap<String, _Job>();
    private ConcurrentMap<String, ScheduledFuture> scheduled = new ConcurrentHashMap<String, ScheduledFuture>();

    static String appEventJobId(AppEventId eventId) {
        return S.concat((String)"__act_app__", (String)eventId.toString().toLowerCase());
    }

    public AppJobManager(App app) {
        super(app);
        this.initExecutor(app);
        for (AppEventId appEventId : AppEventId.values()) {
            this.createAppEventListener(appEventId);
        }
    }

    @Override
    protected void releaseResources() {
        for (_Job job : this.jobs.values()) {
            job.destroy();
        }
        this.jobs.clear();
        this.executor.shutdown();
        this.executor.getQueue().clear();
    }

    public <T> Future<T> now(Callable<T> callable) {
        return this.executor().submit(callable);
    }

    public void now(Runnable runnable) {
        this.executor().submit(this.wrap(runnable));
    }

    public <T> Future<T> delay(Callable<T> callable, long delay, TimeUnit timeUnit) {
        return this.executor().schedule(callable, delay, timeUnit);
    }

    public void delay(Runnable runnable, long delay, TimeUnit timeUnit) {
        this.executor().schedule(this.wrap(runnable), delay, timeUnit);
    }

    public <T> Future<T> delay(Callable<T> callable, String delay) {
        int seconds = this.parseTime(delay);
        return this.executor().schedule(callable, (long)seconds, TimeUnit.SECONDS);
    }

    public void delay(Runnable runnable, String delay) {
        int seconds = this.parseTime(delay);
        this.executor().schedule(this.wrap(runnable), (long)seconds, TimeUnit.SECONDS);
    }

    public void every(String id, Runnable runnable, String interval) {
        JobTrigger.every(interval).schedule(this, _Job.multipleTimes(id, runnable, this));
    }

    public void every(Runnable runnable, String interval) {
        JobTrigger.every(interval).schedule(this, _Job.multipleTimes(runnable, this));
    }

    public void every(Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.every(interval, timeUnit).schedule(this, _Job.multipleTimes(runnable, this));
    }

    public void every(String id, Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.every(interval, timeUnit).schedule(this, _Job.multipleTimes(id, runnable, this));
    }

    public void fixedDelay(Runnable runnable, String interval) {
        JobTrigger.every(interval).schedule(this, _Job.multipleTimes(runnable, this));
    }

    public void fixedDelay(String id, Runnable runnable, String interval) {
        JobTrigger.every(interval).schedule(this, _Job.multipleTimes(id, runnable, this));
    }

    public void fixedDelay(Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.fixedDelay(interval, timeUnit).schedule(this, _Job.multipleTimes(runnable, this));
    }

    public void fixedDelay(String id, Runnable runnable, long interval, TimeUnit timeUnit) {
        JobTrigger.fixedDelay(interval, timeUnit).schedule(this, _Job.multipleTimes(id, runnable, this));
    }

    private int parseTime(String timeDuration) {
        if (timeDuration.startsWith("${") && timeDuration.endsWith("}")) {
            timeDuration = (String)this.app().config().get(timeDuration.substring(2, timeDuration.length() - 1));
        }
        return Time.parseDuration((String)timeDuration);
    }

    public void on(DateTime instant, Runnable runnable) {
        DateTime now = DateTime.now();
        E.illegalArgumentIf((boolean)instant.isBefore((ReadableInstant)now));
        Seconds seconds = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)instant);
        this.executor().schedule(this.wrap(runnable), (long)seconds.getSeconds(), TimeUnit.SECONDS);
    }

    public <T> Future<T> on(DateTime instant, Callable<T> callable) {
        DateTime now = DateTime.now();
        E.illegalArgumentIf((boolean)instant.isBefore((ReadableInstant)now));
        Seconds seconds = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)instant);
        return this.executor().schedule(callable, (long)seconds.getSeconds(), TimeUnit.SECONDS);
    }

    public void on(AppEventId appEvent, Runnable runnable) {
        this.on(appEvent, runnable, false);
    }

    public void on(AppEventId appEvent, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        _Job job = this.jobById(AppJobManager.appEventJobId(appEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            job.addPrecedenceJob(_Job.once(runnable, this));
        }
    }

    public void post(AppEventId appEvent, Runnable runnable) {
        this.post(appEvent, runnable, false);
    }

    public void post(AppEventId appEvent, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        _Job job = this.jobById(AppJobManager.appEventJobId(appEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            job.addFollowingJob(_Job.once(runnable, this));
        }
    }

    public void on(AppEventId appEvent, String jobId, Runnable runnable) {
        this.on(appEvent, jobId, runnable, false);
    }

    public void on(AppEventId appEvent, String jobId, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        _Job job = this.jobById(AppJobManager.appEventJobId(appEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            job.addPrecedenceJob(_Job.once(jobId, runnable, this));
        }
    }

    public void post(AppEventId appEvent, String jobId, Runnable runnable) {
        this.post(appEvent, jobId, runnable, false);
    }

    public void post(AppEventId appEvent, String jobId, Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        _Job job = this.jobById(AppJobManager.appEventJobId(appEvent));
        if (null == job) {
            this.processDelayedJob(this.wrap(runnable), runImmediatelyIfEventDispatched);
        } else {
            job.addFollowingJob(_Job.once(jobId, runnable, this));
        }
    }

    private void processDelayedJob(Runnable runnable, boolean runImmediatelyIfEventDispatched) {
        if (runImmediatelyIfEventDispatched) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                Act.LOGGER.error((Throwable)e, "Error running job");
            }
        } else {
            this.now(runnable);
        }
    }

    public void cancel(String jobId) {
        _Job job = this.jobById(jobId);
        if (null != job) {
            this.removeJob(job);
        } else {
            ScheduledFuture future = (ScheduledFuture)this.scheduled.remove(jobId);
            if (null != future) {
                future.cancel(true);
            }
        }
    }

    public void beforeAppStart(Runnable runnable) {
        this.on(AppEventId.START, runnable);
    }

    public void afterAppStart(Runnable runnable) {
        this.post(AppEventId.START, runnable);
    }

    public void beforeAppStop(Runnable runnable) {
        this.on(AppEventId.STOP, runnable);
    }

    C.List<_Job> jobs() {
        return C.list(this.jobs.values());
    }

    C.List<_Job> virtualJobs() {
        final AppJobManager jobManager = Act.jobManager();
        return C.list(this.scheduled.entrySet()).map((Osgl.Function)new Osgl.Transformer<Map.Entry<String, ScheduledFuture>, _Job>(){

            public _Job transform(Map.Entry<String, ScheduledFuture> entry) {
                return new _Job(entry.getKey(), jobManager);
            }
        });
    }

    void futureScheduled(String id, ScheduledFuture future) {
        this.scheduled.putIfAbsent(id, future);
    }

    _Job jobById(String id) {
        _Job job = (_Job)this.jobs.get(id);
        if (null == job) {
            ScheduledFuture future = (ScheduledFuture)this.scheduled.get(id);
            if (null != future) {
                return new _Job(id, Act.jobManager());
            }
            Act.LOGGER.warn("cannot find job by id: %s", new Object[]{id});
        }
        return job;
    }

    void addJob(_Job job) {
        this.jobs.put(job.id(), job);
    }

    void removeJob(_Job job) {
        String id = job.id();
        this.jobs.remove(id);
        ScheduledFuture future = (ScheduledFuture)this.scheduled.remove(id);
        if (null != future) {
            future.cancel(true);
        }
    }

    ScheduledThreadPoolExecutor executor() {
        return this.executor;
    }

    private void initExecutor(App app) {
        int poolSize = app.config().jobPoolSize();
        this.executor = new ScheduledThreadPoolExecutor(poolSize, new AppThreadFactory("jobs"), new ThreadPoolExecutor.AbortPolicy());
    }

    private void createAppEventListener(AppEventId appEventId) {
        String jobId = AppJobManager.appEventJobId(appEventId);
        _Job job = new _Job(jobId, this);
        this.addJob(job);
        this.app().eventBus().bind(appEventId, new _AppEventListener(jobId, job));
    }

    private Runnable wrap(Runnable runnable) {
        return new ContextualJob(this.app().cuid(), runnable);
    }

    private Runnable wrap(final Callable callable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw E.unexpected((Throwable)e);
                }
            }
        };
    }

    private class ContextualJob
    extends _Job {
        private JobContext origin_;

        ContextualJob(String id, final Runnable runnable) {
            super(id, AppJobManager.this, (Osgl.Func0<?>)new Osgl.F0(){

                public Object apply() throws NotAppliedException, Osgl.Break {
                    runnable.run();
                    return null;
                }
            }, true);
            this.origin_ = JobContext.copy();
            AppJobManager.this.app().eventBus().once(MailerContext.InitEvent.class, new OnceEventListenerBase<MailerContext.InitEvent>(){

                @Override
                public boolean tryHandle(MailerContext.InitEvent event) throws Exception {
                    MailerContext mailerContext = MailerContext.current();
                    if (null != mailerContext) {
                        ContextualJob.this._before();
                        return true;
                    }
                    return true;
                }
            });
        }

        @Override
        protected void _before() {
            JobContext.init(this.origin_);
        }

        @Override
        protected void _finally() {
            JobContext.clear();
        }
    }

    private static class _AppEventListener
    extends AppEventListenerBase {
        private Runnable worker;

        _AppEventListener(String id, Runnable worker) {
            super(id);
            this.worker = (Runnable)$.NPE((Object)worker);
        }

        @Override
        public void on(EventObject event) throws Exception {
            this.worker.run();
        }

        @Override
        protected void releaseResources() {
            if (null != this.worker && this.worker instanceof Destroyable) {
                ((Destroyable)((Object)this.worker)).destroy();
            }
        }
    }
}

