/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.cli.Command;
import act.cli.JsonView;
import act.cli.Optional;
import act.cli.Required;
import act.cli.TableView;
import act.job.AppJobManager;
import act.job._Job;
import act.util.PropertySpec;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.osgl.Osgl;
import org.osgl.util.C;
import org.osgl.util.S;

public class JobAdmin {
    @Command(value="act.job.list", help="List jobs")
    @PropertySpec(value={"id,oneTime,executed,trigger"})
    @TableView
    public List<_Job> listJobs(final @Optional(lead={"-q"}) String q, AppJobManager jobManager) {
        C.List jobs = jobManager.jobs().append(jobManager.virtualJobs());
        if (S.notBlank((String)q)) {
            jobs = jobs.filter((Osgl.Function)new Osgl.Predicate<_Job>(){

                public boolean test(_Job job) {
                    return job.toString().contains(q);
                }
            });
        }
        return jobs;
    }

    @Command(value="act.job.show", help="Show job details")
    @JsonView
    @PropertySpec(value={"id,oneTime,executed,trigger,worker"})
    public _Job getJob(@Required(value="specify job id") String id, AppJobManager jobManager) {
        return jobManager.jobById(id);
    }

    @Command(name="act.job.cancel", help="Cancel a job")
    public void cancel(@Required(value="specify job id") String id, AppJobManager jobManager) {
        jobManager.cancel(id);
    }

    @Command(value="act.job.scheduler", help="Show Job manager scheduler status")
    public String getSchedulerStatus(AppJobManager jobManager) {
        ScheduledThreadPoolExecutor executor = jobManager.executor();
        JSONObject json = new JSONObject();
        json.put("is terminating", (Object)executor.isTerminating());
        json.put("is terminated", (Object)executor.isTerminated());
        json.put("is shutdown", (Object)executor.isShutdown());
        json.put("# of runnable in the queue", (Object)executor.getQueue().size());
        json.put("active count", (Object)executor.getActiveCount());
        json.put("# of completed tasks", (Object)executor.getActiveCount());
        json.put("core pool size", (Object)executor.getCorePoolSize());
        json.put("pool size", (Object)executor.getPoolSize());
        return json.toJSONString();
    }
}

