/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.app.App;
import act.app.AppHolderBase;
import act.app.event.AppEventId;
import act.job.AlongWith;
import act.job.AppJobManager;
import act.job.Cron;
import act.job.Every;
import act.job.FixedDelay;
import act.job.InvokeAfter;
import act.job.InvokeBefore;
import act.job.JobTrigger;
import act.job.OnAppEvent;
import act.job.OnAppStart;
import act.job.OnAppStop;
import act.job._Job;
import act.job.bytecode.ReflectedJobInvoker;
import act.job.meta.JobClassMetaInfo;
import act.job.meta.JobMethodMetaInfo;
import java.lang.annotation.Annotation;
import java.util.List;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.util.E;
import org.osgl.util.S;

public class JobAnnotationProcessor
extends AppHolderBase<JobAnnotationProcessor> {
    private AppJobManager manager;

    public JobAnnotationProcessor(App app) {
        super(app);
        this.manager = app.jobManager();
    }

    public void register(final JobMethodMetaInfo method, final Class<? extends Annotation> anno, final Object v) {
        if (this.isAbstract(method)) {
            this.app().jobManager().on(AppEventId.SINGLETON_PROVISIONED, new Runnable(){

                @Override
                public void run() {
                    List<JobMethodMetaInfo> list = method.extendedJobMethodMetaInfoList(JobAnnotationProcessor.this.app());
                    for (JobMethodMetaInfo subMethodInfo : list) {
                        JobAnnotationProcessor.this.register(subMethodInfo, anno, v);
                    }
                }
            });
            return;
        }
        _Job job = this.createMethodJob(method);
        if (Cron.class.isAssignableFrom(anno)) {
            this.registerCron(job, this.evaluateExpression(v.toString(), anno));
        } else if (AlongWith.class.isAssignableFrom(anno)) {
            this.registerAlongWith(job, v.toString());
        } else if (Every.class.isAssignableFrom(anno)) {
            this.registerEvery(job, this.evaluateExpression(v.toString(), anno));
        } else if (FixedDelay.class.isAssignableFrom(anno)) {
            this.registerFixedDelay(job, this.evaluateExpression(v.toString(), anno));
        } else if (InvokeAfter.class.isAssignableFrom(anno)) {
            this.registerInvokeAfter(job, v.toString());
        } else if (InvokeBefore.class.isAssignableFrom(anno)) {
            this.registerInvokeBefore(job, v.toString());
        } else if (OnAppStart.class.isAssignableFrom(anno)) {
            boolean async = null == v ? false : (Boolean)v;
            this.registerOnAppStart(job, async);
        } else if (OnAppStop.class.isAssignableFrom(anno)) {
            boolean async = null == v ? false : (Boolean)v;
            this.registerOnAppStop(job, async);
        } else if (OnAppEvent.class.isAssignableFrom(anno)) {
            AppEventId appEventId;
            boolean async = false;
            if (v instanceof Osgl.T2) {
                Osgl.T2 t2 = (Osgl.T2)$.cast((Object)v);
                appEventId = (AppEventId)((Object)t2._1);
                async = (Boolean)t2._2;
            } else {
                appEventId = (AppEventId)((Object)$.cast((Object)v));
            }
            this.registerOnAppEvent(job, appEventId, async);
        } else {
            throw E.unsupport((String)"Unknown job annotation class: %s", (Object[])new Object[]{anno.getName()});
        }
    }

    private String evaluateExpression(String expression, Class<? extends Annotation> annoClass) {
        String prefix = annoClass.getSimpleName();
        prefix = S.eq((String)FixedDelay.class.getName(), (String)prefix) ? "fixed-delay" : prefix.toLowerCase();
        String ret = expression.trim();
        if (ret.startsWith(prefix) && S.blank((String)(ret = (String)this.app().config().get(expression)))) {
            throw E.invalidConfiguration((String)"Expression configuration not found: %s", (Object[])new Object[]{expression});
        }
        return ret;
    }

    private void registerCron(_Job job, String expression) {
        JobTrigger.cron(expression).register(job, this.manager);
    }

    private void registerAlongWith(_Job job, String targetJobId) {
        JobTrigger.alongWith(targetJobId).register(job, this.manager);
    }

    private void registerEvery(_Job job, String expression) {
        JobTrigger.every(expression).register(job, this.manager);
    }

    private void registerFixedDelay(_Job job, String expression) {
        JobTrigger.fixedDelay(expression).register(job, this.manager);
    }

    private void registerInvokeAfter(_Job job, String targetJobId) {
        JobTrigger.after(targetJobId).register(job, this.manager);
    }

    private void registerInvokeBefore(_Job job, String targetJobId) {
        JobTrigger.before(targetJobId).register(job, this.manager);
    }

    private void registerOnAppStart(_Job job, boolean async) {
        JobTrigger.onAppStart(async).register(job, this.manager);
    }

    private void registerOnAppStop(_Job job, boolean async) {
        JobTrigger.onAppStop(async).register(job, this.manager);
    }

    private void registerOnAppEvent(_Job job, AppEventId appEventId, boolean async) {
        JobTrigger.onAppEvent(appEventId, async).register(job, this.manager);
    }

    private boolean isAbstract(JobMethodMetaInfo method) {
        JobClassMetaInfo classMetaInfo = method.classInfo();
        return classMetaInfo.isAbstract();
    }

    private _Job createMethodJob(JobMethodMetaInfo method) {
        String id = method.id();
        return new _Job(id, this.app().jobManager(), (Osgl.Func0<?>)new ReflectedJobInvoker<JobMethodMetaInfo>(method, this.app()), false);
    }
}

