/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.app.App;
import act.app.event.AppEventId;
import act.conf.AppConfig;
import act.event.AppEventListenerBase;
import act.job.AlongWith;
import act.job.AppJobManager;
import act.job.Cron;
import act.job.Every;
import act.job.FixedDelay;
import act.job.InvokeAfter;
import act.job.InvokeBefore;
import act.job.OnAppStart;
import act.job.OnAppStop;
import act.job._Job;
import fc.cron.CronExpression;
import java.util.EventObject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.osgl.Osgl;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.E;
import org.osgl.util.S;
import org.rythmengine.utils.Time;

abstract class JobTrigger {
    protected static Logger logger = L.get(App.class);

    JobTrigger() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    final void register(_Job job, AppJobManager manager) {
        job.trigger(this);
        manager.addJob(job);
        this.schedule(manager, job);
    }

    void scheduleFollowingCalls(AppJobManager manager, _Job job) {
    }

    void schedule(AppJobManager manager, _Job job) {
    }

    static JobTrigger of(AppConfig config, Cron anno) {
        String v = anno.value();
        if (v.startsWith("cron.")) {
            v = (String)config.get(v);
        } else if (v.startsWith("${") && v.endsWith("}")) {
            v = v.substring(2, v.length() - 1);
            v = (String)config.get(v);
        }
        if (S.blank((String)v)) {
            throw E.invalidConfiguration((String)"Cannot find configuration for cron: %s", (Object[])new Object[]{anno.value()});
        }
        return JobTrigger.cron(v);
    }

    static JobTrigger of(AppConfig config, OnAppStart anno) {
        if (anno.async()) {
            return JobTrigger.alongWith(AppEventId.START);
        }
        return JobTrigger.after(AppEventId.START);
    }

    static JobTrigger of(AppConfig config, OnAppStop anno) {
        if (anno.async()) {
            return JobTrigger.alongWith(AppEventId.STOP);
        }
        return JobTrigger.before(AppEventId.STOP);
    }

    static JobTrigger of(AppConfig config, FixedDelay anno) {
        String delay = anno.value();
        if (delay.startsWith("delay.")) {
            delay = (String)config.get(delay);
        } else if (delay.startsWith("${") && delay.endsWith("}")) {
            delay = delay.substring(2, delay.length() - 1);
            delay = (String)config.get(delay);
        }
        if (S.blank((String)delay)) {
            throw E.invalidConfiguration((String)"Cannot find configuration for delay: %s", (Object[])new Object[]{anno.value()});
        }
        return JobTrigger.fixedDelay(delay);
    }

    static JobTrigger of(AppConfig config, Every anno) {
        String duration = anno.value();
        if (duration.startsWith("every.")) {
            duration = (String)config.get(duration);
        } else if (duration.startsWith("${") && duration.endsWith("}")) {
            duration = duration.substring(2, duration.length() - 1);
            duration = (String)config.get(duration);
        }
        if (S.blank((String)duration)) {
            throw E.invalidConfiguration((String)"Cannot find configuration for duration: %s", (Object[])new Object[]{anno.value()});
        }
        return JobTrigger.every(duration);
    }

    static JobTrigger of(AppConfig config, AlongWith anno) {
        String id = anno.value();
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID cannot be empty");
        return new _AlongWith(id);
    }

    static JobTrigger of(AppConfig config, InvokeAfter anno) {
        String id = anno.value();
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID cannot be empty");
        return new _After(id);
    }

    static JobTrigger of(AppConfig config, InvokeBefore anno) {
        String id = anno.value();
        E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID cannot be empty");
        return new _Before(id);
    }

    static JobTrigger cron(String expression) {
        return new _Cron(expression);
    }

    static JobTrigger fixedDelay(String duration) {
        return new _FixedDelay(duration);
    }

    static JobTrigger fixedDelay(long seconds) {
        return new _FixedDelay(seconds);
    }

    static JobTrigger fixedDelay(long interval, TimeUnit timeUnit) {
        return new _FixedDelay(timeUnit.toSeconds(interval));
    }

    static JobTrigger every(String duration) {
        return new _Every(duration);
    }

    static JobTrigger every(long seconds) {
        return new _Every(seconds, TimeUnit.SECONDS);
    }

    static JobTrigger every(long duration, TimeUnit timeUnit) {
        return new _Every(duration, timeUnit);
    }

    static JobTrigger onAppStart(boolean async) {
        return async ? JobTrigger.alongWith(AppEventId.START) : JobTrigger.after(AppEventId.START);
    }

    static JobTrigger onAppStop(boolean async) {
        return async ? JobTrigger.alongWith(AppEventId.STOP) : JobTrigger.before(AppEventId.STOP);
    }

    static JobTrigger onAppEvent(AppEventId eventId, boolean async) {
        return async ? JobTrigger.alongWith(eventId) : JobTrigger.after(eventId);
    }

    static JobTrigger delayForSeconds(long seconds) {
        return new _FixedDelay(seconds);
    }

    static JobTrigger alongWith(String jobId) {
        return new _AlongWith(jobId);
    }

    static JobTrigger alongWith(AppEventId appEvent) {
        return new _AlongWith(AppJobManager.appEventJobId(appEvent));
    }

    static JobTrigger before(String jobId) {
        return new _Before(jobId);
    }

    static JobTrigger before(AppEventId appEvent) {
        return JobTrigger.before(AppJobManager.appEventJobId(appEvent));
    }

    static JobTrigger after(String jobId) {
        return new _After(jobId);
    }

    static JobTrigger after(AppEventId appEvent) {
        return JobTrigger.after(AppJobManager.appEventJobId(appEvent));
    }

    private static class _After
    extends _AssociatedTo {
        _After(String id) {
            super(id);
        }

        @Override
        public String toString() {
            return S.concat((String)"after ", (String)this.id);
        }

        @Override
        void associate(_Job theJob, _Job toJob) {
            toJob.addFollowingJob(theJob);
        }
    }

    private static class _Before
    extends _AssociatedTo {
        _Before(String id) {
            super(id);
        }

        @Override
        public String toString() {
            return S.concat((String)"before ", (String)this.id);
        }

        @Override
        void associate(_Job theJob, _Job toJob) {
            toJob.addPrecedenceJob(theJob);
        }
    }

    private static class _AlongWith
    extends _AssociatedTo {
        _AlongWith(String id) {
            super(id);
        }

        @Override
        public String toString() {
            return S.concat((String)"along with ", (String)this.id);
        }

        @Override
        void associate(_Job theJob, _Job toJob) {
            toJob.addParallelJob(theJob);
        }
    }

    private static abstract class _AssociatedTo
    extends JobTrigger {
        protected String id;

        _AssociatedTo(String id) {
            E.illegalArgumentIf((boolean)S.blank((String)id), (String)"associate job ID expected");
            this.id = id;
        }

        @Override
        void schedule(AppJobManager manager, _Job job) {
            if (null == this.id) {
                logger.warn("Failed to register job because target job not found: %s. Will try again after app started", new Object[]{this.id});
                this.scheduleDelayedRegister(manager, job);
            } else {
                _Job associateTarget = manager.jobById(this.id);
                if (null == associateTarget) {
                    logger.warn("Cannot find associated job: %s", new Object[]{this.id});
                } else {
                    this.associate(job, associateTarget);
                }
            }
        }

        private void scheduleDelayedRegister(final AppJobManager manager, final _Job job) {
            final String id = this.delayedRegisterJobId(job);
            _AssociatedTo.before(AppEventId.START).register(new _Job(id, manager, (Osgl.Func0<?>)new Osgl.F0<Void>(){

                public Void apply() throws NotAppliedException, Osgl.Break {
                    _Job associateTo = manager.jobById(id);
                    if (null == associateTo) {
                        logger.warn("Cannot find associated job: %s", new Object[]{id});
                    } else {
                        _AssociatedTo.this.associate(job, associateTo);
                    }
                    return null;
                }
            }), manager);
        }

        private String delayedRegisterJobId(_Job job) {
            return S.concat((String)"delayed_association_register-", (String)job.id(), (String)"-to-", (String)this.id);
        }

        abstract void associate(_Job var1, _Job var2);
    }

    private static class _Every
    extends _Periodical {
        _Every(String duration) {
            super(duration);
        }

        _Every(long duration, TimeUnit timeUnit) {
            super(timeUnit.toSeconds(duration));
        }

        @Override
        public String toString() {
            return S.concat((String)"every ", (String)S.string((Object)this.seconds), (String)" seconds");
        }

        @Override
        void schedule(final AppJobManager manager, final _Job job) {
            App app = manager.app();
            if (!app.isStarted()) {
                app.eventBus().bindAsync(AppEventId.POST_START, new AppEventListenerBase(){

                    @Override
                    public void on(EventObject event) throws Exception {
                        _Every.this.delayedSchedule(manager, job);
                    }
                });
            } else {
                this.delayedSchedule(manager, job);
            }
        }

        private void delayedSchedule(AppJobManager manager, _Job job) {
            ScheduledThreadPoolExecutor executor = manager.executor();
            ScheduledFuture<?> future = executor.scheduleAtFixedRate(job, this.seconds, this.seconds, TimeUnit.SECONDS);
            manager.futureScheduled(job.id(), future);
        }
    }

    private static class _FixedDelay
    extends _Periodical {
        _FixedDelay(String duration) {
            super(duration);
        }

        _FixedDelay(long seconds) {
            super(seconds);
        }

        @Override
        public String toString() {
            return S.concat((String)"fixed delay of ", (String)S.string((Object)this.seconds), (String)" seconds");
        }

        @Override
        void schedule(final AppJobManager manager, final _Job job) {
            App app = manager.app();
            if (!app.isStarted()) {
                app.eventBus().bindAsync(AppEventId.POST_START, new AppEventListenerBase(){

                    @Override
                    public void on(EventObject event) throws Exception {
                        _FixedDelay.this.delayedSchedule(manager, job);
                    }
                });
            } else {
                this.delayedSchedule(manager, job);
            }
        }

        private void delayedSchedule(AppJobManager manager, _Job job) {
            ScheduledThreadPoolExecutor executor = manager.executor();
            ScheduledFuture<?> future = executor.scheduleWithFixedDelay(job, this.seconds, this.seconds, TimeUnit.SECONDS);
            manager.futureScheduled(job.id(), future);
        }
    }

    private static abstract class _Periodical
    extends JobTrigger {
        protected long seconds;

        _Periodical(String duration) {
            E.illegalArgumentIf((boolean)S.blank((String)duration), (String)"delay duration shall not be empty");
            this.seconds = Time.parseDuration((String)duration);
            E.illegalArgumentIf((this.seconds < 1L ? 1 : 0) != 0, (String)"delay duration shall not be zero or negative number");
        }

        _Periodical(long seconds) {
            E.illegalArgumentIf((seconds < 1L ? 1 : 0) != 0, (String)"delay duration cannot be zero or negative");
            this.seconds = seconds;
        }
    }

    static class _Cron
    extends JobTrigger {
        private CronExpression cronExpr;

        _Cron(String expression) {
            this.cronExpr = new CronExpression(expression);
        }

        @Override
        public String toString() {
            return S.newBuffer((String)"cron :").a((Object)this.cronExpr).toString();
        }

        @Override
        void schedule(final AppJobManager manager, final _Job job) {
            App app = manager.app();
            if (!app.isStarted()) {
                app.eventBus().bindAsync(AppEventId.POST_START, new AppEventListenerBase(){

                    @Override
                    public void on(EventObject event) throws Exception {
                        _Cron.this.delayedSchedule(manager, job);
                    }
                });
            } else {
                this.delayedSchedule(manager, job);
            }
        }

        private void delayedSchedule(AppJobManager manager, _Job job) {
            DateTime now = DateTime.now();
            DateTime next = this.cronExpr.nextTimeAfter(now.plusSeconds(1));
            Seconds seconds = Seconds.secondsBetween((ReadableInstant)now, (ReadableInstant)next);
            ScheduledFuture<?> future = manager.executor().schedule(job, (long)seconds.getSeconds(), TimeUnit.SECONDS);
            manager.futureScheduled(job.id(), future);
        }

        @Override
        void scheduleFollowingCalls(AppJobManager manager, _Job job) {
            this.schedule(manager, job);
        }
    }
}

