/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.Act;
import act.app.App;
import act.app.event.AppEventId;
import act.event.AppEventListenerBase;
import act.job.AppJobManager;
import act.job.JobTrigger;
import act.route.DuplicateRouteMappingException;
import act.util.DestroyableBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.exception.ConfigurationException;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.UnexpectedException;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

class _Job
extends DestroyableBase
implements Runnable {
    private static final Logger logger = LogManager.get(_Job.class);
    static final String BRIEF_VIEW = "id,oneTime,executed,trigger";
    static final String DETAIL_VIEW = "id,oneTime,executed,trigger,worker";
    private static final C.Set<Class<? extends UnexpectedException>> FATAL_EXCEPTIONS = C.set(DuplicateRouteMappingException.class, (Object[])new Class[]{ConfigurationException.class});
    private String id;
    private App app;
    private boolean oneTime;
    private boolean executed;
    private AppJobManager manager;
    private JobTrigger trigger;
    private Osgl.Func0<?> worker;
    private LockableJobList parallelJobs = new LockableJobList(this);
    private LockableJobList followingJobs = new LockableJobList(this);
    private LockableJobList precedenceJobs = new LockableJobList(this);

    _Job(String id, AppJobManager manager) {
        this(id, manager, null);
    }

    _Job(String id, AppJobManager manager, Osgl.Func0<?> worker) {
        this(id, manager, worker, true);
    }

    _Job(String id, AppJobManager manager, Osgl.Func0<?> worker, boolean oneTime) {
        this.id = id;
        this.manager = (AppJobManager)$.NPE((Object)manager);
        this.worker = worker;
        this.oneTime = oneTime;
        this.app = manager.app();
    }

    @Override
    protected void releaseResources() {
        this.worker = null;
        this.manager = null;
        this.parallelJobs.clear();
        this.followingJobs.clear();
        this.precedenceJobs.clear();
        super.releaseResources();
    }

    protected String brief() {
        return S.concat((String)"job[", (String)"id", (String)"]\none time job?", (String)S.string((Object)this.oneTime), (String)"\trigger:", (String[])new String[]{this.trigger.toString()});
    }

    public String toString() {
        S.Buffer sb = S.buffer((String)this.brief());
        _Job.printSubJobs(this.parallelJobs.jobList, "parallel jobs", sb);
        _Job.printSubJobs(this.followingJobs.jobList, "following jobs", sb);
        _Job.printSubJobs(this.precedenceJobs.jobList, "precedence jobs", sb);
        return sb.toString();
    }

    private static void printSubJobs(Collection<? extends _Job> subJobs, String label, S.Buffer sb) {
        if (null != subJobs && !subJobs.isEmpty()) {
            sb.append("\n").append(label);
            for (_Job _Job2 : subJobs) {
                sb.append("\n\t").append(_Job2.brief());
            }
        }
    }

    _Job setOneTime() {
        this.oneTime = true;
        return this;
    }

    boolean isOneTime() {
        return this.oneTime;
    }

    boolean done() {
        return this.executed && this.oneTime;
    }

    final String id() {
        return this.id;
    }

    final void trigger(JobTrigger trigger) {
        E.NPE((Object)trigger);
        this.trigger = trigger;
    }

    final _Job addParallelJob(_Job thatJob) {
        return this.parallelJobs.add(thatJob);
    }

    final _Job addFollowingJob(_Job thatJob) {
        return this.followingJobs.add(thatJob);
    }

    final _Job addPrecedenceJob(_Job thatJob) {
        return this.precedenceJobs.add(thatJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block17: {
            this.invokeParallelJobs();
            this.runPrecedenceJobs();
            try {
                if (Act.isDev() && this.app.isStarted()) {
                    this.app.checkUpdates(false);
                }
                this.doJob();
            }
            catch (RuntimeException e) {
                block18: {
                    block19: {
                        try {
                            boolean isFatal = FATAL_EXCEPTIONS.contains(e.getClass());
                            Throwable cause = e;
                            if (!isFatal) {
                                for (cause = e.getCause(); null != cause && !(isFatal = FATAL_EXCEPTIONS.contains(cause.getClass())); cause = cause.getCause()) {
                                }
                            }
                            if (!isFatal) break block18;
                            if (Act.isDev()) {
                                this.app.setBlockIssue(e);
                                break block19;
                            }
                            Act.shutdownApp(App.instance());
                            this.destroy();
                            if (App.instance().isMainThread()) {
                                if (!(cause instanceof RuntimeException)) throw e;
                                throw (RuntimeException)cause;
                            }
                            logger.fatal(cause, "Fatal error executing job %s", new Object[]{this.id()});
                        }
                        catch (Throwable throwable) {
                            if (this.isDestroyed()) throw throwable;
                            this.executed = true;
                            if (!this.isOneTime()) throw throwable;
                            App app = App.instance();
                            if (app.isStarted()) {
                                this.manager.removeJob(this);
                                throw throwable;
                            }
                            app.eventBus().bind(AppEventId.POST_START, new AppEventListenerBase(){

                                @Override
                                public void on(EventObject event) throws Exception {
                                    _Job.this.manager.removeJob(_Job.this);
                                }
                            });
                            throw throwable;
                        }
                    }
                    if (this.isDestroyed()) return;
                    this.executed = true;
                    if (!this.isOneTime()) return;
                    App app = App.instance();
                    if (app.isStarted()) {
                        this.manager.removeJob(this);
                        return;
                    }
                    app.eventBus().bind(AppEventId.POST_START, new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                logger.warn((Throwable)e, "error executing job %s", new Object[]{this.id()});
                if (this.isDestroyed()) break block17;
                this.executed = true;
                if (!this.isOneTime()) break block17;
                App app = App.instance();
                if (app.isStarted()) {
                    this.manager.removeJob(this);
                } else {
                    app.eventBus().bind(AppEventId.POST_START, new /* invalid duplicate definition of identical inner class */);
                }
            }
            if (this.isDestroyed()) break block17;
            this.executed = true;
            if (this.isOneTime()) {
                App app = App.instance();
                if (app.isStarted()) {
                    this.manager.removeJob(this);
                } else {
                    app.eventBus().bind(AppEventId.POST_START, new /* invalid duplicate definition of identical inner class */);
                }
            }
        }
        this.runFollowingJobs();
    }

    protected void _before() {
    }

    protected void doJob() {
        try {
            this._before();
            if (null != this.worker) {
                this.worker.apply();
            }
        }
        finally {
            this.scheduleNextInvocation();
            this._finally();
        }
    }

    protected void _finally() {
    }

    protected void cancel() {
        this.manager.cancel(this.id());
    }

    private void runPrecedenceJobs() {
        this.precedenceJobs.runSubJobs();
    }

    private void runFollowingJobs() {
        this.followingJobs.runSubJobs();
    }

    private void invokeParallelJobs() {
        this.parallelJobs.runSubJobs();
    }

    protected final AppJobManager manager() {
        return this.manager;
    }

    protected void scheduleNextInvocation() {
        if (null != this.trigger) {
            this.trigger.scheduleFollowingCalls(this.manager(), this);
        }
    }

    private static _Job of(String jobId, final Runnable runnable, AppJobManager manager, boolean oneTime) {
        return new _Job(jobId, manager, (Osgl.Func0<?>)new Osgl.F0(){

            public Object apply() throws NotAppliedException, Osgl.Break {
                runnable.run();
                return null;
            }
        }, oneTime);
    }

    private static _Job of(Runnable runnable, AppJobManager manager, boolean oneTime) {
        return _Job.of(Act.cuid(), runnable, manager, oneTime);
    }

    static _Job once(Runnable runnable, AppJobManager manager) {
        return _Job.of(runnable, manager, true);
    }

    static _Job once(String jobId, Runnable runnable, AppJobManager manager) {
        return _Job.of(jobId, runnable, manager, true);
    }

    static _Job multipleTimes(Runnable runnable, AppJobManager manager) {
        return _Job.of(runnable, manager, false);
    }

    static _Job multipleTimes(String jobId, Runnable runnable, AppJobManager manager) {
        return _Job.of(jobId, runnable, manager, false);
    }

    private static String uuid() {
        return UUID.randomUUID().toString();
    }

    private static class LockableJobList {
        boolean iterating;
        List<_Job> jobList = new ArrayList<_Job>();
        _Job parent;

        LockableJobList(_Job parent) {
            this.parent = parent;
        }

        synchronized void clear() {
            this.jobList.clear();
        }

        synchronized _Job add(_Job thatJob) {
            if (this.parent.isOneTime()) {
                thatJob.setOneTime();
            }
            if (this.parent.done() || this.iterating) {
                this.parent.manager.now(thatJob);
                return this.parent;
            }
            this.jobList.add(thatJob);
            return this.parent;
        }

        synchronized void runSubJobs() {
            this.iterating = true;
            try {
                for (_Job subJob : this.jobList) {
                    subJob.run();
                }
            }
            finally {
                this.iterating = false;
            }
        }
    }
}

